/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageManager;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageSaveAdapter;
import com.pixelmonmod.pixelmon.api.storage.StorageSaveScheduler;
import com.pixelmonmod.pixelmon.blocks.tileentity.PCTileEntity;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;

public class StorageProxy {
    private static StorageManager storageManager;
    private static StorageSaveScheduler saveScheduler;
    private static StorageSaveAdapter saveAdapter;

    private StorageProxy() {
        throw new UnsupportedOperationException("Static proxy class");
    }

    public static StorageManager getStorageManager() {
        return storageManager;
    }

    public static void setStorageManager(StorageManager storageManager) {
        StorageProxy.storageManager = storageManager;
    }

    public static StorageSaveScheduler getSaveScheduler() {
        return saveScheduler;
    }

    public static void setSaveScheduler(StorageSaveScheduler saveScheduler) {
        StorageProxy.saveScheduler = saveScheduler;
    }

    public static StorageSaveAdapter getSaveAdapter() {
        return saveAdapter;
    }

    public static void setSaveAdapter(StorageSaveAdapter saveAdapter) {
        StorageProxy.saveAdapter = saveAdapter;
    }

    public static Iterable<PokemonStorage> getAllCachedStorages() {
        return StorageProxy.getStorageManager().getAllCachedStorages();
    }

    public static void clearAll() {
        StorageProxy.getStorageManager().clearAll();
    }

    @Nullable
    public static PCStorage getPCForPlayerNow(ServerPlayer player) {
        return StorageProxy.getStorageManager().getPCForPlayerNow(player);
    }

    public static CompletableFuture<PCStorage> getPCForPlayer(ServerPlayer player) {
        return StorageProxy.getStorageManager().getPCForPlayer(player);
    }

    @Nullable
    public static PCStorage getPCForPlayerNow(UUID uuid) {
        return StorageProxy.getStorageManager().getPCForPlayerNow(uuid);
    }

    public static CompletableFuture<PCStorage> getPCForPlayer(UUID uuid) {
        return StorageProxy.getStorageManager().getPCForPlayer(uuid);
    }

    @Nullable
    public static PCStorage getPCNow(ServerPlayer player, PCTileEntity pc) {
        return StorageProxy.getStorageManager().getPCNow(player, pc);
    }

    public static CompletableFuture<PCStorage> getPC(ServerPlayer player, PCTileEntity pc) {
        return StorageProxy.getStorageManager().getPC(player, pc);
    }

    @Nullable
    public static PlayerPartyStorage getPartyNow(ServerPlayer player) {
        return StorageProxy.getStorageManager().getPartyNow(player);
    }

    public static CompletableFuture<PlayerPartyStorage> getParty(ServerPlayer player) {
        return StorageProxy.getStorageManager().getParty(player);
    }

    @Nullable
    public static PlayerPartyStorage getPartyNow(UUID uuid) {
        return StorageProxy.getStorageManager().getPartyNow(uuid);
    }

    public static CompletableFuture<PlayerPartyStorage> getParty(UUID uuid) {
        return StorageProxy.getStorageManager().getParty(uuid);
    }

    public static CompletableFuture<PokemonStorage> getStorage(ServerPlayer player, StoragePosition position) {
        return StorageProxy.getStorageManager().getStorage(player, position);
    }

    public static PokemonStorage getStorageNow(ServerPlayer player, StoragePosition position) {
        return StorageProxy.getStorageManager().getStorageNow(player, position);
    }

    public static CompletableFuture<Pokemon> getPokemon(ServerPlayer player, StoragePosition position) {
        return StorageProxy.getStorageManager().getPokemon(player, position);
    }

    public static void initializePCForPlayer(ServerPlayer player, PCStorage pc) {
        StorageProxy.getStorageManager().initializePCForPlayer(player, pc);
    }
}

