/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.PCTileEntity;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ClientInitializePCPacket;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;

public interface StorageManager {
    public Iterable<PokemonStorage> getAllCachedStorages();

    public void clearAll();

    @Nullable
    default public PCStorage getPCForPlayerNow(ServerPlayer player) {
        return this.getPCForPlayer(player).join();
    }

    default public CompletableFuture<PCStorage> getPCForPlayer(ServerPlayer player) {
        return this.getPCForPlayer(player.m_20148_());
    }

    @Nullable
    default public PCStorage getPCForPlayerNow(UUID uuid) {
        return this.getPCForPlayer(uuid).join();
    }

    public CompletableFuture<PCStorage> getPCForPlayer(UUID var1);

    @Nullable
    default public PCStorage getPCNow(ServerPlayer player, PCTileEntity pc) {
        return this.getPC(player, pc).join();
    }

    default public CompletableFuture<PCStorage> getPC(ServerPlayer player, PCTileEntity pc) {
        return this.getPCForPlayer(player);
    }

    @Nullable
    default public PlayerPartyStorage getPartyNow(ServerPlayer player) {
        return this.getParty(player).join();
    }

    default public CompletableFuture<PlayerPartyStorage> getParty(ServerPlayer player) {
        return this.getParty(player.m_20148_());
    }

    @Nullable
    default public PlayerPartyStorage getPartyNow(UUID uuid) {
        return this.getParty(uuid).join();
    }

    public CompletableFuture<PlayerPartyStorage> getParty(UUID var1);

    default public PokemonStorage getStorageNow(ServerPlayer player, StoragePosition position) {
        return this.getStorage(player, position).join();
    }

    default public CompletableFuture<PokemonStorage> getStorage(ServerPlayer player, StoragePosition position) {
        if (position.box == -1) {
            return this.getParty(player).thenApply(Function.identity());
        }
        return this.getPCForPlayer(player).thenApply(Function.identity());
    }

    default public CompletableFuture<Pokemon> getPokemon(ServerPlayer player, StoragePosition position) {
        if (position.box == -1) {
            return this.getParty(player).thenApply(playerPartyStorage -> playerPartyStorage.get(position));
        }
        return this.getPCForPlayer(player).thenApply(pcStorage -> pcStorage.get(position));
    }

    default public void initializePCForPlayer(ServerPlayer player, PCStorage pc) {
        NetworkHelper.sendPacket(player, new ClientInitializePCPacket(pc));
        pc.sendContents(player);
    }
}

