/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class PlayerStats {
    private int wins;
    private int losses;
    private int totalExp;
    private int totalKills;
    private int currentExp;
    private int currentKills;
    private int totalBred;
    private int totalHatched;
    private int totalEvolved;
    private HashMap<String, Integer> caughtTypeCount = new HashMap();

    public PlayerStats() {
        for (Element type : Element.values()) {
            this.caughtTypeCount.put(type.getName(), 0);
        }
    }

    public static void getNBTTags(HashMap<String, Class> tags) {
        tags.put("Wins", Integer.class);
        tags.put("Losses", Integer.class);
        tags.put("TotalExp", Integer.class);
        tags.put("CurrentExp", Integer.class);
        tags.put("TotalKills", Integer.class);
        tags.put("CurrentKills", Integer.class);
        tags.put("TotalBred", Integer.class);
        tags.put("TotalHatched", Integer.class);
        tags.put("CaughtTypeCount", CompoundTag.class);
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128405_("Wins", this.wins);
        nbt.m_128405_("Losses", this.losses);
        nbt.m_128405_("TotalExp", this.totalExp);
        nbt.m_128405_("CurrentExp", this.currentExp);
        nbt.m_128405_("TotalKills", this.totalKills);
        nbt.m_128405_("CurrentKills", this.currentKills);
        nbt.m_128405_("TotalBred", this.totalBred);
        nbt.m_128405_("TotalHatched", this.totalHatched);
        CompoundTag caughtTypeNBT = new CompoundTag();
        this.caughtTypeCount.forEach((arg_0, arg_1) -> ((CompoundTag)caughtTypeNBT).m_128405_(arg_0, arg_1));
        nbt.m_128365_("CaughtTypeCount", (Tag)caughtTypeNBT);
    }

    public void readFromNBT(CompoundTag nbt) {
        this.wins = nbt.m_128451_("Wins");
        this.losses = nbt.m_128451_("Losses");
        this.totalExp = nbt.m_128451_("TotalExp");
        this.currentExp = nbt.m_128451_("CurrentExp");
        this.totalKills = nbt.m_128451_("TotalKills");
        this.currentKills = nbt.m_128451_("CurrentKills");
        this.totalBred = nbt.m_128451_("TotalBred");
        this.totalHatched = nbt.m_128451_("TotalHatched");
        CompoundTag caughtTypeNBT = nbt.m_128441_("CaughtTypeCount") ? nbt.m_128469_("CaughtTypeCount") : new CompoundTag();
        for (Element type : Element.values()) {
            int count = 0;
            if (caughtTypeNBT.m_128441_(type.getName())) {
                count = caughtTypeNBT.m_128451_(type.getName());
            }
            this.caughtTypeCount.put(type.getName(), count);
        }
    }

    public void addWin() {
        ++this.wins;
    }

    public void addLoss() {
        ++this.losses;
    }

    public void addKill() {
        ++this.totalKills;
        ++this.currentKills;
    }

    public int getCurrentKills() {
        return this.currentKills;
    }

    public void setCurrentKills(int currentKills) {
        this.currentKills = currentKills;
    }

    public int getTotalExp() {
        return this.totalExp;
    }

    public void setTotalExp(int totalExp) {
        this.totalExp = totalExp;
    }

    public int getTotalKills() {
        return this.totalKills;
    }

    public void setTotalKills(int totalKills) {
        this.totalKills = totalKills;
    }

    public int getCurrentExp() {
        return this.currentExp;
    }

    public void setCurrentExp(int currentExp) {
        this.currentExp = currentExp;
    }

    public int getWins() {
        return this.wins;
    }

    public void setWins(int wins) {
        this.wins = wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public void setLosses(int losses) {
        this.losses = losses;
    }

    public void addExp(int amount) {
        this.totalExp += amount;
        this.currentExp += amount;
    }

    public void setExp(int exp) {
        this.currentExp = exp;
    }

    public void resetWinLoss() {
        this.wins = 0;
        this.losses = 0;
    }

    public int getTotalBred() {
        return this.totalBred;
    }

    public void setTotalBred(int totalBred) {
        this.totalBred = totalBred;
    }

    public void addToTotalBred() {
        ++this.totalBred;
    }

    public int getTotalHatched() {
        return this.totalHatched;
    }

    public void setTotalHatched(int totalHatched) {
        this.totalHatched = totalHatched;
    }

    public void addHatched() {
        ++this.totalHatched;
    }

    public int getTotalEvolved() {
        return this.totalEvolved;
    }

    public void setTotalEvolved(int totalEvolved) {
        this.totalEvolved = totalEvolved;
    }

    public HashMap<String, Integer> getCaughtTypeCount() {
        return this.caughtTypeCount;
    }

    public void setCaughtTypeCount(HashMap<String, Integer> caughtTypeCount) {
        this.caughtTypeCount = caughtTypeCount;
    }

    public void addCaughtType(Element type) {
        int count = this.caughtTypeCount.get(type.getName()) + 1;
        this.caughtTypeCount.put(type.getName(), count);
    }

    public void addCaughtTypes(List<Element> types) {
        for (Element type : types) {
            int count = this.caughtTypeCount.get(type.getName()) + 1;
            this.caughtTypeCount.put(type.getName(), count);
        }
    }
}

