/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.TickHandler;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountManager;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageManager;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PixelmonStorageManager
implements StorageManager,
BankAccountManager {
    protected final Map<UUID, PlayerPartyStorage> parties = Maps.newConcurrentMap();
    protected final Map<UUID, PCStorage> pcs = Maps.newConcurrentMap();
    protected final Map<UUID, PlayerDataLoading> waitingToLoad = Maps.newConcurrentMap();

    @Override
    public CompletableFuture<PlayerPartyStorage> getParty(UUID uuid) {
        PlayerPartyStorage playerPartyStorage = this.parties.get(uuid);
        if (playerPartyStorage != null) {
            return CompletableFuture.completedFuture(playerPartyStorage);
        }
        PlayerDataLoading playerDataLoading = this.waitingToLoad.get(uuid);
        if (playerDataLoading != null && playerDataLoading.getPartyFuture() != null) {
            return playerDataLoading.getPartyFuture();
        }
        return this.loadData(uuid, true, false).getPartyFuture();
    }

    @Override
    public CompletableFuture<PCStorage> getPCForPlayer(UUID uuid) {
        PCStorage pc = this.pcs.get(uuid);
        if (pc != null) {
            return CompletableFuture.completedFuture(pc);
        }
        PlayerDataLoading playerDataLoading = this.waitingToLoad.get(uuid);
        if (playerDataLoading != null && playerDataLoading.getPcFuture() != null) {
            return playerDataLoading.getPcFuture();
        }
        return this.loadData(uuid, false, true).getPcFuture();
    }

    @Override
    public Iterable<PokemonStorage> getAllCachedStorages() {
        ArrayList allStorages = Lists.newArrayListWithCapacity((int)(this.parties.size() + this.pcs.size()));
        allStorages.addAll(this.parties.values());
        allStorages.addAll(this.pcs.values());
        return allStorages;
    }

    @Override
    public void clearAll() {
        this.pcs.clear();
        this.parties.clear();
        for (PlayerDataLoading value : this.waitingToLoad.values()) {
            if (value.partyFuture != null) {
                value.partyFuture.cancel(true);
            }
            if (value.pcFuture == null) continue;
            value.pcFuture.cancel(true);
        }
        this.waitingToLoad.clear();
    }

    @Override
    public CompletableFuture<? extends BankAccount> getBankAccount(UUID uuid) {
        return this.getParty(uuid);
    }

    @Override
    public CompletableFuture<? extends BankAccount> getBankAccount(ServerPlayer player) {
        return this.getBankAccount(player.m_20148_());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.getParty(event.getEntity().m_20148_()).whenComplete((playerPartyStorage, throwable) -> {
            playerPartyStorage.tryUpdatePlayerName();
            if (playerPartyStorage.countAll() == 0 && !playerPartyStorage.starterPicked && PixelmonConfigProxy.getGeneral().isStarterOnJoin() && playerPartyStorage.getPlayer() != null) {
                TickHandler.registerStarterList(playerPartyStorage.getPlayer());
            }
        });
        this.getPCForPlayer(event.getEntity().m_20148_()).whenComplete((pcStorage, throwable) -> {
            pcStorage.setPlayer(event.getEntity().m_20148_(), event.getEntity().m_7755_().getString());
            for (ServerPlayer player : pcStorage.getPlayersToUpdate()) {
                this.initializePCForPlayer(player, (PCStorage)pcStorage);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerLogin(PlayerEvent.LoadFromFile event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        UUID uuid = event.getEntity().m_20148_();
        PlayerPartyStorage party = this.parties.get(uuid);
        PCStorage pc = this.pcs.get(uuid);
        if (pc == null || party == null) {
            this.loadData(uuid, party == null, pc == null);
        }
    }

    protected PlayerDataLoading loadData(UUID uuid, boolean party, boolean pc) {
        PlayerDataLoading dataLoading = new PlayerDataLoading();
        if (party) {
            dataLoading.withParty((CompletableFuture<PlayerPartyStorage>)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(StorageProxy::getSaveAdapter).thenComposeAsync(saveAdapter -> saveAdapter.load(uuid, PlayerPartyStorage.class), StorageProxy.getSaveScheduler().getScheduler())).whenComplete((playerPartyStorage, throwable) -> this.parties.put(uuid, (PlayerPartyStorage)playerPartyStorage))).exceptionally(throwable -> {
                Pixelmon.LOGGER.error("Error occurred whilst loading party storage for " + uuid.toString(), throwable);
                return null;
            }));
        }
        if (pc) {
            dataLoading.withPC((CompletableFuture<PCStorage>)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(StorageProxy::getSaveAdapter).thenComposeAsync(saveAdapter -> saveAdapter.load(uuid, PCStorage.class), StorageProxy.getSaveScheduler().getScheduler())).whenComplete((pcStorage, throwable) -> this.pcs.put(uuid, (PCStorage)pcStorage))).exceptionally(throwable -> {
                Pixelmon.LOGGER.error("Error occurred whilst loading PC storage for " + uuid.toString(), throwable);
                return null;
            }));
        }
        this.waitingToLoad.put(uuid, dataLoading);
        return dataLoading;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.waitingToLoad.remove(event.getEntity().m_20148_());
        PlayerPartyStorage party = this.parties.remove(event.getEntity().m_20148_());
        PCStorage pc = this.pcs.remove(event.getEntity().m_20148_());
        if (party != null) {
            StorageProxy.getSaveScheduler().save(party);
        }
        if (pc != null) {
            StorageProxy.getSaveScheduler().save(pc);
        }
    }

    public static class PlayerDataLoading {
        protected CompletableFuture<PlayerPartyStorage> partyFuture = null;
        protected CompletableFuture<PCStorage> pcFuture = null;

        protected PlayerDataLoading() {
        }

        public PlayerDataLoading withParty(CompletableFuture<PlayerPartyStorage> partyFuture) {
            this.partyFuture = partyFuture;
            return this;
        }

        public PlayerDataLoading withPC(CompletableFuture<PCStorage> pcFuture) {
            this.pcFuture = pcFuture;
            return this;
        }

        public CompletableFuture<PlayerPartyStorage> getPartyFuture() {
            return this.partyFuture;
        }

        public CompletableFuture<PCStorage> getPcFuture() {
            return this.pcFuture;
        }
    }
}

