/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCBox;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class PCStorage
extends PokemonStorage {
    protected PCBox[] boxes;
    protected int lastBox = 0;
    public UUID playerUUID = null;
    public String playerName = null;
    protected transient StoragePosition cachePosition = new StoragePosition(0, 0);

    public PCStorage(UUID uuid, int boxes) {
        super(uuid);
        this.boxes = new PCBox[boxes];
        for (int i = 0; i < boxes; ++i) {
            this.boxes[i] = new PCBox(this, i);
        }
    }

    public PCStorage(UUID uuid) {
        this(uuid, PixelmonConfigProxy.getStorage().getComputerBoxes(uuid));
    }

    public void setPlayer(UUID playerUUID, String playerName) {
        this.playerUUID = playerUUID;
        this.playerName = playerName;
    }

    public void setBoxCount(int boxes) {
        int i;
        PCBox[] oldBoxes = this.boxes;
        this.boxes = new PCBox[boxes];
        for (i = 0; i < oldBoxes.length; ++i) {
            if (i >= boxes) continue;
            this.boxes[i] = oldBoxes[i];
        }
        for (i = oldBoxes.length; i < boxes; ++i) {
            this.boxes[i] = new PCBox(this, i);
        }
    }

    public int getLastBox() {
        return this.lastBox;
    }

    public void setLastBox(int lastBox) {
        this.lastBox = lastBox;
    }

    public PCBox[] getBoxes() {
        return (PCBox[])this.boxes.clone();
    }

    public PCBox getBox(int boxNumber) {
        if (boxNumber < 0 || boxNumber >= this.boxes.length) {
            return this.boxes[0];
        }
        return this.boxes[boxNumber];
    }

    public int getBoxCount() {
        return this.boxes.length;
    }

    @Override
    public Pokemon[] getAll() {
        ArrayList<Pokemon> all = new ArrayList<Pokemon>();
        for (PCBox box : this.boxes) {
            all.addAll(Arrays.asList(box.getAll()));
        }
        return all.toArray(new Pokemon[0]);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        if (this.playerName != null) {
            nbt.m_128359_("player", this.playerName);
        }
        for (int i = 0; i < this.boxes.length; ++i) {
            if (this.boxes[i] == null) continue;
            nbt.m_128365_("BoxNumber" + i, (Tag)this.boxes[i].writeToNBT(new CompoundTag()));
        }
        nbt.m_128376_("lastBoxOpen", (short)this.lastBox);
        return nbt;
    }

    public CompletableFuture<PCStorage> readFromNBT(CompoundTag nbt) {
        ArrayList futures = Lists.newArrayList();
        this.playerName = nbt.m_128461_("player");
        for (int i = 0; i < this.boxes.length; ++i) {
            int boxId = i;
            if (nbt.m_128441_("BoxNumber" + boxId)) {
                futures.add(new PCBox(this, boxId).readFromNBT(nbt.m_128469_("BoxNumber" + boxId)).thenApply(pcBox -> {
                    this.boxes[boxId] = pcBox;
                    return this.boxes[boxId];
                }));
                continue;
            }
            if (nbt.m_128441_(String.valueOf(boxId))) {
                futures.add(new PCBox(this, boxId).readFromNBT(nbt.m_128469_(String.valueOf(boxId))).thenApply(pcBox -> {
                    this.boxes[boxId] = pcBox;
                    return this.boxes[boxId];
                }));
                continue;
            }
            futures.add(CompletableFuture.completedFuture(new PCBox(this, boxId)).thenApply(pcBox -> {
                this.boxes[boxId] = pcBox;
                return this.boxes[boxId];
            }));
        }
        this.lastBox = nbt.m_128448_("lastBoxOpen");
        if (this.lastBox >= this.boxes.length || this.lastBox < 0) {
            this.lastBox = this.boxes.length - 1;
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(unused -> this);
    }

    @Override
    public StoragePosition getFirstEmptyPosition() {
        PCBox box = this.boxes[this.lastBox];
        if (box != null && box.hasSpace()) {
            return new StoragePosition(this.lastBox, box.getFirstEmptyPosition().order);
        }
        for (int i = 0; i < this.boxes.length; ++i) {
            if (i == this.lastBox || !this.boxes[i].hasSpace()) continue;
            return new StoragePosition(i, this.boxes[i].getFirstEmptyPosition().order);
        }
        return null;
    }

    @Override
    public void set(StoragePosition position, Pokemon pokemon) {
        this.boxes[position.box].set(position, pokemon);
        this.setNeedsSaving();
        if (!this.getShouldSendUpdates() || this.playerUUID == null || pokemon == null || pokemon.isEgg()) {
            return;
        }
        StorageProxy.getParty(this.playerUUID).thenAccept(partyStorage -> {
            if (partyStorage.playerPokedex.getSeenMap().get(pokemon.getSpecies().getDex()) == PokedexRegistrationStatus.CAUGHT) {
                return;
            }
            PokedexEvent.Pre preEvent = new PokedexEvent.Pre(this.uuid, pokemon, PokedexRegistrationStatus.CAUGHT, "storageMovement");
            if (!Pixelmon.EVENT_BUS.post((Event)preEvent)) {
                partyStorage.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
                partyStorage.playerPokedex.update();
                partyStorage.setNeedsSaving();
                Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(this.uuid, preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
            }
        });
    }

    public void set(int box, int slot, Pokemon pokemon) {
        this.set(new StoragePosition(box, slot), pokemon);
    }

    @Override
    @Nullable
    public Pokemon get(StoragePosition position) {
        return this.boxes[position.box].pokemon[position.order];
    }

    @Nullable
    public Pokemon get(int box, int slot) {
        return this.get(this.cachePosition.set(box, slot));
    }

    @Override
    public void swap(StoragePosition position1, StoragePosition position2) {
        if (position1.box == position2.box) {
            this.boxes[position1.box].swap(position1, position2);
        } else {
            Pokemon temp = this.boxes[position1.box].get(position1);
            this.boxes[position1.box].pokemon[position1.order] = this.boxes[position2.box].get(position2);
            this.boxes[position2.box].pokemon[position2.order] = temp;
            Pokemon pokemon1 = this.get(position1);
            Pokemon pokemon2 = this.get(position2);
            if (pokemon1 != null) {
                pokemon1.setStorage(this, position1);
            }
            if (pokemon2 != null) {
                pokemon2.setStorage(this, position2);
            }
            this.notifyListeners(position1, pokemon1, new EnumUpdateType[0]);
            this.notifyListeners(position2, pokemon2, new EnumUpdateType[0]);
        }
        this.setNeedsSaving();
    }

    public void swap(int box1, int slot1, int box2, int slot2) {
        this.swap(new StoragePosition(box1, slot1), new StoragePosition(box2, slot2));
    }

    @Override
    public StoragePosition getPosition(Pokemon pokemon) {
        for (PCBox box : this.boxes) {
            StoragePosition position;
            if (box == null || (position = box.getPosition(pokemon)) == null) continue;
            return position;
        }
        return null;
    }

    @Override
    public List<ServerPlayer> getPlayersToUpdate() {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.uuid);
        return player == null ? Collections.emptyList() : Collections.singletonList(player);
    }

    @Override
    public File getFile() {
        return new File(ServerLifecycleHooks.getCurrentServer().m_129880_((ResourceKey)Level.f_46428_).m_8895_().f_78146_, "pokemon/" + this.uuid.toString() + ".comp");
    }

    @Override
    public boolean getShouldSave() {
        if (this.hasChanged) {
            return true;
        }
        for (PCBox box : this.boxes) {
            if (!box.hasChanged) continue;
            return true;
        }
        return this.playerUUID != null && ServerLifecycleHooks.getCurrentServer() != null && ServerLifecycleHooks.getCurrentServer().m_6846_() != null && ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.playerUUID) == null;
    }

    @Override
    public void setHasChanged(boolean hasChanged) {
        super.setHasChanged(hasChanged);
        if (!hasChanged) {
            for (PCBox box : this.boxes) {
                box.setHasChanged(false);
            }
        }
    }

    public void sendContents(ServerPlayer player) {
        for (PCBox box : this.boxes) {
            if (box == null) continue;
            box.sendContents(player);
        }
    }

    @Override
    @NotNull
    public Iterator<Pokemon> iterator() {
        return Arrays.stream(this.getAll()).iterator();
    }

    @Override
    public void clear() {
        for (PCBox box : this.boxes) {
            if (box == null) continue;
            box.clear();
        }
    }
}

