/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.ClientSetPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ServerUpdateBoxPacket;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class PCBox
extends PokemonStorage {
    public static final int POKEMON_PER_BOX = 30;
    public transient PCStorage pc;
    public transient int boxNumber;
    protected Pokemon[] pokemon = new Pokemon[30];
    protected String name;
    protected String wallpaper;
    protected transient StoragePosition cachePosition = new StoragePosition(0, 0);
    public transient boolean hasChangedClientSide = false;

    public PCBox() {
        super(UUID.randomUUID());
    }

    public PCBox(PCStorage pc, int boxNumber) {
        super(pc.uuid);
        this.pc = pc;
        this.boxNumber = boxNumber;
    }

    @Override
    public Pokemon[] getAll() {
        return Arrays.copyOf(this.pokemon, 30);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        for (int i = 0; i < this.pokemon.length; ++i) {
            if (this.pokemon[i] == null) continue;
            nbt.m_128365_("pc" + i, (Tag)this.pokemon[i].writeToNBT(new CompoundTag()));
        }
        if (this.name != null && !this.name.isEmpty()) {
            nbt.m_128359_("name", this.name);
        }
        if (this.wallpaper != null && !this.wallpaper.isEmpty() && !this.wallpaper.equals("default")) {
            nbt.m_128359_("wallpaper", this.wallpaper);
        }
        return nbt;
    }

    public CompletableFuture<PCBox> readFromNBT(CompoundTag nbt) {
        return CompletableFuture.runAsync(() -> {
            for (int i = 0; i < 30; ++i) {
                if (nbt.m_128441_("pc" + i)) {
                    this.pokemon[i] = PokemonFactory.create(nbt.m_128469_("pc" + i));
                    this.pokemon[i].setStorage(this, new StoragePosition(this.boxNumber, i));
                    continue;
                }
                this.pokemon[i] = null;
            }
            if (nbt.m_128441_("name")) {
                this.name = nbt.m_128461_("name");
                if (this.name.isEmpty()) {
                    this.name = null;
                }
            }
            if (nbt.m_128441_("wallpaper")) {
                this.wallpaper = nbt.m_128461_("wallpaper");
                if (this.wallpaper.isEmpty() || this.wallpaper.equals("default")) {
                    this.wallpaper = null;
                }
            }
        }, StorageProxy.getSaveScheduler().getScheduler()).thenApply(unused -> this);
    }

    @Override
    public StoragePosition getPosition(Pokemon pokemon) {
        for (int i = 0; i < 30; ++i) {
            if (this.pokemon[i] != pokemon && (this.pokemon[i] == null || !this.pokemon[i].getUUID().equals(pokemon.getUUID()))) continue;
            return new StoragePosition(this.boxNumber, i);
        }
        return null;
    }

    @Override
    public List<ServerPlayer> getPlayersToUpdate() {
        return this.pc.getPlayersToUpdate();
    }

    public int getSlot(Pokemon pokemon) {
        for (int i = 0; i < 30; ++i) {
            if (this.pokemon[i] != pokemon) continue;
            return i;
        }
        return -1;
    }

    @Override
    public File getFile() {
        return this.pc.getFile();
    }

    @Override
    @Nullable
    public StoragePosition getFirstEmptyPosition() {
        for (int i = 0; i < 30; ++i) {
            if (this.pokemon[i] != null) continue;
            return new StoragePosition(this.boxNumber, i);
        }
        return null;
    }

    @Override
    public void set(StoragePosition position, Pokemon pokemon) {
        this.pokemon[position.order] = pokemon;
        this.setNeedsSaving();
        this.notifyListeners(position, pokemon, new EnumUpdateType[0]);
        if (pokemon != null) {
            pokemon.setStorage(this, position);
            if (this.pc.playerName != null && (pokemon.getOriginalTrainer() == null || pokemon.getOriginalTrainer().equals(this.pc.playerName) && pokemon.getOriginalTrainerUUID() == null)) {
                pokemon.setOriginalTrainer(this.uuid, this.pc.playerName);
            }
        }
    }

    public void set(int slot, Pokemon pokemon) {
        this.set(new StoragePosition(this.boxNumber, slot), pokemon);
    }

    @Override
    @Nullable
    public Pokemon get(StoragePosition position) {
        return this.pokemon[position.order];
    }

    @Nullable
    public Pokemon get(int slot) {
        return this.get(this.cachePosition.set(this.boxNumber, slot));
    }

    @Override
    public void swap(StoragePosition position1, StoragePosition position2) {
        Pokemon temp = this.pokemon[position1.order];
        this.pokemon[position1.order] = this.pokemon[position2.order];
        this.pokemon[position2.order] = temp;
        this.setNeedsSaving();
        if (this.pokemon[position1.order] != null) {
            this.pokemon[position1.order].setStorage(this, position1);
        }
        if (this.pokemon[position2.order] != null) {
            this.pokemon[position2.order].setStorage(this, position2);
        }
        this.notifyListeners(position1, this.pokemon[position1.order], new EnumUpdateType[0]);
        this.notifyListeners(position2, this.pokemon[position2.order], new EnumUpdateType[0]);
    }

    public void swap(int slot1, int slot2) {
        this.swap(new StoragePosition(this.boxNumber, slot1), new StoragePosition(this.boxNumber, slot2));
    }

    public void sendContents(ServerPlayer player) {
        for (int slot = 0; slot < 30; ++slot) {
            Pokemon pokemon = this.get(slot);
            if (pokemon == null) continue;
            NetworkHelper.sendPacket(new ClientSetPacket(this, new StoragePosition(this.boxNumber, slot), pokemon, EnumUpdateType.CLIENT), player);
        }
    }

    @Override
    public boolean getShouldSendUpdates() {
        if (this.shouldSendUpdates) {
            return this.pc.getShouldSendUpdates();
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getWallpaper() {
        return this.wallpaper;
    }

    @Override
    @NotNull
    public Iterator<Pokemon> iterator() {
        return Arrays.stream(this.pokemon).iterator();
    }

    @Override
    public void clear() {
        for (int i = 0; i < 30; ++i) {
            this.set(i, null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendChangesToServer() {
        if (this.hasChangedClientSide) {
            NetworkHelper.sendToServer(new ServerUpdateBoxPacket(this.boxNumber, this.name, this.wallpaper));
        }
        this.hasChangedClientSide = false;
    }

    private void updateValue(Object oldValue, Object newValue) {
        if (oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue) || newValue != null && !newValue.equals(oldValue)) {
            this.setNeedsSaving();
            this.hasChangedClientSide = true;
        }
    }

    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            name = null;
        }
        this.updateValue(this.name, name);
        this.name = name;
    }

    public void setWallpaper(String wallpaper) {
        if (wallpaper == null || wallpaper.isEmpty() || wallpaper.equals("default")) {
            wallpaper = null;
        }
        this.updateValue(this.wallpaper, wallpaper);
        this.wallpaper = wallpaper;
    }
}

