/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.conditions;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawnTime;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.tags.TagsHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagEntry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.FlatLevelSource;

public class SpawnCondition {
    public static Class<? extends SpawnCondition> targetedSpawnCondition = SpawnCondition.class;
    public ArrayList<WorldTime> times = null;
    public ArrayList<WeatherType> weathers = null;
    private ArrayList<SpawnTime> realWorldSpawnTimes = null;
    public Set<TagEntry> baseBlocks = Sets.newHashSet();
    public Set<TagEntry> neededNearbyBlocks = Sets.newHashSet();
    public Set<TagEntry> biomes = Sets.newHashSet();
    public transient Set<ResourceLocation> cachedDimensions = Sets.newHashSet();
    public transient Set<WeatherType> cachedWeathers = Sets.newHashSet();
    private ArrayList<String> partyHeadSpecies = null;
    public String tag = null;
    public Boolean seesSky = null;
    public Float temperature = null;
    public ArrayList<String> dimensions = null;
    public ArrayList<String> worlds = null;
    public ArrayList<String> structures = null;
    public Integer minX = null;
    public Integer maxX = null;
    public Integer minY = null;
    public Integer maxY = null;
    public Integer minZ = null;
    public Integer maxZ = null;
    public Integer moonPhase = null;
    public Integer minLightLevel = null;
    public Integer maxLightLevel = null;
    private boolean disabled = false;
    static ArrayList<WorldTime> currentTimes = new ArrayList();

    public void onExport() {
    }

    public void onImport() {
        if (this.dimensions != null) {
            for (String dimension : this.dimensions) {
                this.cachedDimensions.add(ResourceLocationHelper.of(dimension));
            }
        }
    }

    public boolean fits(SpawnInfo spawnInfo, SpawnLocation spawnLocation) {
        if (this.disabled) {
            return false;
        }
        if (!this.doesHeadOfPartyMatch(spawnLocation)) {
            return false;
        }
        if (!(this.tag == null || spawnInfo.tags != null && spawnInfo.tags.contains(this.tag))) {
            return false;
        }
        if (this.seesSky != null && this.seesSky != spawnLocation.seesSky) {
            return false;
        }
        if (this.temperature != null && this.temperature.floatValue() != ((Biome)spawnLocation.biome.get()).m_47554_()) {
            return false;
        }
        if (!this.cachedDimensions.isEmpty() && !this.cachedDimensions.contains(spawnLocation.location.world.m_46472_().m_135782_())) {
            return false;
        }
        if (this.worlds != null && !this.worlds.isEmpty() && !this.worlds.contains(spawnLocation.location.world.m_46464_())) {
            return false;
        }
        if (this.minX != null && spawnLocation.location.pos.m_123341_() < this.minX) {
            return false;
        }
        if (this.maxX != null && spawnLocation.location.pos.m_123341_() > this.maxX) {
            return false;
        }
        if (this.minY != null && spawnLocation.location.pos.m_123342_() < this.minY) {
            return false;
        }
        if (this.maxY != null && spawnLocation.location.pos.m_123342_() > this.maxY) {
            return false;
        }
        if (this.minZ != null && spawnLocation.location.pos.m_123343_() < this.minZ) {
            return false;
        }
        if (this.maxZ != null && spawnLocation.location.pos.m_123343_() > this.maxZ) {
            return false;
        }
        if (this.weathers != null && !this.weathers.isEmpty() && !this.weathers.contains((Object)WeatherType.get(spawnLocation.location.world))) {
            return false;
        }
        if (!(((ServerLevel)spawnLocation.location.world).m_7726_().m_8481_() instanceof FlatLevelSource && Pixelmon.isDevEnvironment() || this.biomes == null || this.biomes.isEmpty() || TagsHelper.is(spawnLocation.biome, this.biomes))) {
            return false;
        }
        if (!this.doesWorldTimeFit(spawnLocation.location.world)) {
            return false;
        }
        if (!this.doesRealTimeFit()) {
            return false;
        }
        if (this.moonPhase != null && spawnLocation.location.world.m_6042_().m_63936_(spawnLocation.location.world.m_8044_()) != this.moonPhase.intValue()) {
            return false;
        }
        if (this.minLightLevel != null && spawnLocation.light < this.minLightLevel) {
            return false;
        }
        if (this.maxLightLevel != null && spawnLocation.light > this.maxLightLevel) {
            return false;
        }
        if (this.baseBlocks != null && !this.baseBlocks.isEmpty() && !this.baseBlocks.contains(spawnLocation.baseBlock)) {
            return false;
        }
        if (this.neededNearbyBlocks != null && !this.neededNearbyBlocks.isEmpty() && !TagsHelper.allMatch(spawnLocation.uniqueSurroundingBlocks, Block::m_204297_, this.neededNearbyBlocks)) {
            return false;
        }
        if (this.structures != null && !this.structures.isEmpty() && spawnLocation.location.world instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)spawnLocation.location.world;
            boolean inStructure = false;
            for (String structure : this.structures) {
                if (!WorldHelper.insideStructure(ws, structure, (BlockPos)spawnLocation.location.pos)) continue;
                inStructure = true;
                break;
            }
            if (!inStructure) {
                return false;
            }
        }
        return true;
    }

    private boolean doesHeadOfPartyMatch(SpawnLocation spawnLocation) {
        if (this.partyHeadSpecies == null || this.partyHeadSpecies.isEmpty()) {
            return true;
        }
        if (!(spawnLocation.cause instanceof ServerPlayer)) {
            return false;
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)spawnLocation.cause);
        Pokemon headOfParty = party.get(0);
        if (headOfParty == null) {
            return false;
        }
        return this.partyHeadSpecies.contains(headOfParty.getSpecies().getName());
    }

    private boolean doesWorldTimeFit(Level world) {
        if (this.times == null || this.times.isEmpty()) {
            return true;
        }
        List<WorldTime> times = WorldTime.getCurrent(world);
        for (int i = 0; i < times.size(); ++i) {
            WorldTime time = times.get(i);
            if (!this.times.contains(time)) continue;
            return true;
        }
        return false;
    }

    private boolean doesRealTimeFit() {
        if (this.realWorldSpawnTimes == null || this.realWorldSpawnTimes.isEmpty()) {
            return true;
        }
        for (SpawnTime spawnTime : this.realWorldSpawnTimes) {
            if (!spawnTime.matches()) continue;
            return true;
        }
        return false;
    }
}

