/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.conditions;

import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.conditions.TriggerLocation;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.init.registry.PixelmonBlockTags;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LocationType {
    public static final ArrayList<LocationType> locationTypes = new ArrayList();
    public String name;
    public Predicate<BlockState> baseBlockCondition = state -> true;
    public Predicate<BlockState> surroundingBlockCondition = state -> state.m_60734_() == Blocks.f_50016_;
    public Predicate<Set<Block>> neededNearbyBlockCondition = block -> true;
    public Consumer<SpawnLocation> mutator = spawnLocation -> {};
    public Boolean seesSky = null;
    public static LocationType LAND = new LocationType("Land").setSeesSky(true).setBaseBlockCondition(state -> state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_LAND_BLOCKS)).setSurroundingBlockCondition(state -> state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_AIR_BLOCKS));
    public static LocationType UNDERGROUND = new LocationType("Underground").setSeesSky(false).setBaseBlockCondition(LocationType.LAND.baseBlockCondition).setSurroundingBlockCondition(LocationType.LAND.surroundingBlockCondition);
    public static LocationType WATER = new LocationType("Water").setSeesSky(true).setBaseBlockCondition(state -> state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_WATER_BLOCKS)).setSurroundingBlockCondition(state -> state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_WATER_BLOCKS));
    public static LocationType SURFACE_WATER = new LocationType("Surface Water").setSeesSky(true).setBaseBlockCondition(LocationType.WATER.baseBlockCondition).setSurroundingBlockCondition(state -> LocationType.WATER.surroundingBlockCondition.test((BlockState)state) || LocationType.LAND.surroundingBlockCondition.test((BlockState)state)).setLocationMutator(spawnLocation -> {
        int y = spawnLocation.location.pos.m_123342_();
        BlockPos.MutableBlockPos highest = spawnLocation.location.pos.m_122032_();
        while (spawnLocation.location.world.m_8055_((BlockPos)highest).m_60819_().m_76170_()) {
            highest.m_142448_(++y);
        }
        spawnLocation.location.pos.m_142448_(highest.m_123342_());
    });
    public static LocationType LAVA = new LocationType("Lava").setBaseBlockCondition(state -> state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_LAVA_BLOCKS)).setSurroundingBlockCondition(state -> state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_LAVA_BLOCKS));
    public static LocationType SURFACE_LAVA = new LocationType("Surface Lava").setSeesSky(true).setBaseBlockCondition(LocationType.LAVA.baseBlockCondition).setSurroundingBlockCondition(state -> LocationType.LAVA.surroundingBlockCondition.test((BlockState)state) || LocationType.LAND.surroundingBlockCondition.test((BlockState)state)).setLocationMutator(spawnLocation -> {
        int y = spawnLocation.location.pos.m_123342_();
        BlockPos.MutableBlockPos highest = spawnLocation.location.pos.m_122032_();
        while (spawnLocation.location.world.m_8055_((BlockPos)highest).m_60819_().m_76170_()) {
            highest.m_142448_(++y);
        }
        spawnLocation.location.pos.m_142448_(highest.m_123342_());
    });
    public static LocationType UNDERGROUND_LAVA = new LocationType("Underground Lava").setSeesSky(false).setBaseBlockCondition(LocationType.LAVA.baseBlockCondition).setSurroundingBlockCondition(LocationType.LAVA.surroundingBlockCondition);
    public static LocationType LIQUID = new LocationType("Liquid").setBaseBlockCondition(LocationType.WATER.baseBlockCondition.or(LocationType.LAVA.baseBlockCondition)).setSurroundingBlockCondition(LocationType.WATER.baseBlockCondition.or(LocationType.LAVA.baseBlockCondition));
    public static LocationType UNDERGROUND_LIQUID = new LocationType("Underground Liquid").setSeesSky(false).setBaseBlockCondition(LocationType.LIQUID.baseBlockCondition).setSurroundingBlockCondition(LocationType.LIQUID.surroundingBlockCondition);
    public static LocationType SURFACE_LIQUID = new LocationType("Surface Liquid").setSeesSky(true).setBaseBlockCondition(LocationType.LIQUID.baseBlockCondition).setSurroundingBlockCondition(state -> LocationType.LIQUID.surroundingBlockCondition.test((BlockState)state) || LocationType.LAND.surroundingBlockCondition.test((BlockState)state)).setLocationMutator(spawnLocation -> {
        int y = spawnLocation.location.pos.m_123342_();
        BlockPos.MutableBlockPos highest = spawnLocation.location.pos.m_122032_();
        while (spawnLocation.location.world.m_8055_((BlockPos)highest).m_60819_().m_76170_()) {
            highest.m_142448_(++y);
        }
        spawnLocation.location.pos.m_142448_(highest.m_123342_());
    });
    public static LocationType SEAFLOOR = new LocationType("Seafloor").setSeesSky(true).setBaseBlockCondition(LocationType.LAND.baseBlockCondition).setSurroundingBlockCondition(LocationType.WATER.surroundingBlockCondition);
    public static LocationType LAVA_FLOOR = new LocationType("Lava Floor").setSeesSky(true).setBaseBlockCondition(LocationType.LAND.baseBlockCondition).setSurroundingBlockCondition(LocationType.LAVA.surroundingBlockCondition);
    public static LocationType LIQUID_FLOOR = new LocationType("Liquid Floor").setSeesSky(true).setBaseBlockCondition(LocationType.LAND.baseBlockCondition).setSurroundingBlockCondition(LocationType.LIQUID.surroundingBlockCondition);
    public static LocationType UNDERGROUND_WATER = new LocationType("Underground Water").setSeesSky(false).setBaseBlockCondition(LocationType.WATER.baseBlockCondition).setSurroundingBlockCondition(LocationType.WATER.surroundingBlockCondition);
    public static LocationType AIR = new LocationType("Air").setSeesSky(true).setBaseBlockCondition(state -> LocationType.LAND.baseBlockCondition.test((BlockState)state) || LocationType.WATER.baseBlockCondition.test((BlockState)state)).setSurroundingBlockCondition(state -> LocationType.LAND.surroundingBlockCondition.test((BlockState)state) || LocationType.WATER.surroundingBlockCondition.test((BlockState)state)).setLocationMutator(spawnLocation -> {
        BlockState state;
        BlockPos.MutableBlockPos highest = spawnLocation.location.pos.m_122032_();
        highest.m_142448_(spawnLocation.location.world.m_6042_().f_156648_());
        while (highest.m_123342_() > spawnLocation.location.world.m_6042_().f_156647_() && !(state = spawnLocation.location.world.m_8055_((BlockPos)highest)).m_60819_().m_76170_()) {
            highest.m_142448_(highest.m_123342_() - 1);
        }
        if (highest.m_123342_() == 0) {
            return;
        }
        if (highest.m_123342_() < 230) {
            spawnLocation.location.pos.m_142448_(highest.m_123342_() + RandomHelper.getRandomNumberBetween(8, 20));
        }
    });
    public static LocationType TREE_TOP = new LocationType("Tree Top").setBaseBlockCondition(state -> state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_TREE_TOP_BLOCKS)).setSurroundingBlockCondition(state -> state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_AIR_BLOCKS)).setSeesSky(true);
    public static LocationType MANMADE = new LocationType("Manmade").setBaseBlockCondition(state -> state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_STRUCTURE_BLOCKS)).setSurroundingBlockCondition(state -> state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_AIR_BLOCKS)).setSeesSky(true);
    public static LocationType INDOORS = new LocationType("Indoors").setBaseBlockCondition(state -> state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_STRUCTURE_BLOCKS)).setSurroundingBlockCondition(state -> state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_AIR_BLOCKS)).setSeesSky(false);
    public static LocationType ROCK_SMASH = new TriggerLocation("Rock Smash");
    public static LocationType HEADBUTT = new TriggerLocation("Headbutt");
    public static LocationType SWEET_SCENT = new TriggerLocation("Sweet Scent");
    public static LocationType FORAGE = new TriggerLocation("Forage");
    public static LocationType CURRY_NONE = new TriggerLocation("Curry None");
    public static LocationType CURRY_SWEET = new TriggerLocation("Curry Sweet");
    public static LocationType CURRY_SOUR = new TriggerLocation("Curry Sour");
    public static LocationType CURRY_BITTER = new TriggerLocation("Curry Bitter");
    public static LocationType CURRY_DRY = new TriggerLocation("Curry Dry");
    public static LocationType CURRY_SPICY = new TriggerLocation("Curry Spicy");
    public static TriggerLocation OLD_ROD = new TriggerLocation("Old Rod");
    public static TriggerLocation GOOD_ROD = new TriggerLocation("Good Rod");
    public static TriggerLocation SUPER_ROD = new TriggerLocation("Super Rod");
    public static TriggerLocation OAS_ROD = new TriggerLocation("Oas Rod");
    public static TriggerLocation OK_ROD_QUALITY = new TriggerLocation("OK Rod Quality");
    public static TriggerLocation SO_SO_ROD_QUALITY = new TriggerLocation("So-So Rod Quality");
    public static TriggerLocation GOOD_ROD_QUALITY = new TriggerLocation("Good Rod Quality");
    public static TriggerLocation GREAT_ROD_QUALITY = new TriggerLocation("Great Rod Quality");
    public static TriggerLocation RARE_ROD_QUALITY = new TriggerLocation("Rare Rod Quality");
    public static TriggerLocation PRO_ROD_QUALITY = new TriggerLocation("Pro Rod Quality");
    public static TriggerLocation SUPREME_ROD_QUALITY = new TriggerLocation("Supreme Rod Quality");
    public static TriggerLocation OLD_ROD_LAVA = new TriggerLocation("Old Rod Lava");
    public static TriggerLocation GOOD_ROD_LAVA = new TriggerLocation("Good Rod Lava");
    public static TriggerLocation SUPER_ROD_LAVA = new TriggerLocation("Super Rod Lava");
    public static TriggerLocation GRASS = new TriggerLocation("Grass");
    public static TriggerLocation CAVE_ROCK = new TriggerLocation("Cave Rock");
    public static TriggerLocation DOUBLE_GRASS = new TriggerLocation("Tall Grass");
    public static TriggerLocation SEAWEED = new TriggerLocation("Seawed");

    public LocationType(String name) {
        this.name = name;
    }

    public LocationType setBaseBlockCondition(Predicate<BlockState> baseBlockCondition) {
        this.baseBlockCondition = baseBlockCondition;
        return this;
    }

    public LocationType setSurroundingBlockCondition(Predicate<BlockState> surroundingBlockCondition) {
        this.surroundingBlockCondition = surroundingBlockCondition;
        return this;
    }

    public LocationType setNeededNearbyBlockCondition(Predicate<Set<Block>> neededNearbyBlockCondition) {
        this.neededNearbyBlockCondition = neededNearbyBlockCondition;
        return this;
    }

    public LocationType setSeesSky(Boolean seesSky) {
        this.seesSky = seesSky;
        return this;
    }

    public LocationType setLocationMutator(Consumer<SpawnLocation> mutator) {
        this.mutator = mutator;
        return this;
    }

    public String toString() {
        return this.name;
    }

    public static LocationType of(String name) {
        for (LocationType type : locationTypes) {
            if (!type.name.equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public static ArrayList<LocationType> getPotentialTypes(BlockState state) {
        ArrayList<LocationType> types = new ArrayList<LocationType>(2);
        for (LocationType type : locationTypes) {
            if (state == null || !type.baseBlockCondition.test(state)) continue;
            types.add(type);
        }
        return types;
    }

    public static void addPotentialTypes(ArrayList<LocationType> types, BlockState state) {
        for (LocationType type : locationTypes) {
            if (state == null || !type.baseBlockCondition.test(state)) continue;
            types.add(type);
        }
    }

    static {
        locationTypes.add(LAND);
        locationTypes.add(UNDERGROUND);
        locationTypes.add(WATER);
        locationTypes.add(SURFACE_WATER);
        locationTypes.add(SEAFLOOR);
        locationTypes.add(UNDERGROUND_WATER);
        locationTypes.add(AIR);
        locationTypes.add(LAVA);
        locationTypes.add(SURFACE_LAVA);
        locationTypes.add(UNDERGROUND_LAVA);
        locationTypes.add(ROCK_SMASH);
        locationTypes.add(HEADBUTT);
        locationTypes.add(SWEET_SCENT);
        locationTypes.add(TREE_TOP);
        locationTypes.add(MANMADE);
        locationTypes.add(INDOORS);
        locationTypes.add(LIQUID);
        locationTypes.add(UNDERGROUND_LIQUID);
        locationTypes.add(SURFACE_LIQUID);
        locationTypes.add(LAVA_FLOOR);
        locationTypes.add(LIQUID_FLOOR);
        locationTypes.add(FORAGE);
        locationTypes.add(CURRY_NONE);
        locationTypes.add(CURRY_BITTER);
        locationTypes.add(CURRY_DRY);
        locationTypes.add(CURRY_SOUR);
        locationTypes.add(CURRY_SPICY);
        locationTypes.add(CURRY_SWEET);
        locationTypes.add(OLD_ROD);
        locationTypes.add(GOOD_ROD);
        locationTypes.add(SUPER_ROD);
        locationTypes.add(OAS_ROD);
        locationTypes.add(OLD_ROD_LAVA);
        locationTypes.add(GOOD_ROD_LAVA);
        locationTypes.add(SUPER_ROD_LAVA);
        locationTypes.add(OK_ROD_QUALITY);
        locationTypes.add(SO_SO_ROD_QUALITY);
        locationTypes.add(GOOD_ROD_QUALITY);
        locationTypes.add(GREAT_ROD_QUALITY);
        locationTypes.add(RARE_ROD_QUALITY);
        locationTypes.add(PRO_ROD_QUALITY);
        locationTypes.add(SUPREME_ROD_QUALITY);
        locationTypes.add(GRASS);
        locationTypes.add(CAVE_ROCK);
        locationTypes.add(DOUBLE_GRASS);
        locationTypes.add(SEAWEED);
    }
}

