/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.calculators;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.RarityTweak;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;

public interface SelectionAlgorithm {
    public List<SpawnAction<? extends Entity>> calculateSpawnActions(AbstractSpawner var1, List<SpawnSet> var2, List<SpawnLocation> var3);

    public Map<SpawnInfo, Float> getAdjustedRarities(AbstractSpawner var1, Map<SpawnLocation, List<SpawnInfo>> var2);

    default public Map<String, Double> getPercentages(AbstractSpawner spawner, Map<SpawnLocation, List<SpawnInfo>> possibleSpawns) {
        Map<SpawnInfo, Float> adjustedRarities = this.getAdjustedRarities(spawner, possibleSpawns);
        float raritySum = 0.0f;
        float totalPercentage = 0.0f;
        DecimalFormat df = new DecimalFormat(".####");
        DecimalFormat df2 = new DecimalFormat(".##");
        ArrayList<SpawnInfo> allSpawns = new ArrayList<SpawnInfo>();
        for (List<SpawnInfo> spawns : possibleSpawns.values()) {
            for (SpawnInfo spawnInfo : spawns) {
                if (allSpawns.contains(spawnInfo)) continue;
                allSpawns.add(spawnInfo);
            }
        }
        for (SpawnInfo spawnInfo : allSpawns) {
            if (adjustedRarities.containsKey(spawnInfo)) {
                raritySum += adjustedRarities.get(spawnInfo).floatValue();
            }
            if (spawnInfo.percentage == null || !(spawnInfo.percentage.floatValue() > 0.0f)) continue;
            totalPercentage += spawnInfo.percentage.floatValue();
        }
        for (SpawnInfo spawnInfo : allSpawns) {
            if (!adjustedRarities.containsKey(spawnInfo)) continue;
            float rarity = adjustedRarities.get(spawnInfo).floatValue();
            for (RarityTweak rarityTweak : spawner.rarityTweaks) {
                rarity *= rarityTweak.getMultiplier(spawner, spawnInfo, raritySum, rarity);
                raritySum += rarity - adjustedRarities.get(spawnInfo).floatValue();
            }
            adjustedRarities.put(spawnInfo, Float.valueOf(rarity));
        }
        if (totalPercentage > 0.0f) {
            for (SpawnInfo spawnInfo : adjustedRarities.keySet()) {
                if (spawnInfo.percentage != null) continue;
                adjustedRarities.put(spawnInfo, Float.valueOf(adjustedRarities.get(spawnInfo).floatValue() * (100.0f - totalPercentage) / 100.0f));
            }
        }
        HashMap<String, Double> percentages = new HashMap<String, Double>();
        for (SpawnInfo spawnInfo : allSpawns) {
            double percentage;
            String string = spawnInfo.toString();
            if (spawnInfo.percentage != null && spawnInfo.percentage.floatValue() > 0.0f) {
                percentage = spawnInfo.percentage.floatValue();
            } else {
                float adjusted = adjustedRarities.get(spawnInfo).floatValue() * 100.0f;
                percentage = (double)(adjusted / raritySum) + percentages.getOrDefault(string, 0.0);
            }
            if (percentage < 0.01 || percentage > 99.99) {
                percentages.put(string, Double.parseDouble(df.format(percentage).replace(",", ".")));
                continue;
            }
            percentages.put(string, Double.parseDouble(df2.format(percentage).replace(",", ".")));
        }
        return percentages;
    }

    @Nullable
    default public SpawnInfo chooseViaPercentage(AbstractSpawner spawner, ArrayList<SpawnInfo> spawnInfos) {
        ArrayList<SpawnInfo> percentageSpawns = new ArrayList<SpawnInfo>();
        float percentSum = 0.0f;
        for (SpawnInfo spawnInfo : spawnInfos) {
            float f;
            if (spawnInfo.percentage == null || !(spawnInfo.percentage.floatValue() > 0.0f)) continue;
            percentageSpawns.add(spawnInfo);
            percentSum += spawnInfo.percentage.floatValue();
            if (!(f > 100.0f)) continue;
            Pixelmon.LOGGER.error("A sum of percentages exceeds 100, starting in: " + spawnInfo.set.id);
            return null;
        }
        if (percentSum == 0.0f) {
            return null;
        }
        float chosenPercentPoint = RandomHelper.getRandomNumberBetween(0.0f, 100.0f);
        if (chosenPercentPoint > percentSum) {
            return null;
        }
        percentSum = 0.0f;
        for (SpawnInfo spawnInfo : percentageSpawns) {
            float f;
            percentSum += spawnInfo.percentage.floatValue();
            if (!(f >= chosenPercentPoint)) continue;
            return spawnInfo;
        }
        Pixelmon.LOGGER.warn("Unable to choose a SpawnInfo based on rarities during percentage chooser. This shouldn't be possible.");
        return null;
    }

    default public SpawnInfo choose(AbstractSpawner spawner, SpawnLocation spawnLocation, ArrayList<SpawnInfo> spawnInfos) {
        float rarity;
        if (spawnInfos.isEmpty() || spawnInfos.size() == 1 && spawnInfos.get((int)0).rarity <= 0.0f) {
            return null;
        }
        SpawnInfo percentSelection = this.chooseViaPercentage(spawner, spawnInfos);
        if (percentSelection != null) {
            return percentSelection;
        }
        if (spawnInfos.size() == 1) {
            return spawnInfos.get(0);
        }
        HashMap<SpawnInfo, Float> finalRarities = new HashMap<SpawnInfo, Float>();
        float raritySum = 0.0f;
        for (SpawnInfo spawnInfo : spawnInfos) {
            rarity = spawnInfo.getAdjustedRarity(spawner, spawnLocation);
            finalRarities.put(spawnInfo, Float.valueOf(rarity));
            raritySum += rarity;
        }
        for (SpawnInfo spawnInfo : spawnInfos) {
            rarity = ((Float)finalRarities.get(spawnInfo)).floatValue();
            for (RarityTweak rarityTweak : spawner.rarityTweaks) {
                rarity *= rarityTweak.getMultiplier(spawner, spawnInfo, raritySum, rarity);
                raritySum += rarity - ((Float)finalRarities.get(spawnInfo)).floatValue();
            }
            finalRarities.put(spawnInfo, Float.valueOf(rarity));
        }
        if (raritySum <= 0.0f) {
            return null;
        }
        float selected = RandomHelper.getRandomNumberBetween(0.0f, raritySum);
        raritySum = 0.0f;
        for (SpawnInfo spawnInfo : spawnInfos) {
            float f;
            raritySum += ((Float)finalRarities.get(spawnInfo)).floatValue();
            if (!(f >= selected) || ((Float)finalRarities.get(spawnInfo)).floatValue() == 0.0f) continue;
            return spawnInfo;
        }
        Pixelmon.LOGGER.warn("Unable to choose a SpawnInfo based on rarities. This shouldn't be possible.");
        return null;
    }
}

