/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.calculators;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;

public class CurryCheckSpawns
implements CheckSpawns {
    @Override
    public String getPermissionNode() {
        return "pixelmon.checkspawns.curry";
    }

    @Override
    public void checkSpawns(AbstractSpawner spawner, CommandSourceStack sender, List<String> arguments) {
        ServerPlayer target = null;
        if (!(sender.m_81373_() instanceof ServerPlayer)) {
            PlayerList playerList = sender.m_81377_().m_6846_();
            for (String argument : arguments) {
                if (!spawner.name.equals(argument) && (target = playerList.m_11255_(argument)) != null) break;
            }
            if (target == null) {
                sender.m_288197_(() -> TextHelper.translate(ChatFormatting.RED, "spawning.error.mustbeplayer"), false);
                return;
            }
        }
        if (target == null) {
            target = (ServerPlayer)sender.m_81373_();
        }
        ArrayList<SpawnLocation> spawnLocations = new ArrayList<SpawnLocation>();
        SpatialData data = AbstractSpawner.calculateSpatialData(target.m_9236_(), target.m_20183_(), 6, true, s -> true);
        spawnLocations.add(new SpawnLocation((Entity)target, new MutableLocation(target.m_9236_(), target.m_20183_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CURRY_BITTER}), data.baseBlock, data.uniqueSurroundingBlocks, (Holder<Biome>)target.m_9236_().m_204166_(target.m_20183_()), BetterSpawnerConfig.doesBlockSeeSky(target.m_9236_().m_8055_(target.m_20183_())), 6, 1));
        spawnLocations.add(new SpawnLocation((Entity)target, new MutableLocation(target.m_9236_(), target.m_20183_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CURRY_DRY}), data.baseBlock, data.uniqueSurroundingBlocks, (Holder<Biome>)target.m_9236_().m_204166_(target.m_20183_()), BetterSpawnerConfig.doesBlockSeeSky(target.m_9236_().m_8055_(target.m_20183_())), 6, 1));
        spawnLocations.add(new SpawnLocation((Entity)target, new MutableLocation(target.m_9236_(), target.m_20183_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CURRY_NONE}), data.baseBlock, data.uniqueSurroundingBlocks, (Holder<Biome>)target.m_9236_().m_204166_(target.m_20183_()), BetterSpawnerConfig.doesBlockSeeSky(target.m_9236_().m_8055_(target.m_20183_())), 6, 1));
        spawnLocations.add(new SpawnLocation((Entity)target, new MutableLocation(target.m_9236_(), target.m_20183_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CURRY_SOUR}), data.baseBlock, data.uniqueSurroundingBlocks, (Holder<Biome>)target.m_9236_().m_204166_(target.m_20183_()), BetterSpawnerConfig.doesBlockSeeSky(target.m_9236_().m_8055_(target.m_20183_())), 6, 1));
        spawnLocations.add(new SpawnLocation((Entity)target, new MutableLocation(target.m_9236_(), target.m_20183_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CURRY_SPICY}), data.baseBlock, data.uniqueSurroundingBlocks, (Holder<Biome>)target.m_9236_().m_204166_(target.m_20183_()), BetterSpawnerConfig.doesBlockSeeSky(target.m_9236_().m_8055_(target.m_20183_())), 6, 1));
        spawnLocations.add(new SpawnLocation((Entity)target, new MutableLocation(target.m_9236_(), target.m_20183_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CURRY_SWEET}), data.baseBlock, data.uniqueSurroundingBlocks, (Holder<Biome>)target.m_9236_().m_204166_(target.m_20183_()), BetterSpawnerConfig.doesBlockSeeSky(target.m_9236_().m_8055_(target.m_20183_())), 6, 1));
        HashMap<SpawnLocation, ArrayList<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, ArrayList<SpawnInfo>>();
        for (SpawnLocation spawnLocation : spawnLocations) {
            ArrayList<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
            if (spawns.isEmpty()) continue;
            possibleSpawns.put(spawnLocation, spawns);
        }
        sender.m_81377_().execute(() -> {
            Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
            List<MutableComponent> messages = this.generateMessages(percentages, arguments);
            messages.add(0, TextHelper.translate(ChatFormatting.AQUA, "spawning.checkspawns.possiblespawns"));
            messages.forEach(message -> sender.m_288197_(() -> message, false));
        });
    }
}

