/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.calculators;

import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public interface CheckSpawns {
    public static CheckSpawns getDefault() {
        return (spawner, sender, arguments) -> sender.m_288197_(() -> Component.m_237113_((String)"Not implemented."), true);
    }

    default public String getPermissionNode() {
        return "pixelmon.checkspawns.normal";
    }

    public void checkSpawns(AbstractSpawner var1, CommandSourceStack var2, List<String> var3);

    default public List<MutableComponent> generateMessages(Map<String, Double> percentages, List<String> arguments) {
        ArrayList<MutableComponent> translationMessages = new ArrayList<MutableComponent>();
        ArrayList<CallSite> messages = new ArrayList<CallSite>();
        Predicate<String> caredAbout = null;
        for (String argument : arguments) {
            for (String key : percentages.keySet()) {
                if (!key.equalsIgnoreCase(argument)) continue;
                String needed = PixelmonSpecies.fromNameOrDex(argument).isPresent() ? PixelmonSpecies.fromNameOrDex(argument).get().getLocalizedName() : I18n.m_118938_((String)argument, (Object[])new Object[0]);
                if (caredAbout == null) {
                    caredAbout = s -> s.equalsIgnoreCase(needed);
                    continue;
                }
                Predicate<String> pTemp = caredAbout;
                caredAbout = s -> pTemp.test((String)s) || s.equalsIgnoreCase(needed);
            }
        }
        if (caredAbout == null) {
            caredAbout = s -> true;
        }
        double greenThreshold = 10.0;
        double yellowThreshold = 2.0;
        double redThreshold = 0.5;
        double lightPurpleThreshold = 0.001;
        ArrayList<Map.Entry<String, Double>> sortedEntries = new ArrayList<Map.Entry<String, Double>>(percentages.entrySet());
        sortedEntries.sort(Map.Entry.comparingByValue());
        for (Map.Entry<String, Double> entry : sortedEntries) {
            if (!caredAbout.test(entry.getKey())) continue;
            ChatFormatting colour = ChatFormatting.DARK_PURPLE;
            if (entry.getValue() > 10.0) {
                colour = ChatFormatting.GREEN;
            } else if (entry.getValue() > 2.0) {
                colour = ChatFormatting.YELLOW;
            } else if (entry.getValue() > 0.5) {
                colour = ChatFormatting.RED;
            } else if (entry.getValue() > 0.001) {
                colour = ChatFormatting.LIGHT_PURPLE;
            }
            messages.add((CallSite)((Object)(ChatFormatting.GOLD + entry.getKey() + ChatFormatting.GRAY + ": " + colour + entry.getValue() + "%")));
        }
        while (!messages.isEmpty()) {
            Object message = (String)messages.remove(0);
            int onThisLine = 1;
            while (!messages.isEmpty() && onThisLine++ < 3) {
                message = (String)message + ChatFormatting.GOLD + ", " + (String)messages.remove(0);
            }
            translationMessages.add(Component.m_237113_((String)message));
        }
        return translationMessages;
    }
}

