/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.calculators;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.events.spawning.SpawnLocationEvent;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;

public interface CalculateSpawnLocations {
    public static final int MIN_DIAMETER = 1;

    public static CalculateSpawnLocations getDefault() {
        return new DummyImpl();
    }

    default public int getMaxSpawnLocationDiameter() {
        return 10;
    }

    default public ArrayList<SpawnLocation> calculateSpawnableLocations(BlockCollection collection) {
        ArrayList<SpawnLocation> spawnableLocations = new ArrayList<SpawnLocation>();
        Level world = collection.world;
        int minX = collection.minX + 1;
        int minY = collection.minY + 1;
        int minZ = collection.minZ + 1;
        int maxX = collection.maxX - 1;
        int maxY = collection.maxY - 1;
        int maxZ = collection.maxZ - 1;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int baseX = minX; baseX <= maxX; ++baseX) {
            block1: for (int baseZ = minZ; baseZ <= maxZ; ++baseZ) {
                boolean canSeeSky = collection.getHeighestBlock(baseX, baseZ) <= maxY + 1;
                block2: for (int baseY = maxY - 1; baseY >= minY; --baseY) {
                    MutableLocation loc;
                    SpawnLocation spawnLocation;
                    SpawnLocationEvent event;
                    ArrayList<LocationType> types;
                    blockPos.m_122178_(baseX, baseY + 1, baseZ);
                    if (!world.m_6857_().m_61937_((BlockPos)blockPos)) continue;
                    BlockState state = collection.getBlockState(baseX, baseY + 1, baseZ);
                    if (state == null) continue block1;
                    if (canSeeSky && !BetterSpawnerConfig.doesBlockSeeSky(state)) {
                        canSeeSky = false;
                    }
                    if ((types = LocationType.getPotentialTypes(collection.getBlockState(baseX, baseY, baseZ))).isEmpty()) continue;
                    int r = 0;
                    int diameter = 0;
                    block3: while (diameter <= this.getMaxSpawnLocationDiameter()) {
                        int y = blockPos.m_123342_() + r;
                        for (int sign : new int[]{-1, 1}) {
                            for (int x : new int[]{blockPos.m_123341_() + r * sign, blockPos.m_123341_()}) {
                                for (int z : new int[]{blockPos.m_123343_() + r * sign, blockPos.m_123343_()}) {
                                    if (x > maxX || x < minX || y > maxY || y < minY || z > maxZ || z < minZ) {
                                        if (r > 1) break block3;
                                        continue block2;
                                    }
                                    BlockState rstate = collection.getBlockState(x, y, z);
                                    if (rstate == null) break block3;
                                    if (diameter <= 1) {
                                        types.removeIf(type -> !type.surroundingBlockCondition.test(rstate));
                                        if (types.isEmpty()) {
                                            continue block2;
                                        }
                                    } else {
                                        for (LocationType type2 : types) {
                                            if (type2.surroundingBlockCondition.test(rstate)) continue;
                                            break block3;
                                        }
                                    }
                                    if (r == 0) break;
                                }
                                if (r == 0) break;
                            }
                            ++diameter;
                        }
                        ++r;
                    }
                    int searchRad = this.getMaxSpawnLocationDiameter();
                    HashSet uniqueBlocks = Sets.newHashSet();
                    for (int x = baseX - searchRad; x < baseX + searchRad; ++x) {
                        if (x > collection.maxX || x < collection.minX) continue;
                        for (int y = baseY - searchRad; y <= baseY + searchRad; ++y) {
                            if (y > collection.maxY || y < collection.minY) continue;
                            for (int z = baseZ - searchRad; z <= baseZ + searchRad; ++z) {
                                if (z > collection.maxZ || z < collection.minZ || (state = collection.getBlockState(x, y, z)) == null) continue;
                                uniqueBlocks.add(state.m_60734_());
                            }
                        }
                    }
                    HashSet finalTypes = Sets.newHashSet();
                    if (!types.isEmpty()) {
                        for (int i = 0; i < types.size(); ++i) {
                            LocationType type3 = types.get(i);
                            if (type3.seesSky != null && canSeeSky != type3.seesSky || type3.neededNearbyBlockCondition != null && !type3.neededNearbyBlockCondition.test(uniqueBlocks)) continue;
                            finalTypes.add(type3);
                        }
                    }
                    if (finalTypes.isEmpty() || Pixelmon.EVENT_BUS.post((Event)(event = new SpawnLocationEvent(spawnLocation = new SpawnLocation(collection.cause, loc = new MutableLocation(world, baseX, baseY + 1, baseZ), finalTypes, collection.getBlockState(baseX, baseY, baseZ).m_60734_(), uniqueBlocks, collection.getBiome(baseX, baseY, baseZ), canSeeSky, diameter, collection.getLight(baseX, baseY + 1, baseZ)))))) continue;
                    spawnableLocations.add(event.getSpawnLocation());
                }
            }
        }
        return spawnableLocations;
    }

    public static class DummyImpl
    implements CalculateSpawnLocations {
    }
}

