/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.group;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.util.Range;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.lang.reflect.Type;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class GroupSpawnSettings {
    private PokemonSpecification spec;
    private float chance;
    private Range amountRange;
    private Vec3i spawnRangeMinimum;
    private Vec3i spawnRangeMaximum;

    public GroupSpawnSettings(PokemonSpecification spec, float chance, Range amountRange, Vec3i spawnRangeMinimum, Vec3i spawnRangeMaximum) {
        this.spec = spec;
        this.chance = chance;
        this.amountRange = amountRange;
        this.spawnRangeMinimum = spawnRangeMinimum;
        this.spawnRangeMaximum = spawnRangeMaximum;
    }

    public boolean shouldSpawn() {
        return RandomHelper.getRandomChance(this.chance);
    }

    public int getRandomAmount() {
        return this.amountRange.getRandomValue();
    }

    public PixelmonEntity spawnPokemon(Level level, BlockPos center, SpawnLocationType spawnLocationType, int flockId, AbstractSpawner spawner, SpawnInfoPokemon info, SpawnLocation location) {
        BlockPos spawn = this.getRandomLocation(level, center, spawnLocationType);
        Pokemon pokemon = this.spec.create();
        SpawnActionPokemon action = new SpawnActionPokemon(info, location, pokemon, BossTierRegistry.NOT_BOSS);
        spawner.tweaks.forEach(tweak -> tweak.doTweak(spawner, action));
        PixelmonEntity entity = (PixelmonEntity)((Object)action.getOrCreateEntity());
        entity.setSpawnLocation(spawnLocationType);
        entity.m_6034_(spawn.m_123341_(), spawn.m_123342_(), spawn.m_123343_());
        entity.setGroupId(flockId);
        entity.resetAI();
        entity.resetDataWatchers();
        level.m_7967_((Entity)entity);
        return entity;
    }

    private BlockPos getRandomLocation(Level level, BlockPos center, SpawnLocationType spawnLocationType) {
        BlockPos maxPos;
        BlockPos minPos = center.m_121955_(this.spawnRangeMinimum);
        if (minPos == (maxPos = center.m_121955_(this.spawnRangeMaximum))) {
            return center;
        }
        for (int attempts = 0; attempts < 50; ++attempts) {
            BlockPos newPosition = this.selectRandom(minPos, maxPos);
            BlockPos yAdjusted = spawnLocationType.getSpawnLocation(level, newPosition);
            if (yAdjusted.m_123342_() < minPos.m_123342_() || yAdjusted.m_123342_() > maxPos.m_123342_()) continue;
            return yAdjusted;
        }
        return center;
    }

    private BlockPos selectRandom(BlockPos minPos, BlockPos maxPos) {
        int randomX = RandomHelper.getRandomNumberBetween(minPos.m_123341_(), maxPos.m_123341_());
        int randomY = RandomHelper.getRandomNumberBetween(minPos.m_123342_(), maxPos.m_123342_());
        int randomZ = RandomHelper.getRandomNumberBetween(minPos.m_123343_(), maxPos.m_123343_());
        return new BlockPos(randomX, randomY, randomZ);
    }

    public static final class TypeAdapter
    implements JsonSerializer<GroupSpawnSettings>,
    JsonDeserializer<GroupSpawnSettings> {
        public GroupSpawnSettings deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            PokemonSpecification spec = PokemonSpecificationProxy.create(object.get("spec").getAsString()).get();
            float chance = object.get("chance").getAsFloat();
            Range amountRange = (Range)context.deserialize((JsonElement)object.getAsJsonObject("amount"), Range.class);
            Vec3i spawnRangeMinimum = (Vec3i)context.deserialize((JsonElement)object.getAsJsonObject("spawn_range_minimum"), Vec3i.class);
            Vec3i spawnRangeMaximum = (Vec3i)context.deserialize((JsonElement)object.getAsJsonObject("spawn_range_maximum"), Vec3i.class);
            return new GroupSpawnSettings(spec, chance, amountRange, spawnRangeMinimum, spawnRangeMaximum);
        }

        public JsonElement serialize(GroupSpawnSettings src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("spec", src.spec.toString());
            object.addProperty("chance", (Number)Float.valueOf(src.chance));
            object.add("amount", context.serialize((Object)src.amountRange));
            object.add("spawn_range_minimum", context.serialize((Object)src.spawnRangeMinimum));
            object.add("spawn_range_maximum", context.serialize((Object)src.spawnRangeMaximum));
            return object;
        }
    }
}

