/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.spawning.LegendarySpawnEvent;
import com.pixelmonmod.pixelmon.api.item.JsonItemStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BonusStats;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.group.GroupSpawnSettings;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.group.GroupSpawningFactory;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BiomeHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.LureItem;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SpawnActionPokemon
extends SpawnAction<PixelmonEntity> {
    public Pokemon pokemon;
    public BossTier bossTier;

    public SpawnActionPokemon(SpawnInfoPokemon spawnInfo, SpawnLocation spawnLocation, Pokemon pokemon, BossTier bossTier) {
        super(spawnInfo, spawnLocation);
        this.pokemon = pokemon;
        this.bossTier = bossTier;
    }

    @Override
    protected PixelmonEntity createEntity() {
        SpawnInfoPokemon spawnInfo = (SpawnInfoPokemon)this.spawnInfo;
        try {
            double haMultiplier = 1.0;
            if (this.spawnLocation.cause instanceof ServerPlayer) {
                PlayerPartyStorage party = StorageProxy.getPartyNow(this.spawnLocation.cause.m_20148_());
                List<Pokemon> team = party.getTeam();
                if (team.size() > 0 && team.get(0) != null && team.get(0).getHeldItemAsItemHeld() != null && team.get(0).getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.cleanseTag && RandomHelper.getRandomChance(0.33333334f)) {
                    return null;
                }
                if (party.getLure() != null && party.getLure().type == LureItem.LureType.HA) {
                    haMultiplier *= Math.sqrt(party.getLure().strength.multiplier);
                }
            }
            if (RandomHelper.getRandomChance(haMultiplier / (double)PixelmonConfigProxy.getSpawning().getHiddenAbilityRate((ResourceKey<Level>)this.spawnLocation.location.world.m_46472_())) && this.pokemon.getForm().getAbilities().hasHiddenAbilities()) {
                this.pokemon.setAbility(this.pokemon.getForm().getAbilities().getRandomHiddenAbility());
            } else {
                this.pokemon.setAbility(this.pokemon.getForm().getAbilities().getRandomAbility());
            }
            PixelmonEntity pixelmon = new PixelmonEntity(this.spawnLocation.location.world, this.pokemon);
            pixelmon.setBossTier(this.bossTier);
            if (spawnInfo.locationTypes.contains(LocationType.AIR)) {
                pixelmon.setSpawnLocation(SpawnLocationType.AIR_PERSISTENT);
            } else if (CollectionHelper.anyMatch(this.spawnLocation.types, Arrays.asList(LocationType.WATER, LocationType.UNDERGROUND_WATER, LocationType.SURFACE_WATER, LocationType.SEAFLOOR, LocationType.LAVA, LocationType.SURFACE_LAVA, LocationType.UNDERGROUND_LAVA, LocationType.OLD_ROD_LAVA, LocationType.GOOD_ROD_LAVA, LocationType.SUPER_ROD_LAVA, LocationType.OLD_ROD, LocationType.GOOD_ROD, LocationType.SUPER_ROD, LocationType.OAS_ROD))) {
                pixelmon.setSpawnLocation(SpawnLocationType.WATER);
            } else {
                pixelmon.setSpawnLocation(SpawnLocationType.LAND);
            }
            pixelmon.resetAI();
            if (spawnInfo.heldItems != null && !spawnInfo.heldItems.isEmpty()) {
                ItemStack heldItem = JsonItemStack.choose(spawnInfo.heldItems);
                if (heldItem == null && this.spawnLocation.cause instanceof ServerPlayer) {
                    PlayerPartyStorage playerPartyStorage = StorageProxy.getPartyNow(this.spawnLocation.cause.m_20148_());
                }
                if (heldItem != null) {
                    pixelmon.getPokemon().setHeldItem(heldItem);
                }
            }
            return pixelmon;
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("There was a problem spawning a " + this.pokemon.toString());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PixelmonEntity doSpawn(AbstractSpawner spawner) {
        PixelmonEntity pokemon = (PixelmonEntity)((Object)this.getOrCreateEntity());
        if (pokemon == null) {
            return null;
        }
        pokemon.m_146922_(RandomHelper.getRandomNumberBetween(-180.0f, 180.0f));
        if (pokemon.isLegendary() && !pokemon.isBossPokemon() && Pixelmon.EVENT_BUS.post((Event)new LegendarySpawnEvent.DoSpawn(spawner, this))) {
            return null;
        }
        if (super.doSpawn(spawner) == null) {
            return null;
        }
        if (this.spawnInfo.groupSpawnSettings != null) {
            int flockId = GroupSpawningFactory.getNewGroupId();
            for (GroupSpawnSettings groupSpawnSetting : this.spawnInfo.groupSpawnSettings) {
                if (!groupSpawnSetting.shouldSpawn()) continue;
                for (int i = 0; i < groupSpawnSetting.getRandomAmount(); ++i) {
                    spawner.spawnedTracker.addEntity((Entity)groupSpawnSetting.spawnPokemon(((PixelmonEntity)this.entity).f_19853_, ((PixelmonEntity)this.entity).m_20183_(), ((PixelmonEntity)this.entity).getSpawnLocation(), flockId, spawner, (SpawnInfoPokemon)this.spawnInfo, this.spawnLocation));
                }
            }
        }
        if (PixelmonConfigProxy.getSpawning().isDisplayLegendaryGlobalMessage() && pokemon.isLegendary() && !pokemon.isBossPokemon()) {
            MutableComponent translatePoke = Component.m_237115_((String)("pixelmon." + pokemon.getSpecies().getName().toLowerCase(Locale.ROOT)));
            translatePoke.m_130940_(ChatFormatting.GREEN);
            MutableComponent translateMessage = Component.m_237110_((String)"spawn.legendarymessage", (Object[])new Object[]{translatePoke, BiomeHelper.getLocalizedBiomeName(this.spawnLocation.biome)});
            translateMessage.m_130940_(ChatFormatting.GREEN);
            ServerLifecycleHooks.getCurrentServer().m_6846_().m_240416_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ChatFormatting.LIGHT_PURPLE + "Pixelmon" + ChatFormatting.RESET + ChatFormatting.GREEN, translateMessage}), false);
            BlockPos.MutableBlockPos pos = this.spawnLocation.location.pos;
            ServerLifecycleHooks.getCurrentServer().m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Spawned " + pokemon.getPokemonName() + " at: " + this.spawnLocation.location.world.m_46464_() + " x:" + pos.m_123341_() + ", y:" + pos.m_123342_() + ", z:" + pos.m_123343_())));
            ((PixelmonEntity)this.entity).legendaryTicks = PixelmonConfigProxy.getSpawning().getLegendaryDespawnTicks();
        }
        ((PixelmonEntity)this.entity).resetDataWatchers();
        ((PixelmonEntity)this.entity).m_21051_(Attributes.f_22276_).m_22100_((double)pokemon.getPokemon().getMaxHealth());
        ((PixelmonEntity)this.entity).m_21153_(pokemon.getPokemon().getHealth());
        ((PixelmonEntity)this.entity).getPokemon().setBonusStats(new BonusStats(((PixelmonEntity)this.entity).getSpecies()));
        ((PixelmonEntity)this.entity).setBossTier(this.bossTier);
        return (PixelmonEntity)this.entity;
    }

    public static int getPokemonLevelBasedOnDistance(SpawnLocation spawnLocation) {
        BlockPos spawnPos = spawnLocation.location.world.m_220360_();
        double distanceFromSpawn = Math.sqrt(spawnPos.m_123331_(new Vec3i(spawnLocation.location.pos.m_123341_(), spawnLocation.location.pos.m_123342_(), spawnLocation.location.pos.m_123343_())));
        int levelBase = (int)(distanceFromSpawn / (double)PixelmonConfigProxy.getSpawning().getLevelDistance().getDistancePerLevel()) + 1;
        if (levelBase > PixelmonConfigProxy.getSpawning().getLevelDistance().getMaxLevelByDistance()) {
            levelBase = PixelmonConfigProxy.getSpawning().getLevelDistance().getMaxLevelByDistance();
        }
        return levelBase;
    }
}

