/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs;

import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.SpawnInfoNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCFisherman;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.enums.EnumNPCTutorType;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public class SpawnActionNPC
extends SpawnAction<NPCEntity> {
    public String name;

    public SpawnActionNPC(SpawnInfoNPC spawnInfo, SpawnLocation spawnLocation) {
        super(spawnInfo, spawnLocation);
        this.name = spawnInfo.name;
    }

    @Override
    protected NPCEntity createEntity() {
        Mob e = this.createEntityByName(this.name, this.spawnLocation.location.world);
        return e instanceof NPCEntity ? (NPCEntity)e : null;
    }

    private Mob createEntityByName(String entityName, Level world) {
        NPCEntity entity = null;
        if (ServerNPCRegistry.trainers.has(entityName)) {
            BaseTrainer trainer = ServerNPCRegistry.trainers.get(entityName);
            entity = new NPCTrainer(world);
            entity.init(trainer);
        } else {
            try {
                EnumNPCType npcType = EnumNPCType.valueOf(entityName);
                if (npcType == EnumNPCType.Trader) {
                    entity = new NPCTrader(world);
                } else if (npcType == EnumNPCType.Tutor) {
                    NPCTutor tutor = new NPCTutor(world);
                    entity = tutor;
                    tutor.setTutorType(EnumNPCTutorType.TUTOR);
                } else if (npcType == EnumNPCType.TransferTutor) {
                    NPCTutor tutor = new NPCTutor(world);
                    entity = tutor;
                    tutor.setTutorType(EnumNPCTutorType.TRANSFER);
                } else if (npcType == EnumNPCType.Shopkeeper) {
                    entity = new NPCShopkeeper(world);
                    ((NPCShopkeeper)entity).initWanderingAI();
                } else {
                    entity = npcType == EnumNPCType.Relearner ? new NPCRelearner(world) : (npcType == EnumNPCType.OldFisherman ? new NPCFisherman(world) : new NPCTrainer(world));
                }
                ((NPCEntity)entity).init(entityName);
            }
            catch (IllegalArgumentException e) {
                entity = new NPCTrainer(world);
            }
        }
        return entity;
    }
}

