/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RayTraceCheckSpawns
implements CheckSpawns {
    public String node;
    public LocationType locationType;
    public Predicate<BlockState> isValidBlock;

    public RayTraceCheckSpawns(LocationType locationType, Predicate<BlockState> isValidBlock, String node) {
        this.locationType = locationType;
        this.isValidBlock = isValidBlock;
        this.node = node;
    }

    @Override
    public String getPermissionNode() {
        return this.node;
    }

    @Override
    public void checkSpawns(AbstractSpawner spawner, CommandSourceStack sender, List<String> arguments) {
        HitResult result;
        ServerPlayer target = null;
        if (!(sender.m_81373_() instanceof ServerPlayer)) {
            PlayerList playerList = ServerLifecycleHooks.getCurrentServer().m_6846_();
            for (String argument : arguments) {
                if (!spawner.name.equals(argument) && (target = playerList.m_11255_(argument)) != null) break;
            }
            if (target == null) {
                sender.m_243053_((Component)TextHelper.translate(ChatFormatting.RED, "spawning.error.mustbeplayer"));
                return;
            }
        }
        if (target == null) {
            target = (ServerPlayer)sender.m_81373_();
        }
        if ((result = WorldHelper.rayTraceEyes(target, 5.0)) == null || result.m_6662_() != HitResult.Type.BLOCK) {
            ServerPlayer finalTarget = target;
            sender.m_288197_(TextHelper.futureTranslate(ChatFormatting.RED, "spawning.error.notlookingatblock", finalTarget.m_7755_()), false);
            return;
        }
        BlockPos hitPos = new BlockPos((int)result.m_82450_().f_82479_, (int)result.m_82450_().f_82480_, (int)result.m_82450_().f_82481_);
        if (this.isValidBlock != null && !this.isValidBlock.test(target.m_9236_().m_8055_(hitPos))) {
            sender.m_243053_((Component)TextHelper.translate(ChatFormatting.RED, "spawning.error.invalidblock"));
            return;
        }
        SpatialData data = AbstractSpawner.calculateSpatialData(target.m_9236_(), hitPos, 10, true, b -> true);
        SpawnLocation spawnLocation = new SpawnLocation((Entity)target, new MutableLocation(target.m_9236_(), hitPos), Sets.newHashSet((Object[])new LocationType[]{this.locationType}), data.baseBlock, data.uniqueSurroundingBlocks, (Holder<Biome>)target.m_9236_().m_204166_(hitPos), BetterSpawnerConfig.doesBlockSeeSky(target.m_9236_().m_8055_(hitPos)), 6, 0);
        sender.m_81377_().execute(() -> {
            ArrayList<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
            HashMap<SpawnLocation, List<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, List<SpawnInfo>>();
            possibleSpawns.put(spawnLocation, spawns);
            Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
            List<MutableComponent> messages = this.generateMessages(percentages, arguments);
            messages.add(0, TextHelper.translate(ChatFormatting.AQUA, "spawning.checkspawns.possiblespawns"));
            messages.forEach(arg_0 -> ((CommandSourceStack)sender).m_243053_(arg_0));
        });
    }
}

