/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns;

import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CheckSpawns;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerTrackingCheckSpawns
implements CheckSpawns {
    @Override
    public void checkSpawns(AbstractSpawner spawner, CommandSourceStack sender, List<String> arguments) {
        if (!(spawner instanceof PlayerTrackingSpawner)) {
            CheckSpawns.getDefault().checkSpawns(spawner, sender, arguments);
        } else {
            PlayerTrackingSpawner pSpawner = (PlayerTrackingSpawner)spawner;
            ServerPlayer player = pSpawner.getTrackedPlayer();
            if (player == null) {
                sender.m_288197_(() -> TextHelper.translate(ChatFormatting.RED, "pixelmon.command.general.invalidplayer"), false);
                return;
            }
            BlockCollection blocks = spawner.getTrackedBlockCollection((Entity)player, 0.0f, 0.0f, pSpawner.horizontalSliceRadius, pSpawner.verticalSliceRadius, 0, 0).join();
            ArrayList<SpawnLocation> spawnLocations = pSpawner.spawnLocationCalculator.calculateSpawnableLocations(blocks);
            for (String argument : arguments) {
                if (!argument.equalsIgnoreCase("specific")) continue;
                spawnLocations.removeIf(spawnLocation -> !spawnLocation.location.pos.equals((Object)player.m_20183_()));
                if (!spawnLocations.isEmpty()) break;
                sender.m_288197_(() -> TextHelper.translate(ChatFormatting.RED, "spawning.error.midairorinvalid"), false);
                return;
            }
            HashMap<SpawnLocation, ArrayList<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, ArrayList<SpawnInfo>>();
            for (SpawnLocation spawnLocation2 : spawnLocations) {
                ArrayList<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation2);
                if (spawns.isEmpty()) continue;
                possibleSpawns.put(spawnLocation2, spawns);
            }
            ServerLifecycleHooks.getCurrentServer().execute(() -> {
                Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
                List<MutableComponent> messages = this.generateMessages(percentages, arguments);
                messages.add(0, TextHelper.translate(ChatFormatting.AQUA, "spawning.checkspawns.possiblespawns"));
                for (MutableComponent message : messages) {
                    sender.m_288197_(() -> message, false);
                }
            });
        }
    }
}

