/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns;

import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CheckSpawns;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.entities.projectiles.HookEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.server.ServerLifecycleHooks;

public class FishingCheckSpawns
implements CheckSpawns {
    @Override
    public String getPermissionNode() {
        return "pixelmon.checkspawns.fishing";
    }

    @Override
    public void checkSpawns(AbstractSpawner spawner, CommandSourceStack sender, List<String> arguments) {
        ServerPlayer target = null;
        if (!(sender.m_81373_() instanceof ServerPlayer)) {
            PlayerList playerList = ServerLifecycleHooks.getCurrentServer().m_6846_();
            for (String argument : arguments) {
                if (!spawner.name.equals(argument) && (target = playerList.m_11255_(argument)) != null) break;
            }
            if (target == null) {
                sender.m_288197_(() -> TextHelper.translate(ChatFormatting.RED, "spawning.error.mustbeplayer"), false);
                return;
            }
        }
        if (target == null) {
            target = (ServerPlayer)sender.m_81373_();
        }
        if (!(target.f_36083_ instanceof HookEntity)) {
            ServerPlayer finalTarget = target;
            sender.m_288197_(() -> TextHelper.translate(ChatFormatting.RED, "spawning.error.notfishing", finalTarget.m_7755_()), false);
            return;
        }
        SpawnLocation spawnLocation = ((HookEntity)target.f_36083_).createSpawnLocation();
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            ArrayList<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
            if (spawnLocation.diameter == 0) {
                spawns.clear();
            }
            HashMap<SpawnLocation, List<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, List<SpawnInfo>>();
            possibleSpawns.put(spawnLocation, spawns);
            Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
            List<MutableComponent> messages = this.generateMessages(percentages, arguments);
            messages.add(0, TextHelper.translate(ChatFormatting.AQUA, "spawning.checkspawns.possiblespawns"));
            for (MutableComponent message : messages) {
                sender.m_288197_(() -> message, false);
            }
        });
    }
}

