/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TickingSpawner;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class SpawnerCoordinator {
    public final ArrayList<AbstractSpawner> spawners = new ArrayList();
    public static ExecutorService PROCESSOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("pixelmon_spawning_%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(Pixelmon.LOGGER)).build());
    private boolean active = false;

    public SpawnerCoordinator(AbstractSpawner ... spawners) {
        for (AbstractSpawner spawner : spawners) {
            if (spawner == null) continue;
            this.spawners.add(spawner);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER && this.active) {
            for (AbstractSpawner spawner : this.spawners) {
                spawner.spawnedTracker.removeNonExistent();
                if (!(spawner instanceof TickingSpawner) || !spawner.shouldDoSpawning()) continue;
                ((TickingSpawner)spawner).doPass(this);
            }
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public SpawnerCoordinator activate() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.active = true;
        return this;
    }

    public void deactivate() {
        this.spawners.clear();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.active = false;
    }

    @Nullable
    public AbstractSpawner getSpawner(String name) {
        for (AbstractSpawner spawner : this.spawners) {
            if (spawner == null || !spawner.name.equalsIgnoreCase(name)) continue;
            return spawner;
        }
        return null;
    }
}

