/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.spawning.SpawnEvent;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.eventbus.api.Event;

public abstract class SpawnAction<T extends Entity> {
    public SpawnInfo spawnInfo;
    public SpawnLocation spawnLocation;
    protected T entity;

    public SpawnAction(SpawnInfo spawnInfo, SpawnLocation spawnLocation) {
        this.spawnInfo = spawnInfo;
        this.spawnLocation = spawnLocation;
    }

    protected abstract T createEntity();

    public T getOrCreateEntity() {
        if (this.entity == null) {
            this.entity = this.createEntity();
        }
        return this.entity;
    }

    public void setEntity(T t) {
        if (t != null) {
            this.entity = t;
        }
    }

    @Nullable
    public T doSpawn(AbstractSpawner spawner) {
        if (!this.spawnLocation.location.world.m_46805_((BlockPos)this.spawnLocation.location.pos)) {
            return null;
        }
        this.getOrCreateEntity();
        if (this.entity == null || !this.entity.m_6084_()) {
            return null;
        }
        if (CollectionHelper.some(this.spawnInfo.tags, tag -> !PixelmonConfigProxy.getSpawning().checkInterval((String)tag))) {
            return null;
        }
        if (this.spawnLocation.location.world.m_6857_() != null && !this.spawnLocation.location.world.m_6857_().m_61937_((BlockPos)this.spawnLocation.location.pos)) {
            return null;
        }
        spawner.tweaks.forEach(tweak -> tweak.doTweak(spawner, this));
        SpawnEvent spawnEvent = new SpawnEvent(spawner, this);
        if (Pixelmon.EVENT_BUS.post((Event)spawnEvent)) {
            return null;
        }
        this.entity.m_6034_((double)this.spawnLocation.location.pos.m_123341_() + 0.5, (double)this.spawnLocation.location.pos.m_123342_(), (double)this.spawnLocation.location.pos.m_123343_() + 0.5);
        this.spawnLocation.location.world.m_7967_(this.entity);
        spawner.spawnedTracker.addEntity((Entity)this.entity);
        spawner.lastSpawnTime = System.currentTimeMillis();
        this.spawnInfo.tags.forEach(PixelmonConfigProxy.getSpawning()::consumeInterval);
        return this.entity;
    }

    public void applyLocationMutations() {
        for (LocationType type : this.spawnLocation.types) {
            if (!this.spawnInfo.locationTypes.contains(type)) continue;
            type.mutator.accept(this.spawnLocation);
        }
    }
}

