/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.spawning.CreateSpawnerEvent;
import com.pixelmonmod.pixelmon.api.spawning.RarityTweak;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCondition;
import com.pixelmonmod.pixelmon.api.spawning.SpawningTweak;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.selection.LocationWeightedAlgorithm;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.calculators.SelectionAlgorithm;
import com.pixelmonmod.pixelmon.api.spawning.conditions.RarityMultiplier;
import com.pixelmonmod.pixelmon.api.spawning.conditions.SpawnCondition;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.spawning.SpawnedTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class AbstractSpawner {
    public final String name;
    public final SpawnedTracker spawnedTracker = new SpawnedTracker(this);
    public SelectionAlgorithm selectionAlgorithm = new LocationWeightedAlgorithm();
    public CheckSpawns checkSpawns = CheckSpawns.getDefault();
    public List<SpawningTweak> tweaks = new ArrayList<SpawningTweak>();
    public List<SpawnerCondition> conditions = new ArrayList<SpawnerCondition>();
    public List<RarityTweak> rarityTweaks = new ArrayList<RarityTweak>();
    public List<RarityMultiplier> rarityMultipliers = new ArrayList<RarityMultiplier>();
    public volatile boolean isBusy = false;
    public long lastSpawnTime;
    public List<SpawnSet> spawnSets = new ArrayList<SpawnSet>();
    public transient Map<String, List<SpawnInfo>> cacheSets = null;

    public AbstractSpawner(String name) {
        this.name = name;
    }

    public boolean shouldDoSpawning() {
        return !this.isBusy;
    }

    public ArrayList<SpawnInfo> getSuitableSpawns(SpawnLocation spawnLocation) {
        ArrayList<SpawnInfo> suitableSpawns;
        block7: {
            block6: {
                List<SpawnInfo> spawnInfosAnyBiome;
                suitableSpawns = new ArrayList<SpawnInfo>();
                if (this.cacheSets == null) break block6;
                for (Object biomeTagKey : spawnLocation.biome.m_203616_().toList()) {
                    List<SpawnInfo> spawnInfos = this.cacheSets.get("#" + biomeTagKey.f_203868_());
                    if (spawnInfos == null) continue;
                    for (SpawnInfo spawnInfo : spawnInfos) {
                        if (!spawnInfo.fits(this, spawnLocation)) continue;
                        suitableSpawns.add(spawnInfo);
                    }
                }
                List<SpawnInfo> spawnInfos = this.cacheSets.get(((ResourceKey)spawnLocation.biome.m_203543_().get()).m_135782_().toString());
                if (spawnInfos != null) {
                    for (SpawnInfo spawnInfo : spawnInfos) {
                        if (!spawnInfo.fits(this, spawnLocation)) continue;
                        suitableSpawns.add(spawnInfo);
                    }
                }
                if ((spawnInfosAnyBiome = this.cacheSets.get("any")) == null) break block7;
                for (SpawnInfo spawnInfo : spawnInfosAnyBiome) {
                    if (!spawnInfo.fits(this, spawnLocation)) continue;
                    suitableSpawns.add(spawnInfo);
                }
                break block7;
            }
            for (SpawnSet set : this.spawnSets) {
                suitableSpawns.addAll(set.suitableSpawnsFor(this, spawnLocation));
            }
        }
        return suitableSpawns;
    }

    public boolean fits(SpawnInfo spawnInfo, SpawnLocation spawnLocation) {
        for (int i = 0; i < this.conditions.size(); ++i) {
            SpawnerCondition condition = this.conditions.get(i);
            if (condition.fits(this, spawnInfo, spawnLocation)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public SpawnInfo getWeightedSpawnInfo(SpawnLocation spawnLocation) {
        ArrayList<SpawnInfo> suitableSpawns = this.getSuitableSpawns(spawnLocation);
        if (suitableSpawns.isEmpty()) {
            return null;
        }
        return this.selectionAlgorithm.choose(this, spawnLocation, suitableSpawns);
    }

    public static SpatialData calculateSpatialData(Level world, BlockPos centre, int max, boolean includeDownwards, Predicate<BlockState> condition) {
        int[] nArray;
        BlockState state = world.m_8055_(centre);
        if (!condition.test(state)) {
            return new SpatialData(0, world.m_8055_(centre.m_7495_()).m_60734_(), Sets.newHashSet((Object[])new Block[]{state.m_60734_()}));
        }
        int r = 1;
        int[] xs = new int[]{-1, 1};
        if (includeDownwards) {
            int[] nArray2 = new int[2];
            nArray2[0] = -1;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        int[] ys = nArray;
        int[] zs = new int[]{-1, 1};
        int radius = r;
        block0: while (radius <= max) {
            for (int xMul : xs) {
                for (int zMul : zs) {
                    for (int yMul : ys) {
                        state = world.m_8055_(centre.m_7918_(xMul * r, yMul * r, zMul * r));
                        if (condition.test(state)) continue;
                        r = radius;
                        break block0;
                    }
                }
            }
            r = radius++;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        HashSet uniqueSurroundingBlocks = Sets.newHashSet();
        for (int xOffset = -r; xOffset <= r; ++xOffset) {
            for (int yOffset = -r; yOffset <= r; ++yOffset) {
                for (int zOffset = -r; zOffset <= r; ++zOffset) {
                    int x = xOffset + centre.m_123341_();
                    int y = yOffset + centre.m_123342_();
                    int z = zOffset + centre.m_123343_();
                    Block block = world.m_8055_((BlockPos)pos.m_122178_(x, y, z)).m_60734_();
                    uniqueSurroundingBlocks.add(block);
                }
            }
        }
        return new SpatialData(r, world.m_8055_(centre.m_7495_()).m_60734_(), uniqueSurroundingBlocks);
    }

    public CompletableFuture<BlockCollection> getTrackedBlockCollection(Entity entity, float horizontalTrackFactor, float verticalTrackFactor, int horizontalSliceRadius, int verticalSliceRadius, int minDistFromCentre, int maxDistFromCentre) {
        if (entity == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (ServerLifecycleHooks.getCurrentServer().m_18695_()) {
            return CompletableFuture.completedFuture(this.getThreadSafeBlockCollection(entity, horizontalTrackFactor, verticalTrackFactor, horizontalSliceRadius, verticalSliceRadius, minDistFromCentre, maxDistFromCentre));
        }
        return CompletableFuture.supplyAsync(() -> this.getThreadSafeBlockCollection(entity, horizontalTrackFactor, verticalTrackFactor, horizontalSliceRadius, verticalSliceRadius, minDistFromCentre, maxDistFromCentre), (Executor)ServerLifecycleHooks.getCurrentServer());
    }

    private BlockCollection getThreadSafeBlockCollection(Entity entity, float horizontalTrackFactor, float verticalTrackFactor, int horizontalSliceRadius, int verticalSliceRadius, int minDistFromCentre, int maxDistFromCentre) {
        BlockPos centre = entity.m_20183_().m_7918_((int)((double)horizontalTrackFactor * entity.m_20184_().f_82479_), (int)((double)verticalTrackFactor * entity.m_20184_().f_82480_), (int)((double)horizontalTrackFactor * entity.m_20184_().f_82481_));
        float theta = RandomHelper.getRandomNumberBetween(0.0f, (float)Math.PI * 2);
        int r = RandomHelper.getRandomNumberBetween(minDistFromCentre, maxDistFromCentre);
        int xDisplacement = (int)((double)r * Math.cos(theta));
        int zDisplacement = (int)((double)r * Math.sin(theta));
        centre = centre.m_7918_(xDisplacement, 0, zDisplacement);
        return new BlockCollection(entity, entity.m_9236_(), centre.m_123341_() - horizontalSliceRadius, centre.m_123341_() + horizontalSliceRadius, centre.m_123342_() - verticalSliceRadius, centre.m_123342_() + verticalSliceRadius, centre.m_123343_() - horizontalSliceRadius, centre.m_123343_() + horizontalSliceRadius);
    }

    public boolean hasTweak(Class<? extends SpawningTweak> clazz) {
        return CollectionHelper.containsA(this.tweaks, clazz);
    }

    @Nullable
    public <T extends SpawningTweak> T getTweak(Class<T> clazz) {
        return (T)((SpawningTweak)CollectionHelper.getFirst(this.tweaks, clazz));
    }

    public boolean hasCondition(Class<? extends SpawnerCondition> clazz) {
        return CollectionHelper.containsA(this.conditions, clazz);
    }

    @Nullable
    public <T extends SpawnerCondition> T getCondition(Class<T> clazz) {
        return (T)((SpawnerCondition)CollectionHelper.getFirst(this.conditions, clazz));
    }

    public static class SpawnerBuilder<T extends AbstractSpawner> {
        public Map<String, List<SpawnInfo>> cacheMap = new HashMap<String, List<SpawnInfo>>();
        public List<SpawnSet> spawnSets = new ArrayList<SpawnSet>();
        public SelectionAlgorithm selectionAlgorithm = new LocationWeightedAlgorithm();
        public CheckSpawns checkSpawns = CheckSpawns.getDefault();
        public List<SpawningTweak> tweaks = new ArrayList<SpawningTweak>();
        public List<SpawnerCondition> conditions = new ArrayList<SpawnerCondition>();
        public List<RarityMultiplier> rarityMultipliers = new ArrayList<RarityMultiplier>();

        public <E extends SpawnerBuilder<T>> E addSpawnSets(SpawnSet ... spawnSets) {
            this.spawnSets.addAll(Arrays.asList(spawnSets));
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E addSpawnSets(Collection<SpawnSet> spawnSets) {
            this.spawnSets.addAll(spawnSets);
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setSpawnSets(SpawnSet ... spawnSets) {
            this.spawnSets.clear();
            return this.addSpawnSets(spawnSets);
        }

        public <E extends SpawnerBuilder<T>> E setSpawnSets(List<SpawnSet> spawnSets) {
            this.spawnSets = spawnSets;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setupCache() {
            this.cacheMap.clear();
            for (SpawnSet set : this.spawnSets) {
                for (SpawnInfo info : set) {
                    Set<TagEntry> conditionBiomes;
                    HashSet biomes = Sets.newHashSet();
                    Set<TagEntry> set2 = conditionBiomes = info.condition != null && info.condition.biomes != null && !info.condition.biomes.isEmpty() ? info.condition.biomes : Collections.emptySet();
                    if (conditionBiomes.isEmpty()) {
                        this.cacheMap.computeIfAbsent("any", unused -> Lists.newArrayList()).add(info);
                        continue;
                    }
                    for (TagEntry conditionBiome : conditionBiomes) {
                        biomes.add(conditionBiome);
                    }
                    if (info.compositeCondition != null && info.compositeCondition.conditions != null) {
                        for (SpawnCondition condition : info.compositeCondition.conditions) {
                            if (condition.biomes == null || condition.biomes.isEmpty()) continue;
                            for (TagEntry biome : condition.biomes) {
                                biomes.add(biome);
                            }
                        }
                    }
                    for (TagEntry biome : biomes) {
                        if (biome == null) continue;
                        this.cacheMap.computeIfAbsent(biome.toString(), unused -> Lists.newArrayList()).add(info);
                    }
                }
            }
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setSelectionAlgorithm(SelectionAlgorithm selectionAlgorithm) {
            this.selectionAlgorithm = selectionAlgorithm;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setCheckSpawns(CheckSpawns checkSpawns) {
            this.checkSpawns = checkSpawns;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E addTweak(SpawningTweak tweak) {
            this.tweaks.add(tweak);
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setTweaks(List<SpawningTweak> tweaks) {
            this.tweaks = tweaks;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E addCondition(SpawnerCondition condition) {
            this.conditions.add(condition);
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setConditions(List<SpawnerCondition> conditions) {
            this.conditions = conditions;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E addRarityMultiplier(RarityMultiplier rarityMultiplier) {
            this.rarityMultipliers.add(rarityMultiplier);
            return (E)((SpawnerBuilder)this.getThis());
        }

        public <E extends SpawnerBuilder<T>> E setRarityMultipliers(List<RarityMultiplier> rarityMultipliers) {
            this.rarityMultipliers = rarityMultipliers;
            return (E)((SpawnerBuilder)this.getThis());
        }

        public T apply(T spawner) {
            ((AbstractSpawner)spawner).spawnSets = this.spawnSets;
            ((AbstractSpawner)spawner).selectionAlgorithm = this.selectionAlgorithm;
            ((AbstractSpawner)spawner).checkSpawns = this.checkSpawns;
            ((AbstractSpawner)spawner).tweaks = new ArrayList<SpawningTweak>(this.tweaks);
            ((AbstractSpawner)spawner).conditions = this.conditions;
            ((AbstractSpawner)spawner).rarityMultipliers = this.rarityMultipliers;
            if (this.cacheMap != null && !this.cacheMap.isEmpty()) {
                ((AbstractSpawner)spawner).cacheSets = this.cacheMap;
            }
            Pixelmon.EVENT_BUS.post((Event)new CreateSpawnerEvent((AbstractSpawner)spawner, this));
            return spawner;
        }

        protected <E> E getThis() {
            return (E)this;
        }
    }
}

