/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.selection;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.selection.PartySelectionFactory;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.selection.OpenSelectionPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.selection.SetSelectionOptionsPacket;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PartySelectionScreen {
    public static void openSelection(ServerPlayer player, BiConsumer<ServerPlayer, List<Pokemon>> consumer) {
        PartySelectionScreen.builder().party((Player)player).consumer(consumer).sendTo(player);
    }

    public static void openSelection(ServerPlayer player, BiConsumer<ServerPlayer, List<Pokemon>> consumer, Pokemon ... options) {
        PartySelectionScreen.builder().options(options).consumer(consumer).sendTo(player);
    }

    public static void openSelection(ServerPlayer player, int selections, BiConsumer<ServerPlayer, List<Pokemon>> consumer, Pokemon ... options) {
        PartySelectionScreen.builder().selections(selections).consumer(consumer).options(options).sendTo(player);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Component title = Component.m_237113_((String)"");
        private Component text = Component.m_237113_((String)"");
        private List<Pokemon> options = Lists.newArrayList();
        private int selections = 6;
        private boolean allowExit = false;
        private BiConsumer<ServerPlayer, List<Pokemon>> consumer = null;

        public Builder title(Component title) {
            this.title = (Component)Preconditions.checkNotNull((Object)title, (Object)"title");
            return this;
        }

        public Builder title(String title) {
            this.title = Component.m_237113_((String)((String)Preconditions.checkNotNull((Object)title, (Object)"title")));
            return this;
        }

        public Builder text(Component text) {
            this.text = (Component)Preconditions.checkNotNull((Object)text, (Object)"text");
            return this;
        }

        public Builder text(String text) {
            this.text = Component.m_237113_((String)((String)Preconditions.checkNotNull((Object)text, (Object)"text")));
            return this;
        }

        public Builder selections(int selections) {
            this.selections = selections > 6 ? 6 : Math.max(selections, 1);
            return this;
        }

        public Builder option(Pokemon pokemon) {
            return this.options(pokemon);
        }

        public Builder options(Pokemon ... pokemons) {
            return this.options(Lists.newArrayList((Object[])pokemons));
        }

        public Builder options(List<Pokemon> options) {
            if (this.options.size() + options.size() > 6) {
                return this;
            }
            this.options.addAll(options);
            return this;
        }

        public Builder clearOptions() {
            this.options.clear();
            return this;
        }

        public Builder party(Player player) {
            this.options.clear();
            this.options(StorageProxy.getPartyNow(player.m_20148_()).getAll());
            return this;
        }

        public Builder consumer(BiConsumer<ServerPlayer, List<Pokemon>> consumer) {
            this.consumer = consumer;
            return this;
        }

        public Builder enforceSelection() {
            this.allowExit = false;
            return this;
        }

        public Builder allowExit() {
            this.allowExit = true;
            return this;
        }

        public void sendTo(ServerPlayer player) {
            PartySelectionFactory.beginSelection(player, this.consumer, this.options);
            NetworkHelper.sendPacket(new OpenSelectionPacket(this.title, this.text, this.selections, this.allowExit), player);
            for (int i = 0; i < this.options.size(); ++i) {
                NetworkHelper.sendPacket(new SetSelectionOptionsPacket(i, this.options.get(i)), player);
            }
        }
    }
}

