/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.selection;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerPlayer;

public class PartySelectionFactory {
    private static final Map<UUID, SelectionData> OPEN_SELECTIONS = Maps.newConcurrentMap();

    public static void beginSelection(ServerPlayer player, BiConsumer<ServerPlayer, List<Pokemon>> consumer, List<Pokemon> options) {
        OPEN_SELECTIONS.put(player.m_20148_(), new SelectionData(player.m_20148_(), consumer, options));
    }

    public static SelectionData getSelectionConsumer(ServerPlayer player) {
        return OPEN_SELECTIONS.get(player.m_20148_());
    }

    public static void removeSelection(ServerPlayer player) {
        OPEN_SELECTIONS.remove(player.m_20148_());
    }

    public static boolean inSelection(ServerPlayer player) {
        return OPEN_SELECTIONS.containsKey(player.m_20148_());
    }

    public static class SelectionData {
        private final UUID player;
        private final BiConsumer<ServerPlayer, List<Pokemon>> consumer;
        private final List<Pokemon> pokemon;

        public SelectionData(UUID player, BiConsumer<ServerPlayer, List<Pokemon>> consumer, List<Pokemon> pokemon) {
            this.player = player;
            this.consumer = consumer;
            this.pokemon = pokemon;
        }

        public UUID getPlayer() {
            return this.player;
        }

        public BiConsumer<ServerPlayer, List<Pokemon>> getConsumer() {
            return this.consumer;
        }

        public List<Pokemon> getPokemon() {
            return this.pokemon;
        }
    }
}

