/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.screens;

import com.mojang.blaze3d.platform.Window;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.listener.SendoutListener;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OverlayScreenState {
    ALL{

        @Override
        public void renderParty(GuiGraphics matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
            Window var5 = mc.m_91268_();
            int screenHeight = var5.m_85446_();
            int leftText = 30;
            int topSideBar = screenHeight / 2 - 100;
            int topOffset = topSideBar + 5;
            float slotHeight = 30.0f;
            int i = -1;
            Font fontRenderer = mc.f_91062_;
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.dock, matrix, 0.0f, topSideBar, 22.0f, 203.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 0.0f);
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, 0.5f, topSideBar - 9, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 1.0f);
            } else {
                ScreenHelper.drawImageQuad(Resources.dock, matrix, 0.0f, topSideBar, 22.0f, 203.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 1.0f, 0.0f);
            }
            for (Pokemon pokemon : party) {
                int offset = 0;
                int yPos = topOffset + (int)((float)(++i) * slotHeight) + 9 + offset;
                if (pokemon != null) {
                    boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (Level)mc.f_91073_);
                    ScreenHelper.drawImageQuad(Resources.textbox, matrix, leftText - 28, yPos - 10, 123.0f, 34.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    float textureX = -1.0f;
                    float textureY = -1.0f;
                    float[] texturePair = StatusType.getTexturePos(pokemon.getStatus().type);
                    textureX = texturePair[0];
                    textureY = texturePair[1];
                    if (textureX != -1.0f && !pokemon.isFainted()) {
                        ScreenHelper.simpleDrawImageQuad(Resources.status, matrix, leftText + 56, yPos + 1, 8.0f, 8.0f, textureX / 768.0f, textureY / 768.0f, (textureX + 240.0f) / 768.0f, (textureY + 240.0f) / 768.0f, 0.0f);
                    }
                    Component displayName = pokemon.getFormattedDisplayName();
                    if (pokemon.getGender() == Gender.MALE && !pokemon.isEgg()) {
                        ScreenHelper.drawImageQuad(Resources.male, matrix, ScreenHelper.getStringWidth(displayName, true) + leftText - 1, yPos, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    } else if (pokemon.getGender() == Gender.FEMALE && !pokemon.isEgg()) {
                        ScreenHelper.drawImageQuad(Resources.female, matrix, ScreenHelper.getStringWidth(displayName, true) + leftText - 1, yPos, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    }
                    ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    ResourceLocation rl = i == selectedIndex ? (pokemon.isFainted() ? Resources.faintedSelected : (isSentOut ? Resources.releasedSelected : Resources.selected)) : (pokemon.isFainted() ? Resources.fainted : (isSentOut ? Resources.released : Resources.normal));
                    ScreenHelper.drawImageQuad(rl, matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, 1.0f, yPos - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    if (pokemon.getHeldItem().m_41619_()) continue;
                    ScreenHelper.drawImageQuad(Resources.heldItem, matrix, 18.0f, yPos + 13, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    continue;
                }
                ScreenHelper.drawImageQuad(Resources.available, matrix, 5.0f, yPos + 1, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            matrix.m_286007_(() -> {
                int counter = -1;
                for (Pokemon pokemon : party) {
                    int offset = 0;
                    int yPos = topOffset + (int)((float)(++counter) * slotHeight) + 9 + offset;
                    if (pokemon == null) continue;
                    Component displayName = pokemon.getFormattedDisplayName();
                    ScreenHelper.drawString(matrix, fontRenderer, displayName, (float)(leftText - 2), (float)yPos, 0xFFFFFF, false, true);
                    if (pokemon.isEgg()) continue;
                    String levelString = I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getPokemonLevel();
                    float f = leftText - 1;
                    Objects.requireNonNull(fontRenderer);
                    ScreenHelper.drawString(matrix, levelString, f, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                    if (pokemon.isFainted()) {
                        String string = I18n.m_118938_((String)"gui.creativeinv.fainted", (Object[])new Object[0]);
                        float f2 = leftText + 1 + ScreenHelper.getStringWidth(levelString, true);
                        Objects.requireNonNull(fontRenderer);
                        ScreenHelper.drawString(matrix, string, f2, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                        continue;
                    }
                    String string = I18n.m_118938_((String)"nbt.hp", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getMaxHealth();
                    float f3 = leftText + 2 + ScreenHelper.getStringWidth(levelString, true);
                    Objects.requireNonNull(fontRenderer);
                    ScreenHelper.drawString(matrix, string, f3, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                }
            });
        }
    }
    ,
    SPRITES{

        @Override
        public void renderParty(GuiGraphics matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
            Window var5 = mc.m_91268_();
            int screenHeight = var5.m_85446_();
            int topSideBar = screenHeight / 2 - 100;
            int topOffset = topSideBar + 5;
            float slotHeight = 30.0f;
            int i = -1;
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.dock, matrix, 0.0f, topSideBar, 22.0f, 203.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 0.0f);
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, 0.5f, topSideBar - 9, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 1.0f);
            } else {
                ScreenHelper.drawImageQuad(Resources.dock, matrix, 0.0f, topSideBar, 22.0f, 203.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 1.0f, 0.0f);
            }
            for (Pokemon pokemon : party) {
                int offset = 0;
                int yPos = topOffset + (int)((float)(++i) * slotHeight) + 9 + offset;
                if (pokemon != null) {
                    boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (Level)mc.f_91073_);
                    ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    ResourceLocation rl = i == selectedIndex ? (pokemon.isFainted() ? Resources.faintedSelected : (isSentOut ? Resources.releasedSelected : Resources.selected)) : (pokemon.isFainted() ? Resources.fainted : (isSentOut ? Resources.released : Resources.normal));
                    ScreenHelper.drawImageQuad(rl, matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, 1.0f, yPos - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    if (pokemon.getHeldItem().m_41619_()) continue;
                    ScreenHelper.drawImageQuad(Resources.heldItem, matrix, 18.0f, yPos + 13, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    continue;
                }
                ScreenHelper.drawImageQuad(Resources.available, matrix, 5.0f, yPos + 1, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }
    ,
    TOP_LEFT_LABEL{

        @Override
        public void renderParty(GuiGraphics matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
            int leftText = 30;
            int yPos = 5;
            Pokemon pokemon = party[selectedIndex];
            boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (Level)mc.f_91073_);
            float textureX = -1.0f;
            float textureY = -1.0f;
            Font fontRenderer = mc.f_91062_;
            Component displayName = pokemon.getFormattedDisplayName();
            float[] texturePair = StatusType.getTexturePos(pokemon.getStatus().type);
            textureX = texturePair[0];
            textureY = texturePair[1];
            ScreenHelper.drawImageQuad(Resources.textbox, matrix, leftText - 28, yPos - 10, 123.0f, 34.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, 30.0f, 5.0f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 0.0f);
            }
            if (textureX != -1.0f && !pokemon.isFainted()) {
                ScreenHelper.simpleDrawImageQuad(Resources.status, matrix, leftText + 56, yPos + 1, 8.0f, 8.0f, textureX / 768.0f, textureY / 768.0f, (textureX + 240.0f) / 768.0f, (textureY + 240.0f) / 768.0f, 0.0f);
            }
            if (pokemon.getGender() == Gender.MALE && !pokemon.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.male, matrix, ScreenHelper.getStringWidth(displayName, true) + leftText - 1, yPos, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            } else if (pokemon.getGender() == Gender.FEMALE && !pokemon.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.female, matrix, ScreenHelper.getStringWidth(displayName, true) + leftText - 1, yPos, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            ScreenHelper.drawString(matrix, fontRenderer, displayName, (float)(leftText - 2), (float)yPos, 0xFFFFFF, false, true);
            ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ResourceLocation rl = pokemon.isFainted() ? Resources.faintedSelected : (isSentOut ? Resources.releasedSelected : Resources.selected);
            ScreenHelper.drawImageQuad(rl, matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, 1.0f, yPos - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (!pokemon.getHeldItem().m_41619_()) {
                ScreenHelper.drawImageQuad(Resources.heldItem, matrix, 18.0f, yPos + 13, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            if (!pokemon.isEgg()) {
                String levelString = I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getPokemonLevel();
                float f = leftText - 1;
                Objects.requireNonNull(fontRenderer);
                ScreenHelper.drawString(matrix, levelString, f, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                if (pokemon.isFainted()) {
                    String string = I18n.m_118938_((String)"gui.creativeinv.fainted", (Object[])new Object[0]);
                    float f2 = leftText + 1 + ScreenHelper.getStringWidth(levelString, true);
                    Objects.requireNonNull(fontRenderer);
                    ScreenHelper.drawString(matrix, string, f2, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                } else {
                    String string = I18n.m_118938_((String)"nbt.hp", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getMaxHealth();
                    float f3 = leftText + 2 + ScreenHelper.getStringWidth(levelString, true);
                    Objects.requireNonNull(fontRenderer);
                    ScreenHelper.drawString(matrix, string, f3, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                }
            }
        }
    }
    ,
    TOP_LEFT{

        @Override
        public void renderParty(GuiGraphics matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
            int yPos = 5;
            Pokemon pokemon = party[selectedIndex];
            boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (Level)mc.f_91073_);
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, 30.0f, 5.0f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 0.0f);
            }
            ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ResourceLocation rl = pokemon.isFainted() ? Resources.faintedSelected : (isSentOut ? Resources.releasedSelected : Resources.selected);
            ScreenHelper.drawImageQuad(rl, matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, 1.0f, yPos - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (!pokemon.getHeldItem().m_41619_()) {
                ScreenHelper.drawImageQuad(Resources.heldItem, matrix, 18.0f, yPos + 13, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }
    ,
    BOTTOM_LEFT_LABEL{

        @Override
        public void renderParty(GuiGraphics matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
            int leftText = 30;
            int yPos = mc.m_91268_().m_85446_() - 22;
            Pokemon pokemon = party[selectedIndex];
            boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (Level)mc.f_91073_);
            Font fontRenderer = mc.f_91062_;
            Component displayName = pokemon.getFormattedDisplayName();
            float[] texturePair = StatusType.getTexturePos(pokemon.getStatus().type);
            float textureX = texturePair[0];
            float textureY = texturePair[1];
            ScreenHelper.drawImageQuad(Resources.textbox, matrix, leftText - 28, yPos - 10, 123.0f, 34.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, 30.0f, 5.0f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 0.0f);
            }
            if (textureX != -1.0f && !pokemon.isFainted()) {
                ScreenHelper.simpleDrawImageQuad(Resources.status, matrix, leftText + 56, yPos + 1, 8.0f, 8.0f, textureX / 768.0f, textureY / 768.0f, (textureX + 240.0f) / 768.0f, (textureY + 240.0f) / 768.0f, 0.0f);
            }
            if (pokemon.getGender() == Gender.MALE && !pokemon.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.male, matrix, ScreenHelper.getStringWidth(displayName, true) + leftText - 1, yPos, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            } else if (pokemon.getGender() == Gender.FEMALE && !pokemon.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.female, matrix, ScreenHelper.getStringWidth(displayName, true) + leftText - 1, yPos, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            ScreenHelper.drawString(matrix, fontRenderer, displayName, (float)(leftText - 2), (float)yPos, 0xFFFFFF, false, true);
            ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ResourceLocation rl = pokemon.isFainted() ? Resources.faintedSelected : (isSentOut ? Resources.releasedSelected : Resources.selected);
            ScreenHelper.drawImageQuad(rl, matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, 1.0f, yPos - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (!pokemon.getHeldItem().m_41619_()) {
                ScreenHelper.drawImageQuad(Resources.heldItem, matrix, 18.0f, yPos + 13, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            if (!pokemon.isEgg()) {
                String levelString = I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getPokemonLevel();
                float f = leftText - 1;
                Objects.requireNonNull(fontRenderer);
                ScreenHelper.drawString(matrix, levelString, f, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                if (pokemon.isFainted()) {
                    String string = I18n.m_118938_((String)"gui.creativeinv.fainted", (Object[])new Object[0]);
                    float f2 = leftText + 1 + ScreenHelper.getStringWidth(levelString, true);
                    Objects.requireNonNull(fontRenderer);
                    ScreenHelper.drawString(matrix, string, f2, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                } else {
                    String string = I18n.m_118938_((String)"nbt.hp", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getMaxHealth();
                    float f3 = leftText + 2 + ScreenHelper.getStringWidth(levelString, true);
                    Objects.requireNonNull(fontRenderer);
                    ScreenHelper.drawString(matrix, string, f3, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                }
            }
        }
    }
    ,
    BOTTOM_LEFT{

        @Override
        public void renderParty(GuiGraphics matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
            int yPos = mc.m_91268_().m_85446_() - 22;
            Pokemon pokemon = party[selectedIndex];
            boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (Level)mc.f_91073_);
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, 30.0f, 5.0f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 0.0f);
            }
            ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ResourceLocation rl = pokemon.isFainted() ? Resources.faintedSelected : (isSentOut ? Resources.releasedSelected : Resources.selected);
            ScreenHelper.drawImageQuad(rl, matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, 1.0f, yPos - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (!pokemon.getHeldItem().m_41619_()) {
                ScreenHelper.drawImageQuad(Resources.heldItem, matrix, 18.0f, yPos + 13, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }
    ,
    NONE{

        @Override
        public void renderParty(GuiGraphics matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
        }
    };

    private static final OverlayScreenState[] VALUES;

    public abstract void renderParty(GuiGraphics var1, Minecraft var2, int var3, Pokemon[] var4);

    public OverlayScreenState getNextState() {
        int state = this.ordinal();
        if (state + 1 == VALUES.length) {
            return VALUES[0];
        }
        return VALUES[state + 1];
    }

    static {
        VALUES = OverlayScreenState.values();
    }
}

