/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.replacement.logic;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.replacement.logic.AbstractReplacementLogic;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.List;
import net.minecraft.server.TickTask;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;

public class SimpleReplacementLogic
extends AbstractReplacementLogic {
    protected List<PokemonSpecification> replacements = Lists.newArrayList();

    public SimpleReplacementLogic() {
        super("simple");
    }

    public SimpleReplacementLogic(String id) {
        super(id);
    }

    @Override
    public void replaceSpawn(EntityJoinLevelEvent event) {
        event.setCanceled(true);
        if (this.replacements.isEmpty()) {
            return;
        }
        PokemonSpecification replacement = RandomHelper.getRandomElementFromCollection(this.replacements);
        PixelmonEntity pixelmonEntity = replacement.create(event.getLevel());
        pixelmonEntity.m_6034_(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_());
        if (event.getEntity().m_6095_().m_20674_() == MobCategory.MONSTER) {
            pixelmonEntity.setAggression(Aggression.AGGRESSIVE);
        } else {
            pixelmonEntity.setAggression(Aggression.PASSIVE);
        }
        MobCategory classification = event.getEntity().getClassification(true);
        pixelmonEntity.setSpawnReplaceClassification(classification);
        if (classification == MobCategory.WATER_AMBIENT || classification == MobCategory.WATER_CREATURE) {
            pixelmonEntity.setSpawnLocation(SpawnLocationType.WATER);
        }
        pixelmonEntity.resetAI();
        event.getEntity().m_20194_().m_6937_((Runnable)new TickTask(0, () -> event.getLevel().m_7967_((Entity)pixelmonEntity)));
    }

    @Override
    public void read(Gson context, JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        if (!object.has("specs")) {
            return;
        }
        for (JsonElement specs : object.getAsJsonArray("specs")) {
            ParseAttempt<PokemonSpecification> parseAttempt = PokemonSpecificationProxy.create(specs.getAsString());
            if (!parseAttempt.wasSuccess()) {
                throw new JsonParseException("Invalid spec: " + parseAttempt.getError() + " (" + specs.getAsString() + ")");
            }
            this.replacements.add(parseAttempt.get());
        }
    }
}

