/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.registries;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.pokemon.egg.EggGroup;
import com.pixelmonmod.pixelmon.api.registries.PixelmonEggGroups;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class EggGroupRegistry {
    private static final Map<String, EggGroup> REGISTERED_EGG_GROUPS = Maps.newConcurrentMap();

    public static <T extends EggGroup> T register(T t) {
        REGISTERED_EGG_GROUPS.put(t.getKey().toLowerCase(Locale.ROOT), t);
        return t;
    }

    public static <T extends EggGroup> Optional<T> getEggGroup(String key) {
        return Optional.ofNullable(REGISTERED_EGG_GROUPS.get(key.toLowerCase(Locale.ROOT)));
    }

    public static <T extends EggGroup> T unregister(T t) {
        REGISTERED_EGG_GROUPS.remove(t.getKey().toLowerCase(Locale.ROOT));
        return t;
    }

    public static List<EggGroup> getAll() {
        return Lists.newArrayList(REGISTERED_EGG_GROUPS.values());
    }

    public static int getCount() {
        return REGISTERED_EGG_GROUPS.size();
    }

    static {
        PixelmonEggGroups.init();
    }
}

