/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.recipe;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipeCodecs;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.NotImplementedException;

public class NoMirrorShapedRecipe
extends ShapedRecipe {
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack result;

    public NoMirrorShapedRecipe(String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        super(group, category, width, height, recipeItems, result);
        this.recipeItems = recipeItems;
        this.result = result;
    }

    public boolean m_5818_(CraftingContainer inventory, Level level) {
        for (int i = 0; i <= inventory.m_39347_() - this.m_44220_(); ++i) {
            for (int j = 0; j <= inventory.m_39346_() - this.m_44221_(); ++j) {
                if (!this.m_44170_(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean m_44170_(CraftingContainer inventory, int originX, int originY, boolean invert) {
        for (int i = 0; i < inventory.m_39347_(); ++i) {
            for (int j = 0; j < inventory.m_39346_(); ++j) {
                int k = i - originX;
                int l = j - originY;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.m_44220_() && l < this.m_44221_()) {
                    ingredient = invert ? (Ingredient)this.recipeItems.get(this.m_44220_() - k - 1 + l * this.m_44220_()) : (Ingredient)this.recipeItems.get(k + l * this.m_44220_());
                }
                if (ingredient.test(inventory.m_8020_(i + j * inventory.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<NoMirrorShapedRecipe> {
        static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().flatXmap(p_297814_ -> {
            if (p_297814_.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (p_297814_.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i = ((String)p_297814_.get(0)).length();
            for (String s : p_297814_) {
                if (s.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if (i == s.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)p_297814_);
        }, DataResult::success);
        static final Codec<String> SINGLE_CHARACTER_STRING_CODEC = Codec.STRING.flatXmap(p_301277_ -> {
            if (p_301277_.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + p_301277_ + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(p_301277_) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)p_301277_);
        }, DataResult::success);
        private static final Codec<NoMirrorShapedRecipe> CODEC = RawShapedRecipe.CODEC.flatXmap(p_300056_ -> {
            String[] astring = ShapedRecipe.m_44186_(p_300056_.pattern);
            int i = astring[0].length();
            int j = astring.length;
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            HashSet set = Sets.newHashSet(p_300056_.key.keySet());
            for (int k = 0; k < astring.length; ++k) {
                String s = astring[k];
                for (int l = 0; l < s.length(); ++l) {
                    Ingredient ingredient;
                    String s1 = s.substring(l, l + 1);
                    Ingredient ingredient2 = ingredient = s1.equals(" ") ? Ingredient.f_43901_ : p_300056_.key.get(s1);
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + s1 + "' but it's not defined in the key");
                    }
                    set.remove(s1);
                    nonnulllist.set(l + i * k, (Object)ingredient);
                }
            }
            if (!set.isEmpty()) {
                return DataResult.error(() -> "Key defines symbols that aren't used in pattern: " + set);
            }
            NoMirrorShapedRecipe shapedrecipe = new NoMirrorShapedRecipe(p_300056_.group, p_300056_.category, i, j, (NonNullList<Ingredient>)nonnulllist, p_300056_.result);
            return DataResult.success((Object)((Object)shapedrecipe));
        }, p_299463_ -> {
            throw new NotImplementedException("Serializing ShapedRecipe is not implemented yet.");
        });

        public Codec<NoMirrorShapedRecipe> m_292673_() {
            return CODEC;
        }

        public NoMirrorShapedRecipe fromNetwork(FriendlyByteBuf p_44234_) {
            int i = p_44234_.m_130242_();
            int j = p_44234_.m_130242_();
            String s = p_44234_.m_130277_();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_44234_.m_130066_(CraftingBookCategory.class);
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)p_44234_));
            }
            ItemStack itemstack = p_44234_.m_130267_();
            return new NoMirrorShapedRecipe(s, craftingbookcategory, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(FriendlyByteBuf p_44227_, NoMirrorShapedRecipe p_44228_) {
            p_44227_.m_130130_(p_44228_.f_44146_);
            p_44227_.m_130130_(p_44228_.f_44147_);
            p_44227_.m_130070_(p_44228_.f_44151_);
            p_44227_.m_130068_((Enum)p_44228_.f_244483_);
            for (Ingredient ingredient : p_44228_.recipeItems) {
                ingredient.m_43923_(p_44227_);
            }
            p_44227_.m_130055_(p_44228_.result);
        }

        record RawShapedRecipe(String group, CraftingBookCategory category, Map<String, Ingredient> key, List<String> pattern, ItemStack result, boolean showNotification) {
            public static final Codec<RawShapedRecipe> CODEC = RecordCodecBuilder.create(p_298430_ -> p_298430_.group((App)ExtraCodecs.m_295827_((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(p_300105_ -> p_300105_.group), (App)CraftingBookCategory.f_244644_.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301213_ -> p_301213_.category), (App)ExtraCodecs.m_295464_(SINGLE_CHARACTER_STRING_CODEC, (Codec)Ingredient.f_290991_).fieldOf("key").forGetter(p_297983_ -> p_297983_.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(p_300956_ -> p_300956_.pattern), (App)CraftingRecipeCodecs.f_290789_.fieldOf("result").forGetter(p_299535_ -> p_299535_.result), (App)ExtraCodecs.m_295827_((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(p_297368_ -> p_297368_.showNotification)).apply((Applicative)p_298430_, RawShapedRecipe::new));
        }
    }
}

