/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.api.recipe.QuantifiedIngredient;
import com.pixelmonmod.pixelmon.init.registry.RecipeTypeRegistration;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipeCodecs;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class InfuserRecipe
implements Recipe<Container> {
    protected final List<QuantifiedIngredient> input;
    protected final ItemStack result;

    public InfuserRecipe(List<QuantifiedIngredient> in, ItemStack out) {
        this.input = in;
        this.result = out;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.input.get(0).matches(inv.m_8020_(1)) && this.input.get(1).matches(inv.m_8020_(2));
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.result;
    }

    @Nonnull
    public RecipeSerializer<InfuserRecipe> m_7707_() {
        return (RecipeSerializer)RecipeTypeRegistration.INFUSER_RECIPES.get();
    }

    @Nonnull
    public RecipeType<InfuserRecipe> m_6671_() {
        return RecipeTypeRegistration.INFUSER_RECIPE_TYPE;
    }

    public List<QuantifiedIngredient> getQualifiedIngredients() {
        return this.input;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Type
    implements RecipeType<InfuserRecipe> {
    }

    public static class Serializer
    implements RecipeSerializer<InfuserRecipe> {
        public static final Codec<InfuserRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.f_290991_.xmap(ingredient -> new QuantifiedIngredient((Ingredient)ingredient, 1), quantifiedIngredient -> quantifiedIngredient.ingredient).listOf().fieldOf("ingredients").forGetter(o -> o.input), (App)CraftingRecipeCodecs.f_290789_.fieldOf("results").forGetter(o -> o.result)).apply((Applicative)instance, InfuserRecipe::new));
        protected NonNullList<QuantifiedIngredient> input;
        protected ItemStack result;

        public Codec<InfuserRecipe> m_292673_() {
            return CODEC;
        }

        public InfuserRecipe fromNetwork(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)size, (Object)new QuantifiedIngredient(Ingredient.f_43901_, 0));
            for (int i = 0; i < size; ++i) {
                nonnulllist.set(i, (Object)new QuantifiedIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readInt()));
            }
            ItemStack output = buffer.m_130267_();
            return new InfuserRecipe((List<QuantifiedIngredient>)nonnulllist, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, InfuserRecipe recipe) {
            buffer.m_130130_(recipe.input.size());
            for (QuantifiedIngredient ingredient : recipe.input) {
                ingredient.ingredient.m_43923_(buffer);
                buffer.writeInt(ingredient.quantity);
            }
            buffer.m_130055_(recipe.result);
        }
    }
}

