/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionEffectCondition
extends EvoCondition {
    private List<String> potions = Lists.newArrayList();

    public PotionEffectCondition() {
        super("potionEffect");
    }

    public PotionEffectCondition(List<String> potions) {
        this();
        this.potions = potions;
    }

    @Override
    public boolean passes(PixelmonEntity pixelmon) {
        return pixelmon.m_21221_().keySet().stream().map(p -> ForgeRegistries.MOB_EFFECTS.getKey(p).m_135827_().equals("minecraft") ? ForgeRegistries.MOB_EFFECTS.getKey(p).m_135815_() : ForgeRegistries.MOB_EFFECTS.getKey(p).toString()).collect(Collectors.toList()).containsAll(this.potions);
    }

    public List<String> getPotions() {
        return this.potions;
    }

    @Override
    public MutableComponent getDescription() {
        MutableComponent potions = TextHelper.joinStrings(this.potions, TextHelper.AND_DELIMITER);
        return PixelmonCommandUtils.format("pixelmon.evolution.conditions.potions", potions);
    }
}

