/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.MutableComponent;

public class NatureCondition
extends EvoCondition {
    private List<Nature> natures = Lists.newArrayList();

    public NatureCondition() {
        super("nature");
    }

    public NatureCondition(List<Nature> natures) {
        this();
        this.natures = natures;
    }

    @Override
    public boolean passes(PixelmonEntity pixelmon) {
        return this.natures.contains(pixelmon.getPokemon().getBaseNature());
    }

    public List<Nature> getNatures() {
        return this.natures;
    }

    @Override
    public MutableComponent getDescription() {
        return PixelmonCommandUtils.format("pixelmon.evolution.conditions.nature", TextHelper.join(this.natures.stream().map(ITranslatable::getTranslatedName).collect(Collectors.toList()), TextHelper.OR_DELIMITER));
    }
}

