/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class HasPaletteCondition
extends EvoCondition {
    public ArrayList<String> possiblePalettes = new ArrayList();

    public HasPaletteCondition() {
        super("hasPalette");
    }

    public HasPaletteCondition(ArrayList<String> palettes) {
        this();
        for (String palette : palettes) {
            this.possiblePalettes.add(palette.toLowerCase(Locale.ROOT));
        }
    }

    @Override
    public boolean passes(PixelmonEntity pixelmon) {
        for (String palette : this.possiblePalettes) {
            if (!pixelmon.getPalette().is(palette)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MutableComponent getDescription() {
        if (!this.possiblePalettes.isEmpty()) {
            MutableComponent forms = TextHelper.joinStrings(this.possiblePalettes, TextHelper.OR_DELIMITER);
            return PixelmonCommandUtils.format("pixelmon.evolution.conditions.hasPalette", forms);
        }
        return Component.m_237113_((String)"");
    }
}

