/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.blocks.ScrollBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.ScrollTileEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;

public class EvoScrollCondition
extends EvoCondition {
    public ScrollBlock.Type evolutionScroll;
    public int maxRangeSquared = 100;

    public EvoScrollCondition(ScrollBlock.Type evolutionScroll, int maxRangeSquared) {
        super("evolutionScroll");
        this.evolutionScroll = evolutionScroll;
        this.maxRangeSquared = maxRangeSquared;
    }

    @Override
    public boolean passes(PixelmonEntity pixelmon) {
        return WorldHelper.getBlockEntitiesWithinAABB(pixelmon.m_9236_(), pixelmon.m_20191_().m_82400_((double)this.maxRangeSquared)).stream().anyMatch(te -> {
            if (te instanceof ScrollTileEntity) {
                ScrollTileEntity scroll = (ScrollTileEntity)((Object)te);
                return !scroll.isDisplayOnly() && scroll.getScrollType() == this.evolutionScroll && te.m_58899_().m_123331_((Vec3i)pixelmon.m_269323_().m_20183_()) < (double)this.maxRangeSquared;
            }
            return false;
        });
    }

    @Override
    public MutableComponent getDescription() {
        return PixelmonCommandUtils.format("pixelmon.evolution.conditions.scroll", this.maxRangeSquared, this.evolutionScroll.getLocalizedName());
    }
}

