/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.util.helpers.BiomeHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeCondition
extends EvoCondition {
    public ArrayList<String> biomes = new ArrayList();

    public BiomeCondition() {
        super("biome");
    }

    public BiomeCondition(Biome ... biomes) {
        this();
        for (Biome biome : biomes) {
            this.biomes.add(ForgeRegistries.BIOMES.getKey((Object)biome).toString());
        }
    }

    public BiomeCondition(ArrayList<Biome> biomes) {
        this();
        biomes.forEach(b -> this.biomes.add(ForgeRegistries.BIOMES.getKey(b).toString()));
    }

    @Override
    public boolean passes(PixelmonEntity pixelmon) {
        ResourceLocation biome = null;
        Holder biomeHolder = pixelmon.m_269323_() != null ? pixelmon.m_269323_().m_20193_().m_204166_(pixelmon.m_269323_().m_20183_()) : pixelmon.m_20193_().m_204166_(pixelmon.m_20183_());
        if (biomeHolder.m_203543_().isPresent()) {
            biome = ((ResourceKey)biomeHolder.m_203543_().get()).m_135782_();
        }
        if (biome != null) {
            return this.biomes.contains(biome.toString()) || this.biomes.contains(biome.m_135815_());
        }
        return false;
    }

    @Override
    public MutableComponent getDescription() {
        List<Component> biomes = this.biomes.stream().map(it -> {
            ResourceLocation resource = new ResourceLocation(it);
            return BiomeHelper.getLocalizedBiomeName(resource);
        }).collect(Collectors.toList());
        return PixelmonCommandUtils.format("pixelmon.evolution.conditions.biome", TextHelper.join(biomes, TextHelper.OR_DELIMITER));
    }
}

