/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats.evolution;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.EvolveEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.HeldItemCondition;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.InteractEvolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.TickingEvolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.TradeEvolution;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;

public abstract class Evolution {
    public static HashMap<String, Class<? extends Evolution>> evolutionTypes = new HashMap();
    public PokemonSpecification to;
    public ArrayList<EvoCondition> conditions = new ArrayList();
    public ArrayList<String> moves = new ArrayList();
    public String evoType;

    public Evolution(String evoType) {
        this.evoType = evoType;
    }

    public Evolution(String evoType, PokemonSpecification to, EvoCondition ... conditions) {
        this(evoType);
        this.to = to;
        this.conditions.addAll(Arrays.asList(conditions));
    }

    protected boolean canEvolve(PixelmonEntity pokemon) {
        if (pokemon.m_21223_() < 1.0f) {
            return false;
        }
        if (this.conditions != null) {
            for (EvoCondition condition : this.conditions) {
                if (condition.passes(pokemon)) continue;
                return false;
            }
        }
        if (pokemon.getPokemon().canGigantamax()) {
            ChatHandler.sendChat((Entity)pokemon.getPokemon().getOwnerPlayer(), "pixelmon.interaction.gigantamax.noevolution", new Object[0]);
            return false;
        }
        return (!pokemon.getPokemon().isPokemonOptional(PixelmonSpecies.WOOLOO) || !pokemon.getPokemon().getPersistentData().m_128441_("RainbowWooloo")) && (!pokemon.getPokemon().isPokemonOptional(PixelmonSpecies.MAREEP) || !pokemon.getPokemon().getPersistentData().m_128441_("RainbowMareep"));
    }

    public boolean doEvolution(PixelmonEntity pixelmon, String cause) {
        if (!Pixelmon.EVENT_BUS.post((Event)new EvolveEvent.Pre((ServerPlayer)pixelmon.m_269323_(), pixelmon, this, cause))) {
            pixelmon.startEvolution(this, cause);
            return true;
        }
        return false;
    }

    public void finishedEvolving(Pokemon pokemon) {
        if (this.consumesHeldItem()) {
            pokemon.setHeldItem(ItemStack.f_41583_);
            pokemon.markDirty(EnumUpdateType.HeldItem);
        }
    }

    public boolean consumesHeldItem() {
        if (this.conditions == null) {
            return false;
        }
        for (EvoCondition condition : this.conditions) {
            if (!(condition instanceof HeldItemCondition)) continue;
            return true;
        }
        return false;
    }

    public <T extends EvoCondition> List<T> getConditionsOfType(Class<T> clazz) {
        if (this.conditions == null) {
            return Arrays.asList(new EvoCondition[0]);
        }
        ArrayList<EvoCondition> list = new ArrayList<EvoCondition>();
        for (EvoCondition condition : this.conditions) {
            if (!clazz.isInstance(condition)) continue;
            list.add((EvoCondition)clazz.cast(condition));
        }
        return list;
    }

    static {
        evolutionTypes.put("leveling", LevelingEvolution.class);
        evolutionTypes.put("trade", TradeEvolution.class);
        evolutionTypes.put("interact", InteractEvolution.class);
        evolutionTypes.put("ticking", TickingEvolution.class);
    }
}

