/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.dialogue.Dialogue;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;

public class Pokerus {
    public PokerusStrain type;
    public int secondsSinceInfection = 0;
    public boolean announced = false;
    private static List<UUID> pendingRequests = new ArrayList<UUID>();

    public Pokerus(PokerusStrain type) {
        this.type = type;
    }

    public boolean canInfect() {
        return this.secondsSinceInfection != -1 && this.secondsSinceInfection < this.type.getDuration();
    }

    public CompoundTag serializeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128376_("Type", (short)this.type.ordinal());
        if (this.canInfect()) {
            nbt.m_128405_("Spread", this.secondsSinceInfection);
        } else {
            nbt.m_128473_("Spread");
        }
        nbt.m_128379_("Announced", this.announced);
        return nbt;
    }

    public static Pokerus deserializeFromNBT(CompoundTag nbt) {
        if (nbt.m_128456_()) {
            return null;
        }
        Pokerus p = new Pokerus(PokerusStrain.values()[nbt.m_128448_("Type")]);
        p.secondsSinceInfection = nbt.m_128441_("Spread") ? nbt.m_128451_("Spread") : -1;
        p.announced = nbt.m_128471_("Announced");
        return p;
    }

    public static void informPlayer(ServerPlayer player) {
        if (!PixelmonConfigProxy.getGeneral().getPokerus().isInformPlayers()) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        for (Pokemon pokemon : party.getAll()) {
            Pokerus pokerus;
            if (pokemon == null || (pokerus = pokemon.getPokerus()) == null || pokerus.announced) continue;
            if (!pendingRequests.contains(player.m_20148_())) {
                pendingRequests.add(player.m_20148_());
            }
            pokerus.announced = true;
            pokemon.markDirty(EnumUpdateType.Pokerus);
        }
    }

    public static void onHealerClose(ServerPlayer player, String npc) {
        if (PixelmonConfigProxy.getGeneral().getPokerus().isInformPlayers() && pendingRequests.contains(player.m_20148_())) {
            pendingRequests.remove(player.m_20148_());
            ArrayList<Dialogue> dialogues = new ArrayList<Dialogue>();
            dialogues.add(Dialogue.builder().setName(npc).setLocalizedText("pokerus.message.inform1").build());
            dialogues.add(Dialogue.builder().setName(npc).setLocalizedText("pokerus.message.inform2").build());
            dialogues.add(Dialogue.builder().setName(npc).setLocalizedText("pokerus.message.inform3").build());
            Dialogue.setPlayerDialogueData(player, dialogues, true);
        }
    }
}

