/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.EVStore;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class PermanentStats {
    public transient Pokemon pokemon;
    private int hp;
    private int attack;
    private int defense;
    private int specialAttack;
    private int specialDefense;
    private int speed;
    private IVStore ivs = new IVStore();
    private EVStore evs = new EVStore();

    public Pokemon getPokemon() {
        return this.pokemon;
    }

    public int getHP() {
        return this.hp;
    }

    public void setHP(int hp) {
        this.hp = hp;
    }

    public int getAttack() {
        return this.attack;
    }

    public void setAttack(int attack) {
        this.attack = attack;
    }

    public int getDefense() {
        return this.defense;
    }

    public void setDefense(int defense) {
        this.defense = defense;
    }

    public int getSpecialAttack() {
        return this.specialAttack;
    }

    public void setSpecialAttack(int specialAttack) {
        this.specialAttack = specialAttack;
    }

    public int getSpecialDefense() {
        return this.specialDefense;
    }

    public void setSpecialDefense(int specialDefense) {
        this.specialDefense = specialDefense;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public IVStore getIVs() {
        return this.ivs;
    }

    public void setIVs(IVStore ivs) {
        this.ivs = ivs;
    }

    public EVStore getEVs() {
        return this.evs;
    }

    public void setEVs(EVStore evs) {
        this.evs = evs;
    }

    public PermanentStats setLevelStats(Nature nature, Stats stats, int level) {
        this.hp = this.calculateHP(stats, level);
        if (this.pokemon != null) {
            this.pokemon.ifEntityExists(pixelmon -> pixelmon.m_21051_(Attributes.f_22276_).m_22100_((double)this.hp));
        }
        this.attack = this.calculateStat(BattleStatsType.ATTACK, nature, stats, level);
        this.defense = this.calculateStat(BattleStatsType.DEFENSE, nature, stats, level);
        this.specialAttack = this.calculateStat(BattleStatsType.SPECIAL_ATTACK, nature, stats, level);
        this.specialDefense = this.calculateStat(BattleStatsType.SPECIAL_DEFENSE, nature, stats, level);
        this.speed = this.calculateStat(BattleStatsType.SPEED, nature, stats, level);
        return this;
    }

    public void recalculateStats() {
        float percent = this.pokemon.getHealthPercentage();
        this.setLevelStats(this.pokemon.getNature(), this.pokemon.getForm(), this.pokemon.getPokemonLevel());
        this.pokemon.setHealthPercentage(percent);
    }

    public PermanentStats withPokemon(Pokemon pokemon) {
        this.ivs.withPokemon(pokemon);
        this.evs.withPokemon(pokemon);
        this.pokemon = pokemon;
        return this;
    }

    public int calculateStat(BattleStatsType stat, Nature nature, Stats stats, int level) {
        if (stat == BattleStatsType.HP) {
            return this.calculateHP(stats, level);
        }
        int amount = this.ivs.getStat(stat);
        if (this.ivs.isHyperTrained(stat)) {
            amount = 31;
        }
        float val = ((float)amount + 2.0f * (float)stats.getBattleStats().getStat(stat) + (float)this.evs.getStat(stat) / 4.0f) * (float)level;
        val /= 100.0f;
        val += 5.0f;
        val = (float)Math.floor(val);
        if (nature != null) {
            if (stat == nature.getIncreasedStat()) {
                val *= 1.1f;
            } else if (stat == nature.getDecreasedStat()) {
                val *= 0.9f;
            }
        }
        return (int)val;
    }

    protected int calculateHP(Stats stats, int level) {
        if (stats.getBattleStats().getStat(BattleStatsType.HP) == 1) {
            return 1;
        }
        int hp = this.ivs.getStat(BattleStatsType.HP);
        if (this.ivs.isHyperTrained(BattleStatsType.HP)) {
            hp = 31;
        }
        return (int)(((float)hp + 2.0f * (float)stats.getBattleStats().getStat(BattleStatsType.HP) + (float)this.evs.getStat(BattleStatsType.HP) / 4.0f + 100.0f) * (float)level / 100.0f + 10.0f);
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128376_("StatsHP", (short)this.hp);
        nbt.m_128376_("StatsAttack", (short)this.attack);
        nbt.m_128376_("StatsDefense", (short)this.defense);
        nbt.m_128376_("StatsSpecialAttack", (short)this.specialAttack);
        nbt.m_128376_("StatsSpecialDefense", (short)this.specialDefense);
        nbt.m_128376_("StatsSpeed", (short)this.speed);
        this.ivs.writeToNBT(nbt);
        this.evs.writeToNBT(nbt);
    }

    public void readFromNBT(CompoundTag nbt) {
        this.hp = nbt.m_128448_("StatsHP");
        this.attack = nbt.m_128448_("StatsAttack");
        this.defense = nbt.m_128448_("StatsDefense");
        this.specialAttack = nbt.m_128448_("StatsSpecialAttack");
        this.specialDefense = nbt.m_128448_("StatsSpecialDefense");
        this.speed = nbt.m_128448_("StatsSpeed");
        this.ivs.readFromNBT(nbt);
        this.evs.readFromNBT(nbt);
        this.recalculateStats();
    }

    public int get(BattleStatsType stat) {
        switch (stat) {
            case HP: {
                return this.hp;
            }
            case ATTACK: {
                return this.attack;
            }
            case DEFENSE: {
                return this.defense;
            }
            case SPECIAL_ATTACK: {
                return this.specialAttack;
            }
            case SPECIAL_DEFENSE: {
                return this.specialDefense;
            }
            case SPEED: {
                return this.speed;
            }
        }
        return -1;
    }

    public void set(BattleStatsType stat, int value) {
        switch (stat) {
            case HP: {
                this.hp = value;
                break;
            }
            case ATTACK: {
                this.attack = value;
                break;
            }
            case DEFENSE: {
                this.defense = value;
                break;
            }
            case SPECIAL_ATTACK: {
                this.specialAttack = value;
                break;
            }
            case SPECIAL_DEFENSE: {
                this.specialDefense = value;
                break;
            }
            case SPEED: {
                this.speed = value;
                break;
            }
        }
    }

    public int[] toArray() {
        return new int[]{this.hp, this.attack, this.defense, this.specialAttack, this.specialDefense, this.speed};
    }
}

