/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.enums.TriBoolean;
import com.pixelmonmod.pixelmon.api.events.pokemon.MovesetEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.eventbus.api.Event;

public class Moveset
extends AbstractList<Attack>
implements RandomAccess,
Cloneable {
    private static final EnumUpdateType[] MOVESET = new EnumUpdateType[]{EnumUpdateType.Moveset};
    public Pokemon pokemon = null;
    public Attack[] attacks = new Attack[4];
    protected Ability ability;
    protected String tempAbility;
    private final List<ImmutableAttack> reminderMoves = Lists.newArrayList();

    public Moveset() {
    }

    public Moveset(Attack[] attacks, Ability ability) {
        this.attacks = attacks;
        this.ability = ability;
    }

    public Moveset(Attack attack, Ability ability) {
        this.attacks[0] = attack;
        this.ability = ability;
    }

    public Moveset withPokemon(Pokemon pokemon) {
        this.pokemon = pokemon;
        return this;
    }

    public void setTempAbility(String tempAbility) {
        this.tempAbility = tempAbility;
    }

    public String getTempAbility() {
        return this.tempAbility;
    }

    @Override
    public Attack get(int index) {
        if (index < 0 || index > 3) {
            return null;
        }
        return this.attacks[index];
    }

    @Override
    public boolean add(Attack a) {
        if (this.size() >= 4) {
            return false;
        }
        this.set(this.size(), a);
        return true;
    }

    @Override
    public Attack set(int index, Attack a) {
        Attack previousAttack = this.attacks[index];
        this.attacks[index] = a;
        this.tryNotifyPokemon();
        if (this.pokemon == null || this.pokemon.getOwnerPlayer() == null) {
            return previousAttack;
        }
        if (previousAttack != null) {
            Pixelmon.EVENT_BUS.post((Event)new MovesetEvent.ForgotMoveEvent(this.pokemon, this, previousAttack));
        }
        if (a != null) {
            Pixelmon.EVENT_BUS.post((Event)new MovesetEvent.LearntMoveEvent(this.pokemon, this, previousAttack, a));
        }
        return previousAttack;
    }

    public void tryNotifyPokemon() {
        if (this.pokemon != null) {
            this.pokemon.markDirty(MOVESET);
        }
    }

    public void swap(int index, int index2) {
        Attack a = this.attacks[index];
        this.attacks[index] = this.attacks[index2];
        this.attacks[index2] = a;
        this.tryNotifyPokemon();
    }

    @Override
    public Attack remove(int index) {
        Attack a = this.get(index);
        int oldSize = this.size();
        for (int i = index + 1; i < this.size(); ++i) {
            this.set(i - 1, this.get(i));
        }
        this.set(oldSize - 1, null);
        return a;
    }

    @Override
    public boolean removeIf(Predicate<? super Attack> predicate) {
        for (int i = 0; i < this.attacks.length; ++i) {
            if (!predicate.test(this.attacks[i])) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Attack)) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.attacks[i] != o) continue;
            this.set(i, null);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.attacks[i] == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (this.isEmpty()) {
            return false;
        }
        if (o instanceof Attack) {
            for (int i = 0; i < this.size(); ++i) {
                if (!this.attacks[i].equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.attacks = new Attack[4];
    }

    public void writeToNBT(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.size(); ++i) {
            Attack attack = this.get(i);
            if (attack == null || attack.getActualMove() == null) continue;
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("MoveID", attack.getActualMove().getAttackName());
            compound.m_128344_("MovePP", (byte)attack.pp);
            if (attack.ppLevel != 0) {
                compound.m_128344_("MovePPLevel", (byte)attack.ppLevel);
            }
            list.add((Object)compound);
        }
        nbt.m_128365_("Moveset", (Tag)list);
        if (this.tempAbility != null) {
            nbt.m_128359_("TempAbiliy", this.tempAbility);
        }
        if (this.ability != null) {
            nbt.m_128359_("Ability", this.ability.getName());
        }
        ListTag relearn = new ListTag();
        this.reminderMoves.forEach(ab -> relearn.add((Object)StringTag.m_129297_((String)ab.getAttackName())));
        nbt.m_128365_("RelrnMoves", (Tag)relearn);
    }

    public void readFromNBT(CompoundTag nbt) {
        this.clear();
        ListTag list = nbt.m_128437_("Moveset", 10);
        for (Tag base : list) {
            CompoundTag compound = (CompoundTag)base;
            String moveID = compound.m_128461_("MoveID");
            Optional<ImmutableAttack> attack = AttackRegistry.getAttackBase(moveID);
            if (!attack.isPresent()) continue;
            short movePP = compound.m_128448_("MovePP");
            short movePPLevel = compound.m_128448_("MovePPLevel");
            Attack mutableAttack = attack.get().ofMutable();
            mutableAttack.pp = movePP;
            mutableAttack.ppLevel = movePPLevel;
            this.add(mutableAttack);
        }
        if (nbt.m_128441_("TempAbility")) {
            this.tempAbility = nbt.m_128461_("TempAbility");
        }
        if (nbt.m_128441_("Ability")) {
            this.ability = AbilityRegistry.getAbility(nbt.m_128461_("Ability")).orElse(ComingSoon.noAbility);
        }
        this.reminderMoves.clear();
        if (nbt.m_128441_("RelrnMoves")) {
            list = nbt.m_128437_("RelrnMoves", 8);
            for (Tag base : list) {
                AttackRegistry.getAttackBase(base.m_7916_()).ifPresent(this.reminderMoves::add);
            }
        }
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.clear();
        int numberOfMoves = buf.readByte();
        for (int j = 0; j < numberOfMoves; ++j) {
            Attack attack = new Attack(buf.m_130277_());
            attack.pp = buf.readByte();
            attack.ppLevel = buf.readByte();
            attack.overridePPMax(buf.readByte());
            attack.setDisabled(buf.readBoolean(), null);
            this.attacks[j] = attack;
        }
        if (buf.readBoolean()) {
            this.tempAbility = buf.m_130277_();
        }
        if (buf.readBoolean()) {
            this.ability = AbilityRegistry.getAbility(buf.m_130277_()).orElse(ComingSoon.noAbility);
        }
        int numberOfReminderMoves = buf.readByte();
        for (int j = 0; j < numberOfReminderMoves; ++j) {
            Attack attack = new Attack(buf.m_130277_());
            this.reminderMoves.add(attack.getActualMove());
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeByte(this.size());
        for (Attack a : this.attacks) {
            if (a == null) continue;
            buf.m_130070_(a.getActualMove().getAttackName());
            buf.writeByte(a.pp);
            buf.writeByte(a.ppLevel);
            buf.writeByte(a.getOverriddenPPMax() == null ? -1 : a.getOverriddenPPMax());
            buf.writeBoolean(a.getDisabled());
        }
        buf.writeBoolean(this.tempAbility != null);
        if (this.tempAbility != null) {
            buf.m_130070_(this.tempAbility);
        }
        buf.writeBoolean(this.ability != null);
        if (this.ability != null) {
            buf.m_130070_(this.ability.getName());
        }
        buf.writeByte(this.reminderMoves.size());
        for (ImmutableAttack a : this.reminderMoves) {
            if (a == null) continue;
            buf.m_130070_(a.getAttackName());
        }
    }

    public void addCurrentMovesToReminder() {
        for (Attack attack : this.attacks) {
            if (attack == null || this.reminderMoves.contains(attack.getActualMove())) continue;
            this.reminderMoves.add(attack.getActualMove());
        }
    }

    public boolean hasAttack(Attack a) {
        for (Attack attack : this.attacks) {
            if (attack == null || !Objects.equals(attack.getActualMove().getAttackName(), a.getActualMove().getAttackName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttack(ImmutableAttack ... moves) {
        for (Attack attack : this.attacks) {
            for (ImmutableAttack base : moves) {
                if (attack == null || !attack.getActualMove().equals(base)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public final boolean hasAttack(Optional<ImmutableAttack> ... moves) {
        for (Attack attack : this.attacks) {
            for (Optional<ImmutableAttack> base : moves) {
                if (!base.isPresent() || attack == null || !attack.getActualMove().equals(base.get())) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public final boolean hasAttack(RegistryValue<ImmutableAttack> ... moves) {
        for (Attack attack : this.attacks) {
            for (RegistryValue<ImmutableAttack> base : moves) {
                if (!base.isInitialized() || attack == null || !attack.getActualMove().equals(base.get())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAttackCategory(AttackCategory attackCategory) {
        for (Attack attack : this.attacks) {
            if (attack == null || attack.getActualMove().getAttackCategory() != attackCategory) continue;
            return true;
        }
        return false;
    }

    public boolean hasOffensiveAttackType(Element ... types) {
        for (Attack attack : this.attacks) {
            for (Element type : types) {
                if (attack == null || attack.getActualMove().getAttackCategory() == AttackCategory.STATUS || attack.getType() != type) continue;
                return true;
            }
        }
        return false;
    }

    public boolean removeAttack(ImmutableAttack removedAttack) {
        if (removedAttack == null) {
            return false;
        }
        boolean removed = false;
        for (int i = 0; i < this.attacks.length; ++i) {
            Attack attack = this.attacks[i];
            if (attack == null || !attack.isAttack(removedAttack)) continue;
            this.remove(i);
            removed = true;
        }
        return removed;
    }

    @SafeVarargs
    public final void removeAttack(Optional<ImmutableAttack> ... removedAttack) {
        for (Optional<ImmutableAttack> immutableAttack : removedAttack) {
            this.removeAttack((ImmutableAttack)immutableAttack.orElse(null));
        }
    }

    @SafeVarargs
    public final void removeAttack(RegistryValue<ImmutableAttack> ... removedAttack) {
        for (RegistryValue<ImmutableAttack> immutableAttack : removedAttack) {
            this.removeAttack(immutableAttack.orElse(null));
        }
    }

    public void replaceWith(List<String> attackIds) {
        this.clear();
        for (String attackIndex : attackIds) {
            this.add(new Attack(attackIndex));
        }
    }

    public boolean hasFullPP() {
        for (int i = 0; i < this.size(); ++i) {
            Attack a = this.attacks[i];
            if (a == null || a.pp >= a.getMaxPP()) continue;
            return false;
        }
        return true;
    }

    public Moveset copy() {
        Attack[] attacks = new Attack[this.attacks.length];
        for (int i = 0; i < this.attacks.length; ++i) {
            if (this.attacks[i] == null) continue;
            attacks[i] = this.attacks[i].deepCopy();
        }
        return new Moveset(attacks, this.ability);
    }

    public boolean replaceMove(RegistryValue<ImmutableAttack> oldMove, Attack newMove) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.attacks[i] == null || !this.attacks[i].isAttack(oldMove)) continue;
            this.attacks[i] = newMove;
            this.tryNotifyPokemon();
            return true;
        }
        return false;
    }

    public void healAllPP() {
        for (int i = 0; i < this.size(); ++i) {
            Attack attack = this.attacks[i];
            if (attack == null) continue;
            attack.pp = attack.getMaxPP();
        }
        this.tryNotifyPokemon();
    }

    public List<ImmutableAttack> getReminderMoves() {
        return this.reminderMoves;
    }

    public static Moveset loadMoveset(PokemonLink pokemon) {
        return pokemon.getBaseStats().getMoves().loadMoveset(pokemon.getPokemonLevel());
    }

    public Ability getAbility() {
        return this.ability;
    }

    public void setAbility(Ability ability) {
        this.ability = ability;
        this.tryNotifyPokemon();
    }

    public boolean isHiddenAbility(Pokemon pokemon) {
        return pokemon.getForm().getAbilities().isHiddenAbility(this.ability);
    }

    public TriBoolean isHiddenAbility() {
        if (this.pokemon != null) {
            return TriBoolean.valueOf(this.isHiddenAbility(this.pokemon));
        }
        return TriBoolean.NULL;
    }

    public boolean addImmutable(Collection<ImmutableAttack> attacks) {
        ArrayList mutableAttacks = Lists.newArrayList();
        for (ImmutableAttack attack : attacks) {
            if (attack == null) continue;
            mutableAttacks.add(attack.ofMutable());
        }
        return this.addAll(mutableAttacks);
    }

    public boolean addImmutable(ImmutableAttack ... attacks) {
        ArrayList mutableAttacks = Lists.newArrayList();
        for (ImmutableAttack attack : attacks) {
            mutableAttacks.add(new Attack(attack));
        }
        return this.addAll(mutableAttacks);
    }

    public List<ImmutableAttack> asImmutable() {
        ArrayList attacks = Lists.newArrayList();
        for (Attack attack : this.attacks) {
            if (attack == null) continue;
            attacks.add(attack.getActualMove());
        }
        return attacks;
    }

    public boolean hasAbility() {
        return this.ability != null;
    }

    public void removeIllegalMoves() {
        if (this.pokemon == null) {
            return;
        }
        List<ImmutableAttack> moves = this.pokemon.getForm().getMoves().getAllMoves();
        moves.addAll(this.pokemon.getForm().getMoves().getAllLevelUpMoves());
        for (int i = moves.size() - 1; i >= 0; --i) {
            if (this.get(i) == null || moves.contains(this.get(i).getActualMove())) continue;
            this.remove(i);
        }
    }

    @Override
    public String toString() {
        return "Moveset{pokemon=" + this.pokemon + ", attacks=" + Arrays.toString(this.attacks) + ", ability=" + this.ability + ", reminderMoves=" + this.reminderMoves + "}";
    }
}

