/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;

public class BonusStats {
    private int accuracy;
    private int evasion;
    private int attack;
    private int defense;
    private int specialAttack;
    private int specialDefense;
    private int speed;
    private boolean persistentAfterCapture = false;
    private boolean preventsCapture = false;

    public BonusStats() {
        this.accuracy = 0;
        this.evasion = 0;
        this.attack = 0;
        this.defense = 0;
        this.specialAttack = 0;
        this.specialDefense = 0;
        this.speed = 0;
    }

    public BonusStats(int accuracy, int evasion, int attack, int defense, int specialAttack, int specialDefense, int speed) {
        this.accuracy = accuracy;
        this.evasion = evasion;
        this.attack = attack;
        this.defense = defense;
        this.specialAttack = specialAttack;
        this.specialDefense = specialDefense;
        this.speed = speed;
    }

    public BonusStats(ByteBuf buf) {
        this.readFromByteBuffer(buf);
    }

    public BonusStats(Species species) {
        this();
        if (species.is(PixelmonSpecies.NIHILEGO)) {
            this.specialDefense = 2;
        } else if (species.is(PixelmonSpecies.KARTANA, PixelmonSpecies.GUZZLORD, PixelmonSpecies.BUZZWOLE)) {
            this.attack = 2;
        } else if (species.is(PixelmonSpecies.PHEROMOSA, PixelmonSpecies.POIPOLE)) {
            this.speed = 2;
        } else if (species.is(PixelmonSpecies.CELESTEELA, PixelmonSpecies.XURKITREE, PixelmonSpecies.BLACEPHALON, PixelmonSpecies.NAGANADEL)) {
            this.specialAttack = 2;
        } else if (species.is(PixelmonSpecies.STAKATAKA)) {
            this.defense = 2;
        }
    }

    public boolean isPersistentAfterCapture() {
        return this.persistentAfterCapture;
    }

    public void setPersistentAfterCapture(boolean persistentAfterCapture) {
        this.persistentAfterCapture = persistentAfterCapture;
    }

    public boolean modifyPokemon(PixelmonWrapper pw) {
        BattleStats bs = pw.getBattleStats();
        if (bs != null) {
            bs.increaseStat(this.accuracy, BattleStatsType.ACCURACY, pw, false, false);
            bs.increaseStat(this.evasion, BattleStatsType.EVASION, pw, false, false);
            bs.increaseStat(this.attack, BattleStatsType.ATTACK, pw, false, false);
            bs.increaseStat(this.defense, BattleStatsType.DEFENSE, pw, false, false);
            bs.increaseStat(this.specialAttack, BattleStatsType.SPECIAL_ATTACK, pw, false, false);
            bs.increaseStat(this.specialDefense, BattleStatsType.SPECIAL_DEFENSE, pw, false, false);
            bs.increaseStat(this.speed, BattleStatsType.SPEED, pw, false, false);
        }
        return this.accuracy > 0 || this.evasion > 0 || this.attack > 0 || this.defense > 0 || this.specialAttack > 0 || this.specialDefense > 0 || this.speed > 0;
    }

    public BattleStatsType getStatModified() {
        BattleStatsType stat = null;
        int modified = 0;
        if (this.accuracy > 0) {
            stat = BattleStatsType.ACCURACY;
            ++modified;
        }
        if (this.evasion > 0) {
            stat = BattleStatsType.EVASION;
            ++modified;
        }
        if (this.attack > 0) {
            stat = BattleStatsType.ATTACK;
            ++modified;
        }
        if (this.defense > 0) {
            stat = BattleStatsType.DEFENSE;
            ++modified;
        }
        if (this.specialAttack > 0) {
            stat = BattleStatsType.SPECIAL_ATTACK;
            ++modified;
        }
        if (this.specialDefense > 0) {
            stat = BattleStatsType.SPECIAL_DEFENSE;
            ++modified;
        }
        if (this.speed > 0) {
            stat = BattleStatsType.SPEED;
            ++modified;
        }
        return modified == 1 ? stat : null;
    }

    public int getStatModificationRank() {
        int rank = 0;
        if (this.accuracy > rank) {
            rank = this.accuracy;
        }
        if (this.evasion > rank) {
            rank = this.evasion;
        }
        if (this.attack > rank) {
            rank = this.attack;
        }
        if (this.defense > rank) {
            rank = this.defense;
        }
        if (this.specialAttack > rank) {
            rank = this.specialAttack;
        }
        if (this.specialDefense > rank) {
            rank = this.specialDefense;
        }
        if (this.speed > rank) {
            rank = this.speed;
        }
        return rank;
    }

    public void writeToByteBuffer(ByteBuf buf) {
        buf.writeInt(this.accuracy);
        buf.writeInt(this.evasion);
        buf.writeInt(this.attack);
        buf.writeInt(this.defense);
        buf.writeInt(this.specialAttack);
        buf.writeInt(this.specialDefense);
        buf.writeInt(this.speed);
        buf.writeBoolean(this.persistentAfterCapture);
    }

    public void readFromByteBuffer(ByteBuf buf) {
        this.accuracy = buf.readInt();
        this.evasion = buf.readInt();
        this.attack = buf.readInt();
        this.defense = buf.readInt();
        this.specialAttack = buf.readInt();
        this.specialDefense = buf.readInt();
        this.speed = buf.readInt();
        this.persistentAfterCapture = buf.readBoolean();
    }

    public void writeToNBT(CompoundTag tag) {
        if (this.accuracy != 0) {
            tag.m_128405_("BonusAccuracy", this.accuracy);
        }
        if (this.evasion != 0) {
            tag.m_128405_("BonusEvasion", this.evasion);
        }
        if (this.attack != 0) {
            tag.m_128405_("BonusAttack", this.attack);
        }
        if (this.defense != 0) {
            tag.m_128405_("BonusDefense", this.defense);
        }
        if (this.specialAttack != 0) {
            tag.m_128405_("BonusSpAttack", this.specialAttack);
        }
        if (this.specialDefense != 0) {
            tag.m_128405_("BonusSpDefense", this.specialDefense);
        }
        if (this.speed != 0) {
            tag.m_128405_("BonusSpeed", this.speed);
        }
        if (this.persistentAfterCapture) {
            tag.m_128379_("BonusPersistent", this.persistentAfterCapture);
        }
    }

    public void readFromNBT(Pokemon pokemon, CompoundTag tag) {
        this.accuracy = tag.m_128451_("BonusAccuracy");
        this.evasion = tag.m_128451_("BonusEvasion");
        this.attack = tag.m_128451_("BonusAttack");
        this.defense = tag.m_128451_("BonusDefense");
        this.specialAttack = tag.m_128451_("BonusSpAttack");
        this.specialDefense = tag.m_128451_("BonusSpDefense");
        this.speed = tag.m_128451_("BonusSpeed");
        this.persistentAfterCapture = tag.m_128471_("BonusPersistent");
        if (tag.m_128471_("BonusCapture")) {
            pokemon.addFlag("uncatchable");
        }
    }
}

