/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.battles.BattleStatStageModifyBattleEvent;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Competitive;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Contrary;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Defiant;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Simple;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.StatChangeAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import java.util.ArrayList;
import java.util.StringJoiner;
import net.minecraftforge.eventbus.api.Event;

public class BattleStats {
    private PixelmonWrapper pixelmon;
    public int accuracy;
    public int evasion;
    public int attackModifier;
    public int defenseModifier;
    public int specialAttackModifier;
    public int specialDefenseModifier;
    public int speedModifier;
    public int attackStat;
    public int defenseStat;
    public int specialAttackStat;
    public int specialDefenseStat;
    public int speedStat;
    private int critStage;
    private boolean focused;
    private int[] stages = new int[7];
    private boolean loweredThisTurn = false;
    private boolean raisedThisTurn = false;

    public BattleStats(PixelmonWrapper pixelmon) {
        this.pixelmon = pixelmon;
        this.clearBattleStats(true);
    }

    public BattleStats(BattleStats original) {
        this.copyStats(original);
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public int getEvasion() {
        return this.evasion;
    }

    public double getAttackModifier() {
        return this.attackModifier;
    }

    public int getDefenseModifier() {
        return this.defenseModifier;
    }

    public double getSpecialAttackModifier() {
        return this.specialAttackModifier;
    }

    public int getSpecialDefenseModifier() {
        return this.specialDefenseModifier;
    }

    public double getSpeedModifier() {
        return this.speedModifier;
    }

    public int getAccuracyStage() {
        return this.stages[BattleStatsType.ACCURACY.getStatIndex()];
    }

    public int getEvasionStage() {
        return this.stages[BattleStatsType.EVASION.getStatIndex()];
    }

    public int[] getStages() {
        return this.stages;
    }

    public boolean modifyStat(int amount, BattleStatsType stat) {
        return this.modifyStat(new int[]{amount}, new BattleStatsType[]{stat}, this.pixelmon, false);
    }

    public boolean modifyStat(int amount, BattleStatsType ... stats) {
        int[] amounts = new int[stats.length];
        for (int i = 0; i < stats.length; ++i) {
            amounts[i] = amount;
        }
        return this.modifyStat(amounts, stats, this.pixelmon, false);
    }

    public boolean modifyStat(int[] amounts, BattleStatsType[] stats) {
        return this.modifyStat(amounts, stats, this.pixelmon, false);
    }

    public boolean modifyStat(int amount, BattleStatsType[] stats, PixelmonWrapper user) {
        int[] amounts = new int[stats.length];
        for (int i = 0; i < stats.length; ++i) {
            amounts[i] = amount;
        }
        return this.modifyStat(amounts, stats, user, false);
    }

    public boolean modifyStat(int amount, BattleStatsType stat, PixelmonWrapper user, boolean isAttack, boolean messages) {
        return this.modifyStat(new int[]{amount}, new BattleStatsType[]{stat}, user, isAttack, messages);
    }

    public boolean modifyStat(int amount, BattleStatsType stat, PixelmonWrapper user, boolean isAttack) {
        return this.modifyStat(new int[]{amount}, new BattleStatsType[]{stat}, user, isAttack, true);
    }

    public boolean modifyStat(int[] amounts, BattleStatsType[] stats, PixelmonWrapper user, boolean isAttack) {
        return this.modifyStat(amounts, stats, user, isAttack, true);
    }

    public boolean modifyStat(int[] amounts, BattleStatsType[] stats, PixelmonWrapper user, boolean isAttack, boolean messages) {
        if (this.pixelmon.isFainted()) {
            return false;
        }
        boolean anySucceeded = false;
        for (int i = 0; i < stats.length; ++i) {
            int amount = amounts[i];
            BattleStatsType stat = stats[i];
            Ability thisAbility = this.pixelmon.getBattleAbility(user);
            if (thisAbility instanceof Contrary) {
                if (!user.usingZPower) {
                    amount *= -1;
                }
            } else if (thisAbility instanceof Simple && !user.usingZPower) {
                amount *= 2;
            }
            boolean succeeded = false;
            if (amount > 0) {
                succeeded = this.increaseStat(amount, stat, user, isAttack, messages);
            } else if (amount < 0) {
                succeeded = this.decreaseStat(amount * -1, stat, user, isAttack, messages);
            }
            if (!succeeded) continue;
            anySucceeded = true;
        }
        if (!isAttack && anySucceeded) {
            this.notifyActivePokemonOfStatChange();
        }
        return anySucceeded;
    }

    public void notifyActivePokemonOfStatChange() {
        ArrayList<PixelmonWrapper> active = this.pixelmon.bc.getActiveUnfaintedPokemon();
        active.forEach(pw -> pw.getBattleAbility().applyEffectOnStatModified((PixelmonWrapper)pw, this.pixelmon));
        active.forEach(pw -> pw.getUsableHeldItem().onStatModified((PixelmonWrapper)pw, this.pixelmon));
    }

    public boolean increaseCritStage(int value, boolean isFocusEnergy) {
        if (this.focused && isFocusEnergy) {
            return false;
        }
        if (!this.pixelmon.bc.simulateMode) {
            this.critStage += value;
            if (isFocusEnergy) {
                this.focused = true;
            }
        }
        return true;
    }

    public boolean decreaseCritStage(int value) {
        if (!this.pixelmon.bc.simulateMode) {
            this.critStage -= value;
            return true;
        }
        return false;
    }

    public int getCritStage() {
        return this.critStage;
    }

    public int GetAccOrEva(double stage) {
        if (stage > 6.0) {
            stage = 6.0;
        } else if (stage < -6.0) {
            stage = -6.0;
        }
        if (stage < 1.0) {
            return (int)Math.round(3.0 / (Math.abs(stage) + 3.0) * 100.0);
        }
        return (int)Math.round((Math.abs(stage) + 3.0) / 3.0 * 100.0);
    }

    private int GetStat(double stage) {
        if (stage > 6.0) {
            stage = 6.0;
        } else if (stage < -6.0) {
            stage = -6.0;
        }
        if (stage < 1.0) {
            return (int)Math.round(2.0 / (Math.abs(stage) + 2.0) * 100.0);
        }
        return (int)Math.round((Math.abs(stage) + 2.0) / 2.0 * 100.0);
    }

    public boolean increaseStat(int amount, BattleStatsType stat, PixelmonWrapper user, boolean isAttack) {
        return this.increaseStat(amount, stat, user, isAttack, true);
    }

    public boolean increaseStat(int amount, BattleStatsType stat, PixelmonWrapper user, boolean isAttack, boolean sendMessage) {
        int increaseAmount;
        if (amount < 0) {
            return this.decreaseStat(Math.abs(amount), stat, user, isAttack);
        }
        int stageIndex = stat.getStatIndex();
        if (stageIndex == -1) {
            return false;
        }
        int currentStage = this.stages[stageIndex];
        if (currentStage == 6) {
            if (!isAttack) {
                this.getStatFailureMessage(stat, true);
            }
            return false;
        }
        if ((currentStage += Math.abs(amount)) > 6) {
            amount -= currentStage - 6;
            currentStage = 6;
        }
        if (!this.pixelmon.bc.simulateMode) {
            BattleStatStageModifyBattleEvent.Pre pre = new BattleStatStageModifyBattleEvent.Pre(this.pixelmon.bc, user, this.pixelmon, stat, this.stages[stageIndex], currentStage);
            if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                return false;
            }
            this.stages[stageIndex] = pre.getNewValue();
            Pixelmon.EVENT_BUS.post((Event)pre.post());
        }
        if (stat != BattleStatsType.ACCURACY && stat != BattleStatsType.EVASION) {
            int newValue = this.GetStat(currentStage);
            this.changeStat(stat, newValue);
        }
        if (sendMessage) {
            String statMessage = "pixelmon.effect." + this.getStatStringLang(stat);
            statMessage = statMessage + "increased";
            if (amount == 2) {
                statMessage = statMessage + "2";
            } else if (amount >= 3) {
                statMessage = statMessage + "3";
            }
            this.pixelmon.bc.sendToAll(statMessage, this.pixelmon.getNickname());
        }
        if ((increaseAmount = amount) > 0) {
            ArrayList<PixelmonWrapper> active = this.pixelmon.bc.getActiveUnfaintedPokemon();
            active.forEach(pw -> pw.getBattleAbility().onStatIncrease((PixelmonWrapper)pw, this.pixelmon, increaseAmount, stat));
            active.forEach(pw -> pw.getUsableHeldItem().onStatIncrease((PixelmonWrapper)pw, this.pixelmon, increaseAmount, stat));
            this.setRaisedThisTurn(true);
        }
        return true;
    }

    public boolean decreaseStat(int amount, BattleStatsType stat, PixelmonWrapper user, boolean isAttack) {
        return this.decreaseStat(amount, stat, user, isAttack, true);
    }

    public boolean decreaseStat(int amount, BattleStatsType stat, PixelmonWrapper user, boolean isAttack, boolean messages) {
        int decreaseAmount;
        int stageIndex = stat.getStatIndex();
        if (stageIndex == -1) {
            return false;
        }
        StatsEffect effect = new StatsEffect(stat, amount * -1, user == this.pixelmon);
        if (!this.pixelmon.getBattleAbility(user).allowsStatChange(this.pixelmon, user, effect)) {
            return false;
        }
        for (StatusBase status : this.pixelmon.getStatuses()) {
            if (status.allowsStatChange(this.pixelmon, user, effect)) continue;
            return false;
        }
        int currentStage = this.stages[stageIndex];
        if (currentStage == -6) {
            if (!isAttack) {
                this.getStatFailureMessage(stat, false);
            }
            return false;
        }
        if ((currentStage -= Math.abs(amount)) < -6) {
            amount -= -6 - currentStage;
            currentStage = -6;
        }
        if (!this.pixelmon.bc.simulateMode) {
            BattleStatStageModifyBattleEvent.Pre pre = new BattleStatStageModifyBattleEvent.Pre(this.pixelmon.bc, user, this.pixelmon, stat, this.stages[stageIndex], currentStage);
            if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                return false;
            }
            this.stages[stageIndex] = pre.getNewValue();
            Pixelmon.EVENT_BUS.post((Event)pre.post());
        }
        if (stat != BattleStatsType.ACCURACY && stat != BattleStatsType.EVASION) {
            int newValue = this.GetStat(currentStage);
            this.changeStat(stat, newValue);
        }
        if (messages) {
            String statMessage = "pixelmon.effect." + this.getStatStringLang(stat);
            statMessage = statMessage + "decreased";
            if (amount == 2) {
                statMessage = statMessage + "2";
            } else if (amount >= 3) {
                statMessage = statMessage + "3";
            }
            this.pixelmon.bc.sendToAll(statMessage, this.pixelmon.getNickname());
        }
        if (user != this.pixelmon && this.pixelmon.bc.sendMessages) {
            Ability thisAbility = this.pixelmon.getBattleAbility();
            if (thisAbility instanceof Defiant) {
                thisAbility.sendActivatedMessage(this.pixelmon);
                this.modifyStat(2, BattleStatsType.ATTACK);
            } else if (thisAbility instanceof Competitive) {
                thisAbility.sendActivatedMessage(this.pixelmon);
                this.modifyStat(2, BattleStatsType.SPECIAL_ATTACK);
            }
        }
        if ((decreaseAmount = amount) > 0) {
            ArrayList<PixelmonWrapper> active = this.pixelmon.bc.getActiveUnfaintedPokemon();
            active.forEach(pw -> pw.getBattleAbility().onStatDecrease((PixelmonWrapper)pw, this.pixelmon, decreaseAmount, stat));
            active.forEach(pw -> pw.getUsableHeldItem().onStatDecrease((PixelmonWrapper)pw, this.pixelmon, decreaseAmount, stat));
            this.loweredThisTurn = true;
        }
        return true;
    }

    public void changeStat(BattleStatsType stat, int value) {
        int[] stats = (int[])this.getBattleStats().clone();
        if (!this.pixelmon.bc.simulateMode) {
            switch (stat) {
                case ACCURACY: {
                    this.accuracy = value;
                    break;
                }
                case EVASION: {
                    this.evasion = value;
                    break;
                }
                case ATTACK: {
                    this.attackModifier = value;
                    break;
                }
                case DEFENSE: {
                    this.defenseModifier = value;
                    break;
                }
                case SPECIAL_ATTACK: {
                    this.specialAttackModifier = value;
                    break;
                }
                case SPECIAL_DEFENSE: {
                    this.specialDefenseModifier = value;
                    break;
                }
                case SPEED: {
                    this.speedModifier = value;
                    break;
                }
            }
        }
        this.pixelmon.bc.battleLog.logEvent(new StatChangeAction(this.pixelmon.bc.battleTurn, this.pixelmon, stats, this.getBaseBattleStats()));
    }

    public int getStatFromEnum(BattleStatsType stat) {
        switch (stat) {
            case ACCURACY: {
                return this.accuracy;
            }
            case EVASION: {
                return this.evasion;
            }
            case ATTACK: {
                return this.attackStat;
            }
            case DEFENSE: {
                return this.defenseStat;
            }
            case SPECIAL_ATTACK: {
                return this.specialAttackStat;
            }
            case SPECIAL_DEFENSE: {
                return this.specialDefenseStat;
            }
            case SPEED: {
                return this.speedStat;
            }
        }
        return 0;
    }

    public int getStatModFromEnum(BattleStatsType stat) {
        switch (stat) {
            case ACCURACY: {
                return this.accuracy;
            }
            case EVASION: {
                return this.evasion;
            }
            case ATTACK: {
                return this.attackModifier;
            }
            case DEFENSE: {
                return this.defenseModifier;
            }
            case SPECIAL_ATTACK: {
                return this.specialAttackModifier;
            }
            case SPECIAL_DEFENSE: {
                return this.specialDefenseModifier;
            }
            case SPEED: {
                return this.speedModifier;
            }
        }
        return 0;
    }

    public BattleStatsType getStageEnum(int index) {
        switch (index) {
            case 0: {
                return BattleStatsType.ACCURACY;
            }
            case 1: {
                return BattleStatsType.EVASION;
            }
            case 2: {
                return BattleStatsType.ATTACK;
            }
            case 3: {
                return BattleStatsType.DEFENSE;
            }
            case 4: {
                return BattleStatsType.SPECIAL_ATTACK;
            }
            case 5: {
                return BattleStatsType.SPECIAL_DEFENSE;
            }
            case 6: {
                return BattleStatsType.SPEED;
            }
        }
        return BattleStatsType.NONE;
    }

    public int getStage(BattleStatsType stat) {
        return this.stages[stat.getStatIndex()];
    }

    public void setStage(BattleStatsType stat, int value) {
        if (!this.pixelmon.bc.simulateMode) {
            BattleStatStageModifyBattleEvent.Pre pre = new BattleStatStageModifyBattleEvent.Pre(this.pixelmon.bc, this.pixelmon, this.pixelmon, stat, this.stages[stat.getStatIndex()], value);
            if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                return;
            }
            this.stages[stat.getStatIndex()] = pre.getNewValue();
            Pixelmon.EVENT_BUS.post((Event)pre.post());
        }
    }

    public void swapStats(BattleStats otherPokemon, BattleStatsType ... stats) {
        if (!this.pixelmon.bc.simulateMode) {
            for (BattleStatsType stat : stats) {
                int index = stat.getStatIndex();
                int tempStat = this.getStatModFromEnum(stat);
                int tempStage = this.stages[index];
                BattleStatStageModifyBattleEvent.Pre pre = new BattleStatStageModifyBattleEvent.Pre(this.pixelmon.bc, this.pixelmon, this.pixelmon, stat, this.stages[index], otherPokemon.getStage(stat));
                if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                    return;
                }
                this.stages[index] = pre.getNewValue();
                Pixelmon.EVENT_BUS.post((Event)pre.post());
                this.changeStat(stat, otherPokemon.getStatModFromEnum(stat));
                otherPokemon.changeStat(stat, tempStat);
                otherPokemon.setStage(stat, tempStage);
            }
        }
    }

    public void reverseStats() {
        if (!this.pixelmon.bc.simulateMode) {
            for (BattleStatsType stat : BattleStatsType.ALL_BATTLE_STATS) {
                int statIndex = stat.getStatIndex();
                BattleStatStageModifyBattleEvent.Pre pre = new BattleStatStageModifyBattleEvent.Pre(this.pixelmon.bc, this.pixelmon, this.pixelmon, stat, this.stages[statIndex], -this.stages[statIndex]);
                if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                    return;
                }
                this.stages[statIndex] = pre.getNewValue();
                Pixelmon.EVENT_BUS.post((Event)pre.post());
                if (stat == BattleStatsType.ACCURACY || stat == BattleStatsType.EVASION) continue;
                int newValue = this.GetStat(this.stages[statIndex]);
                this.changeStat(stat, newValue);
            }
        }
    }

    public void resetStat(int index) {
        if (!this.pixelmon.bc.simulateMode) {
            this.changeStat(this.getStageEnum(index), 100);
            this.stages[index] = 0;
        }
    }

    public void resetStat(BattleStatsType stat) {
        if (!this.pixelmon.bc.simulateMode) {
            this.changeStat(stat, 100);
            this.stages[stat.getStatIndex()] = 0;
        }
    }

    public void clearBattleStats() {
        this.clearBattleStats(false);
    }

    public void clearBattleStats(boolean init) {
        if (init || this.pixelmon != null && this.pixelmon.bc != null && !this.pixelmon.bc.simulateMode) {
            this.evasion = 100;
            this.accuracy = 100;
            this.speedModifier = 100;
            this.specialDefenseModifier = 100;
            this.specialAttackModifier = 100;
            this.defenseModifier = 100;
            this.attackModifier = 100;
            this.critStage = 0;
            this.focused = false;
            this.stages = new int[7];
        }
    }

    public void clearBattleStatsNoCrit() {
        if (!this.pixelmon.bc.simulateMode) {
            this.evasion = 100;
            this.accuracy = 100;
            this.speedModifier = 100;
            this.specialDefenseModifier = 100;
            this.specialAttackModifier = 100;
            this.defenseModifier = 100;
            this.attackModifier = 100;
            this.stages = new int[7];
        }
    }

    public void resetLoweredBattleStats() {
        if (!this.pixelmon.bc.simulateMode) {
            for (int i = 0; i < 6; ++i) {
                if (this.stages[i] >= 0) continue;
                this.stages[i] = 0;
            }
        }
    }

    public void copyStats(BattleStats battleStats) {
        if (this.pixelmon == null || !this.pixelmon.bc.simulateMode) {
            this.speedModifier = battleStats.speedModifier;
            this.attackModifier = battleStats.attackModifier;
            this.defenseModifier = battleStats.defenseModifier;
            this.specialAttackModifier = battleStats.specialAttackModifier;
            this.specialDefenseModifier = battleStats.specialDefenseModifier;
            this.evasion = battleStats.evasion;
            this.accuracy = battleStats.accuracy;
            this.critStage = battleStats.critStage;
            this.focused = battleStats.focused;
            System.arraycopy(battleStats.stages, 0, this.stages, 0, this.stages.length);
        }
    }

    public boolean isStatModified() {
        for (int stage : this.stages) {
            if (stage == 0) continue;
            return true;
        }
        return false;
    }

    public int getSumIncreases() {
        int increases = 0;
        for (int stage : this.stages) {
            if (stage <= 0) continue;
            increases += stage;
        }
        return increases;
    }

    public int getSumStages() {
        int stageMods = 0;
        for (int stage : this.stages) {
            stageMods += stage;
        }
        return stageMods;
    }

    public boolean statCanBeRaised() {
        for (int stage : this.stages) {
            if (stage >= 6) continue;
            return true;
        }
        return false;
    }

    public boolean statCanBeLowered() {
        for (int stage : this.stages) {
            if (stage <= -6) continue;
            return true;
        }
        return false;
    }

    public boolean statCanBeRaised(BattleStatsType stat) {
        return this.stages[stat.getStatIndex()] < 6;
    }

    public boolean statCanBeLowered(BattleStatsType stat) {
        return this.stages[stat.getStatIndex()] > -6;
    }

    public ArrayList<Integer> getPossibleStatIncreases() {
        ArrayList<Integer> possibleStats = new ArrayList<Integer>();
        for (int i = 0; i < this.stages.length; ++i) {
            if (this.stages[i] >= 6) continue;
            possibleStats.add(i);
        }
        return possibleStats;
    }

    public boolean raiseRandomStat(int amount) {
        if (!this.statCanBeRaised()) {
            return false;
        }
        if (this.pixelmon.bc.simulateMode) {
            return true;
        }
        ArrayList<Integer> possibleStats = this.getPossibleStatIncreases();
        BattleStatsType stat = this.getStageEnum(possibleStats.get(RandomHelper.getRandomNumberBetween(0, possibleStats.size() - 1)));
        return this.modifyStat(amount, stat);
    }

    public int[] getBattleStats() {
        int[] stats = new int[7];
        stats[BattleStatsType.ATTACK.getStatIndex()] = this.attackStat;
        stats[BattleStatsType.DEFENSE.getStatIndex()] = this.defenseStat;
        stats[BattleStatsType.SPECIAL_ATTACK.getStatIndex()] = this.specialAttackStat;
        stats[BattleStatsType.SPECIAL_DEFENSE.getStatIndex()] = this.specialDefenseStat;
        stats[BattleStatsType.SPEED.getStatIndex()] = this.speedStat;
        stats[BattleStatsType.ACCURACY.getStatIndex()] = this.accuracy;
        stats[BattleStatsType.EVASION.getStatIndex()] = this.evasion;
        return stats;
    }

    public int[] getBaseBattleStats() {
        int[] stats = new int[7];
        PermanentStats statContainer = this.pixelmon.getStats();
        stats[BattleStatsType.ATTACK.getStatIndex()] = statContainer.getAttack();
        stats[BattleStatsType.DEFENSE.getStatIndex()] = statContainer.getDefense();
        stats[BattleStatsType.SPECIAL_ATTACK.getStatIndex()] = statContainer.getSpecialAttack();
        stats[BattleStatsType.SPECIAL_DEFENSE.getStatIndex()] = statContainer.getSpecialDefense();
        stats[BattleStatsType.SPEED.getStatIndex()] = statContainer.getSpeed();
        stats[BattleStatsType.ACCURACY.getStatIndex()] = 100;
        stats[BattleStatsType.EVASION.getStatIndex()] = 100;
        for (StatusBase statusBase : this.pixelmon.getStatuses()) {
            stats = statusBase.modifyBaseStats(this.pixelmon, stats);
        }
        for (GlobalStatusBase globalStatusBase : this.pixelmon.bc.globalStatusController.getGlobalStatuses()) {
            stats = globalStatusBase.modifyBaseStats(this.pixelmon, stats);
        }
        return stats;
    }

    public void setStatsForTurn(int[] stats) {
        int[] clone = (int[])this.getBattleStats().clone();
        this.attackStat = stats[BattleStatsType.ATTACK.getStatIndex()];
        this.defenseStat = stats[BattleStatsType.DEFENSE.getStatIndex()];
        this.specialAttackStat = stats[BattleStatsType.SPECIAL_ATTACK.getStatIndex()];
        this.specialDefenseStat = stats[BattleStatsType.SPECIAL_DEFENSE.getStatIndex()];
        this.speedStat = stats[BattleStatsType.SPEED.getStatIndex()];
        this.evasion = stats[BattleStatsType.EVASION.getStatIndex()];
        this.accuracy = stats[BattleStatsType.ACCURACY.getStatIndex()];
        this.pixelmon.bc.battleLog.logEvent(new StatChangeAction(this.pixelmon.bc.battleTurn, this.pixelmon, clone, stats));
    }

    public String getStatStringLang(BattleStatsType stat) {
        switch (stat) {
            case ACCURACY: {
                return "accuracy";
            }
            case EVASION: {
                return "evasion";
            }
            case ATTACK: {
                return "attack";
            }
            case DEFENSE: {
                return "defense";
            }
            case SPECIAL_ATTACK: {
                return "spatk";
            }
            case SPECIAL_DEFENSE: {
                return "spdef";
            }
            case SPEED: {
                return "speed";
            }
        }
        return "";
    }

    public void getStatFailureMessage(BattleStatsType stat, boolean increase) {
        String failtext = "pixelmon.effect." + this.getStatStringLang(stat) + "too";
        failtext = increase ? failtext + "high" : failtext + "low";
        this.pixelmon.bc.sendToAll(failtext, this.pixelmon.getNickname());
    }

    public int getStatWithMod(BattleStatsType stat) {
        switch (stat) {
            case ACCURACY: {
                return this.accuracy;
            }
            case EVASION: {
                return this.evasion;
            }
            case ATTACK: {
                return Math.max(1, (int)((double)(this.attackStat * this.attackModifier) * 0.01));
            }
            case DEFENSE: {
                return Math.max(1, (int)((double)(this.defenseStat * this.defenseModifier) * 0.01));
            }
            case SPECIAL_ATTACK: {
                return Math.max(1, (int)((double)(this.specialAttackStat * this.specialAttackModifier) * 0.01));
            }
            case SPECIAL_DEFENSE: {
                return Math.max(1, (int)((double)(this.specialDefenseStat * this.specialDefenseModifier) * 0.01));
            }
            case SPEED: {
                return Math.max(1, (int)((double)(this.speedStat * this.speedModifier) * 0.01));
            }
        }
        return 1;
    }

    public void setLoweredThisTurn(boolean loweredThisTurn) {
        this.loweredThisTurn = loweredThisTurn;
    }

    public boolean isLoweredThisTurn() {
        return this.loweredThisTurn;
    }

    public boolean isRaisedThisTurn() {
        return this.raisedThisTurn;
    }

    public void setRaisedThisTurn(boolean raisedThisTurn) {
        this.raisedThisTurn = raisedThisTurn;
    }

    public void setBattleStatsForCurrentForm() {
        int[] statsBefore = (int[])this.getBattleStats().clone();
        this.attackStat = this.pixelmon.getStats().calculateStat(BattleStatsType.ATTACK, this.pixelmon.getNature(), this.pixelmon.getForm(), this.pixelmon.getPokemonLevelNum());
        this.defenseStat = this.pixelmon.getStats().calculateStat(BattleStatsType.DEFENSE, this.pixelmon.getNature(), this.pixelmon.getForm(), this.pixelmon.getPokemonLevelNum());
        this.specialAttackStat = this.pixelmon.getStats().calculateStat(BattleStatsType.SPECIAL_ATTACK, this.pixelmon.getNature(), this.pixelmon.getForm(), this.pixelmon.getPokemonLevelNum());
        this.specialDefenseStat = this.pixelmon.getStats().calculateStat(BattleStatsType.SPECIAL_DEFENSE, this.pixelmon.getNature(), this.pixelmon.getForm(), this.pixelmon.getPokemonLevelNum());
        this.speedStat = this.pixelmon.getStats().calculateStat(BattleStatsType.SPEED, this.pixelmon.getNature(), this.pixelmon.getForm(), this.pixelmon.getPokemonLevelNum());
        this.pixelmon.bc.battleLog.logEvent(new StatChangeAction(this.pixelmon.bc.battleTurn, this.pixelmon, statsBefore, this.getBattleStats()));
    }

    public BattleStats copy() {
        BattleStats stats = new BattleStats(this);
        stats.attackStat = this.attackStat;
        stats.defenseStat = this.defenseStat;
        stats.specialAttackStat = this.specialAttackStat;
        stats.specialDefenseStat = this.specialDefenseStat;
        stats.speedStat = this.speedStat;
        return stats;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        int[] stats = this.getBattleStats();
        for (int i = 0; i < stats.length; ++i) {
            int stat = stats[i];
            joiner.add(BattleStatsType.fromIndex(i) + "=" + stat);
        }
        return joiner.toString();
    }
}

