/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import java.util.Objects;
import java.util.function.BiPredicate;

public enum BaseStatsLearnType {
    LEVELUP_MOVES((bs, ab) -> bs.getMoves().getAllLevelUpMoves().contains(ab)),
    ALL_TR_MOVES((bs, ab) -> {
        for (ITechnicalMove iTechnicalMove : bs.getMoves().getTRMoves()) {
            if (iTechnicalMove.getAttack() != ab) continue;
            return true;
        }
        return false;
    }),
    ALL_TM_MOVES((bs, ab) -> {
        for (int i = 1; i <= 8; ++i) {
            for (ITechnicalMove tm : bs.getMoves().getTMMovesFor(i)) {
                if (tm.getAttack() != ab) continue;
                return true;
            }
        }
        return false;
    }),
    HM_MOVES((bs, ab) -> bs.getMoves().getHMMoves().contains(ab)),
    TUTOR_MOVES((bs, ab) -> bs.getMoves().getTutorMoves().contains(ab)),
    TRANSFER_MOVES((bs, ab) -> bs.getMoves().getTransferMoves().contains(ab)),
    EGG_MOVES((bs, ab) -> bs.getMoves().getEggMoves().contains(ab)),
    GEN8_TM_MOVES(BaseStatsLearnType.technicalMachine(8)),
    GEN7_TM_MOVES(BaseStatsLearnType.technicalMachine(7)),
    GEN6_TM_MOVES(BaseStatsLearnType.technicalMachine(6)),
    GEN5_TM_MOVES(BaseStatsLearnType.technicalMachine(5)),
    GEN4_TM_MOVES(BaseStatsLearnType.technicalMachine(4)),
    GEN3_TM_MOVES(BaseStatsLearnType.technicalMachine(3)),
    GEN2_TM_MOVES(BaseStatsLearnType.technicalMachine(2)),
    GEN1_TM_MOVES(BaseStatsLearnType.technicalMachine(1));

    public static final BaseStatsLearnType[] GEN8_DEFAULT;
    private BiPredicate<Stats, ImmutableAttack> canLearn;
    private static final BaseStatsLearnType[] VALUES;

    private BaseStatsLearnType(BiPredicate<Stats, ImmutableAttack> canLearn) {
        this.canLearn = canLearn;
    }

    public boolean canLearn(Stats bs, ImmutableAttack ab) {
        return this.canLearn.test(bs, ab);
    }

    public static BaseStatsLearnType fromOrdinal(int orinal) {
        if (orinal >= 0 && orinal < VALUES.length) {
            return VALUES[orinal];
        }
        return null;
    }

    private static BiPredicate<Stats, ImmutableAttack> technicalMachine(int gen) {
        return (bs, ab) -> {
            for (ITechnicalMove tm : bs.getMoves().getTMMovesFor(gen)) {
                if (!Objects.equals(tm.getAttack(), ab)) continue;
                return true;
            }
            return false;
        };
    }

    static {
        GEN8_DEFAULT = new BaseStatsLearnType[]{LEVELUP_MOVES, ALL_TR_MOVES, HM_MOVES, TUTOR_MOVES, TRANSFER_MOVES, EGG_MOVES, GEN8_TM_MOVES};
        VALUES = BaseStatsLearnType.values();
    }
}

