/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.pokemon.species.gimmick.Gigantamax;
import java.lang.reflect.Type;

public class GigantamaxTypeAdapter
implements JsonSerializer<Gigantamax>,
JsonDeserializer<Gigantamax> {
    public Gigantamax deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        boolean canHaveFactor = jsonObject.get("canHaveFactor").getAsBoolean();
        boolean canGigantamax = jsonObject.get("canGigantamax").getAsBoolean();
        if (canGigantamax) {
            String form = jsonObject.get("form").getAsString();
            String move = jsonObject.get("move").getAsString();
            return new Gigantamax(form, move);
        }
        return new Gigantamax(canHaveFactor);
    }

    public JsonElement serialize(Gigantamax src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("canHaveFactor", Boolean.valueOf(src.canHaveFactor()));
        object.addProperty("canGigantamax", Boolean.valueOf(src.canGigantamax()));
        if (src.canGigantamax()) {
            object.addProperty("form", src.getForm());
            object.addProperty("move", src.getMove() == null ? "" : src.getMove().getAttackName());
        }
        return object;
    }
}

