/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.parameters.mounted;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.ControlledMovementLogic;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.Movement;
import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.VectorHelper;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractMovesEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMovementFlying;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.Thermals;
import com.pixelmonmod.pixelmon.enums.EnumKeybinds;
import com.pixelmonmod.pixelmon.enums.EnumMovement;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MountedFlyingParameters
implements ControlledMovementLogic {
    public static Codec<MountedFlyingParameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("upper_angle_limit").forGetter(o -> Float.valueOf(o.upperAngleLimit)), (App)Codec.FLOAT.fieldOf("lower_angle_limit").forGetter(o -> Float.valueOf(o.lowerAngleLimit)), (App)Codec.FLOAT.fieldOf("max_fly_speed").forGetter(o -> Float.valueOf(o.maxFlySpeed)), (App)Codec.FLOAT.fieldOf("deceleration_rate").forGetter(o -> Float.valueOf(o.decelerationRate)), (App)Codec.FLOAT.fieldOf("hover_deceleration_rate").forGetter(o -> Float.valueOf(o.hoverDecelerationRate)), (App)Codec.FLOAT.fieldOf("acceleration_rate").forGetter(o -> Float.valueOf(o.accelerationRate)), (App)Codec.FLOAT.fieldOf("strafe_acceleration_rate").forGetter(o -> Float.valueOf(o.strafeAccelerationRate)), (App)Codec.FLOAT.fieldOf("strafe_roll_conversion").forGetter(o -> Float.valueOf(o.strafeRollConversion)), (App)Codec.FLOAT.fieldOf("turn_rate").forGetter(o -> Float.valueOf(o.turnRate)), (App)Codec.FLOAT.fieldOf("pitch_rate").forGetter(o -> Float.valueOf(o.pitchRate)), (App)Codec.BOOL.fieldOf("stays_horizontal_flying").forGetter(o -> o.staysHorizontalFlying), (App)Codec.FLOAT.fieldOf("gravity_drop_per_tick").forGetter(o -> Float.valueOf(o.gravityDropPerTick)), (App)Codec.BOOL.fieldOf("continuous_forward_motion").forGetter(o -> o.continuousForwardMotion), (App)Codec.INT.fieldOf("continuous_forward_motion_ticks").forGetter(o -> o.continuousForwardMotionTicks), (App)Codec.INT.fieldOf("flying_stamina_charges").forGetter(o -> o.flyingStaminaCharges), (App)Codec.INT.fieldOf("hover_ticks").forGetter(o -> o.hoverTicks)).apply((Applicative)instance, MountedFlyingParameters::new));
    private final float upperAngleLimit;
    private final float lowerAngleLimit;
    private final float maxFlySpeed;
    private final float decelerationRate;
    private final float hoverDecelerationRate;
    private final float accelerationRate;
    private final float strafeAccelerationRate;
    private final float strafeRollConversion;
    private final float turnRate;
    private final float pitchRate;
    private final boolean staysHorizontalFlying;
    private final float gravityDropPerTick;
    private final boolean continuousForwardMotion;
    private final int continuousForwardMotionTicks;
    private final int flyingStaminaCharges;
    private final int hoverTicks;

    public MountedFlyingParameters(float upperAngleLimit, float lowerAngleLimit, float maxFlySpeed, float decelerationRate, float hoverDecelerationRate, float accelerationRate, float strafeAccelerationRate, float strafeRollConversion, float turnRate, float pitchRate, boolean staysHorizontalFlying, float gravityDropPerTick, boolean continuousForwardMotion, int continuousForwardMotionTicks, int flyingStaminaCharges, int hoverTicks) {
        this.upperAngleLimit = upperAngleLimit;
        this.lowerAngleLimit = lowerAngleLimit;
        this.maxFlySpeed = maxFlySpeed;
        this.decelerationRate = decelerationRate;
        this.hoverDecelerationRate = hoverDecelerationRate;
        this.accelerationRate = accelerationRate;
        this.strafeAccelerationRate = strafeAccelerationRate;
        this.strafeRollConversion = strafeRollConversion;
        this.turnRate = turnRate;
        this.pitchRate = pitchRate;
        this.staysHorizontalFlying = staysHorizontalFlying;
        this.gravityDropPerTick = gravityDropPerTick;
        this.continuousForwardMotion = continuousForwardMotion;
        this.continuousForwardMotionTicks = continuousForwardMotionTicks;
        this.flyingStaminaCharges = flyingStaminaCharges;
        this.hoverTicks = hoverTicks;
    }

    public MountedFlyingParameters() {
        this(45.0f, -45.0f, 2.0f, 0.3f, 0.07f, 0.05f, 0.9f, 30.0f, 1.0f, 1.0f, false, 0.005f, true, 5, 3, 4);
    }

    public float getUpperAngleLimit() {
        return this.upperAngleLimit;
    }

    public float getLowerAngleLimit() {
        return this.lowerAngleLimit;
    }

    public float getMaxFlySpeed() {
        return this.maxFlySpeed;
    }

    public float getDecelerationRate() {
        return this.decelerationRate;
    }

    public float getHoverDecelerationRate() {
        return this.hoverDecelerationRate;
    }

    public float getAccelerationRate() {
        return this.accelerationRate;
    }

    public float getStrafeAccelerationRate() {
        return this.strafeAccelerationRate;
    }

    public float getStrafeRollConversion() {
        return this.strafeRollConversion;
    }

    public float getTurnRate() {
        return this.turnRate;
    }

    public float getPitchRate() {
        return this.pitchRate;
    }

    public boolean isStaysHorizontalFlying() {
        return this.staysHorizontalFlying;
    }

    public float getGravityDropPerTick() {
        return this.gravityDropPerTick;
    }

    public boolean getContinuousForwardMotion() {
        return this.continuousForwardMotion;
    }

    public int getContinuousForwardMotionTicks() {
        return this.continuousForwardMotionTicks;
    }

    public int getFlyingStaminaCharges() {
        return this.flyingStaminaCharges;
    }

    public int getHoverTicks() {
        return this.hoverTicks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MountedFlyingParameters)) {
            return false;
        }
        MountedFlyingParameters that = (MountedFlyingParameters)o;
        return Float.compare(that.getUpperAngleLimit(), this.getUpperAngleLimit()) == 0 && Float.compare(that.getLowerAngleLimit(), this.getLowerAngleLimit()) == 0 && Float.compare(that.getMaxFlySpeed(), this.getMaxFlySpeed()) == 0 && Float.compare(that.getDecelerationRate(), this.getDecelerationRate()) == 0 && Float.compare(that.getHoverDecelerationRate(), this.getHoverDecelerationRate()) == 0 && Float.compare(that.getAccelerationRate(), this.getAccelerationRate()) == 0 && Float.compare(that.getStrafeAccelerationRate(), this.getStrafeAccelerationRate()) == 0 && Float.compare(that.getStrafeRollConversion(), this.getStrafeRollConversion()) == 0 && Float.compare(that.getTurnRate(), this.getTurnRate()) == 0 && Float.compare(that.getPitchRate(), this.getPitchRate()) == 0 && this.isStaysHorizontalFlying() == that.isStaysHorizontalFlying();
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.getUpperAngleLimit()), Float.valueOf(this.getLowerAngleLimit()), Float.valueOf(this.getMaxFlySpeed()), Float.valueOf(this.getDecelerationRate()), Float.valueOf(this.getHoverDecelerationRate()), Float.valueOf(this.getAccelerationRate()), Float.valueOf(this.getStrafeAccelerationRate()), Float.valueOf(this.getStrafeRollConversion()), Float.valueOf(this.getTurnRate()), Float.valueOf(this.getPitchRate()), this.isStaysHorizontalFlying());
    }

    @Override
    public Codec<? extends ControlledMovementLogic> codec() {
        return CODEC;
    }

    @Override
    public void handleMovementLogic(PixelmonEntity pixelmon, Player ridingPlayer) {
        pixelmon.m_20242_(true);
        if (pixelmon.getMovementTick() % this.continuousForwardMotionTicks == 0 && this.continuousForwardMotion) {
            Vec3 movement = ridingPlayer.m_20154_().m_82542_(pixelmon.m_21133_(Attributes.f_22279_), 0.0, pixelmon.m_21133_(Attributes.f_22279_));
            if (Math.abs(pixelmon.m_20184_().f_82479_) > 0.0 || Math.abs(pixelmon.m_20184_().f_82481_) > 0.0) {
                pixelmon.m_20256_(pixelmon.m_20184_().m_82549_(movement));
            }
        }
        double yMovement = pixelmon.getFlyPower();
        if (this.shouldDoContinuousMotion(pixelmon)) {
            if (this.hoverTicks > 0) {
                if (pixelmon.getHoverTicks() < this.hoverTicks) {
                    pixelmon.setHoverTicks(pixelmon.getHoverTicks() + 1);
                } else if (this.gravityDropPerTick > 0.0f) {
                    yMovement -= (double)this.gravityDropPerTick;
                }
            } else if (this.gravityDropPerTick > 0.0f) {
                yMovement -= (double)this.gravityDropPerTick;
            }
        }
        pixelmon.m_20256_(pixelmon.m_20184_().m_82520_(0.0, yMovement, 0.0));
        pixelmon.setFlyPower(0.0f);
    }

    private boolean shouldDoContinuousMotion(PixelmonEntity entity) {
        if (entity.battleController != null) {
            return false;
        }
        return entity.getMovementTick() % this.continuousForwardMotionTicks == 0 && this.continuousForwardMotion;
    }

    @Override
    public void handleRiderJump(PixelmonEntity pixelmon, Player ridingPlayer, int power) {
        if (pixelmon.getFlyingCharges() == -100 || !pixelmon.isFlying()) {
            pixelmon.setFlyingCharges(this.flyingStaminaCharges);
        }
        if (pixelmon.getLastJump() != -1 && pixelmon.getMovementTick() - pixelmon.getLastJump() <= 20) {
            return;
        }
        if (pixelmon.getFlyingCharges() == 0 && pixelmon.isFlying()) {
            return;
        }
        if (pixelmon.isFlying() && pixelmon.getFlyingCharges() > 0) {
            pixelmon.setFlyingCharges(pixelmon.getFlyingCharges() - 1);
        }
        pixelmon.setLastJump(pixelmon.getMovementTick());
        pixelmon.setFlyPower((float)((double)pixelmon.getFlyPower() + Math.max(1.0, 3.0 * ((double)power / 90.0))));
        pixelmon.setHoverTicks(0);
        if (!pixelmon.isFlying()) {
            pixelmon.setAnimation(AnimationType.FLY);
            pixelmon.takeOff();
        }
    }

    @Override
    public void calcMoveSpeed(AbstractMovesEntity entity) {
        if (!entity.isHovering()) {
            entity.f_20902_ = (0.2f + (this.upperAngleLimit - entity.f_19858_) / (this.upperAngleLimit - this.lowerAngleLimit) * this.maxFlySpeed + 0.1f) * entity.getMoveMultiplier();
        } else if (entity.f_20902_ > PixelmonConfigProxy.getGeneral().getRiding().getFlyingSpeedLimit()) {
            entity.f_20902_ = PixelmonConfigProxy.getGeneral().getRiding().getFlyingSpeedLimit();
        }
    }

    @Override
    public boolean getStaysHorizontalInRender(AbstractMovesEntity entity) {
        return this.staysHorizontalFlying;
    }

    @Override
    public void calculateRoll(AbstractMovesEntity pixelmon, float strafe) {
        Movement m = pixelmon.getForm().getMovement();
        float strafeRotationRoll = strafe / 0.5f * this.strafeRollConversion;
        float turnRotationRoll = -1.0f * (pixelmon.f_19857_ - pixelmon.f_19859_) / 8.0f * this.strafeRollConversion;
        float degreesPast360 = 360.0f - pixelmon.f_19857_ + pixelmon.f_19859_;
        float degreesBack360 = pixelmon.f_19857_ + 360.0f - pixelmon.f_19859_;
        float diff = Math.abs(pixelmon.f_19857_ - pixelmon.f_19859_);
        if (degreesPast360 < diff && degreesPast360 < degreesBack360) {
            turnRotationRoll = -1.0f * degreesPast360 / 8.0f * this.strafeRollConversion;
        } else if (degreesBack360 < diff && degreesBack360 < degreesPast360) {
            turnRotationRoll = -1.0f * degreesBack360 / 8.0f * this.strafeRollConversion;
        }
        pixelmon.prevRotationRoll = pixelmon.rotationRoll;
        if (Math.abs(strafeRotationRoll) > Math.abs(turnRotationRoll)) {
            pixelmon.rotationRoll = 0.8f * pixelmon.prevRotationRoll + 0.2f * strafeRotationRoll;
        } else {
            pixelmon.rotationRoll = 0.8f * pixelmon.prevRotationRoll + 0.2f * turnRotationRoll;
            if (pixelmon.rotationRoll > 45.0f) {
                pixelmon.rotationRoll = 45.0f;
            }
            if (pixelmon.rotationRoll < -45.0f) {
                pixelmon.rotationRoll = -45.0f;
            }
        }
    }

    @Override
    public void handleMovement(List<EnumKeybinds> movements, AbstractMovesEntity pixelmon) {
        for (EnumKeybinds movement : movements) {
            if (movement == EnumKeybinds.Left) {
                pixelmon.f_20900_ = 0.5f;
            }
            if (movement == EnumKeybinds.Right) {
                pixelmon.f_20900_ = -0.5f;
            }
            if (movement == EnumKeybinds.Forward) {
                pixelmon.f_19858_ -= 0.5f * this.pitchRate;
                if (pixelmon.f_19858_ < this.lowerAngleLimit) {
                    pixelmon.f_19858_ = this.lowerAngleLimit;
                }
            }
            if (movement == EnumKeybinds.Back) {
                pixelmon.f_19858_ += 0.5f * this.pitchRate;
                if (pixelmon.f_19858_ > this.upperAngleLimit) {
                    pixelmon.f_19858_ = this.upperAngleLimit;
                }
            }
            if (movement == EnumKeybinds.Jump) {
                if (pixelmon.isHovering()) {
                    pixelmon.setStrafeUpDown(pixelmon.getStrafeUpDown() + 1.0f);
                } else {
                    pixelmon.setMoveMultiplier(pixelmon.getMoveMultiplier() + 0.005f);
                    if (pixelmon.getMoveMultiplier() > 1.4f) {
                        pixelmon.setMoveMultiplier(1.4f);
                    }
                }
            }
            if (movement != EnumKeybinds.Sprint) continue;
            if (pixelmon.isHovering()) {
                pixelmon.setStrafeUpDown(pixelmon.getStrafeUpDown() - 1.5f);
                continue;
            }
            pixelmon.setMoveMultiplier(pixelmon.getMoveMultiplier() - 0.005f);
            if (!(pixelmon.getMoveMultiplier() < 0.3f)) continue;
            pixelmon.setMoveMultiplier(0.3f);
        }
        boolean breakHover = false;
        for (EnumKeybinds movement : movements) {
            if (!movement.breaksHover() || !pixelmon.isHovering()) continue;
            breakHover = true;
        }
        if (breakHover) {
            pixelmon.toggleHover();
        }
    }

    @Override
    public void travelCustom(AbstractMovesEntity pixelmon, PixelmonMovementFlying pixelmonMovementFlying) {
        if (!pixelmon.f_19853_.f_46443_ && pixelmon.takeOffTicks == 0 && !pixelmon.f_19853_.m_45772_(pixelmon.m_20191_().m_82363_(0.2, 0.2, 0.2).m_82363_(-0.2, -0.2, -0.2))) {
            pixelmon.setFlying(false);
            pixelmon.f_19858_ = 0.0f;
            pixelmon.rotationRoll = 0.0f;
            pixelmon.onLanding();
        }
        pixelmon.setThermalPower(Thermals.getThermalPower(pixelmon.f_19853_, pixelmon.m_20183_()));
        if (pixelmon.takeOffTicks > 0) {
            --pixelmon.takeOffTicks;
        }
        if (pixelmon.m_6688_() != null) {
            float dragonYaw;
            float playerYaw = pixelmon.getFlyingDirection();
            if (playerYaw > 360.0f) {
                playerYaw -= 360.0f;
                pixelmon.m_6688_().f_19857_ -= 360.0f;
            }
            if (playerYaw < 0.0f) {
                playerYaw += 360.0f;
                pixelmon.m_6688_().f_19857_ += 360.0f;
            }
            if ((dragonYaw = pixelmon.f_19857_) > 360.0f) {
                dragonYaw -= 360.0f;
                pixelmon.f_19857_ -= 360.0f;
            }
            if (dragonYaw < 0.0f) {
                dragonYaw += 360.0f;
                pixelmon.f_19857_ += 360.0f;
            }
            float degreesPast360 = 360.0f - dragonYaw + playerYaw;
            float degreesBack360 = dragonYaw + 360.0f - playerYaw;
            float diff = Math.abs(playerYaw - dragonYaw);
            float degreeShift = 13.0f * this.turnRate * 1.0f / (1.0f + pixelmon.f_20902_);
            if (dragonYaw != playerYaw) {
                pixelmon.f_19857_ = diff <= degreeShift || degreesPast360 <= degreeShift || degreesBack360 <= degreeShift ? playerYaw : (degreesPast360 < diff && degreesPast360 < degreesBack360 ? (pixelmon.f_19857_ += degreeShift) : (degreesBack360 < diff && degreesBack360 < degreesPast360 ? (pixelmon.f_19857_ -= degreeShift) : (dragonYaw < playerYaw ? (pixelmon.f_19857_ += degreeShift) : (pixelmon.f_19857_ -= degreeShift))));
            }
        }
        pixelmon.f_20901_ = -0.02f;
        pixelmon.calcMoveSpeed();
        pixelmon.setHoverRotationPitch(20.0f);
        float strafe = pixelmon.f_20900_;
        float forward = pixelmon.f_20902_;
        Movement m = pixelmon.getForm().getMovement();
        if (pixelmon.lastSpeed == -1.0f) {
            pixelmon.lastSpeed = forward;
        }
        if (pixelmon.lastStrafe == -1.0f) {
            pixelmon.lastStrafe = strafe;
        }
        if (pixelmon.lastStrafeUp == -1.0f) {
            pixelmon.lastStrafeUp = pixelmon.getStrafeUpDown();
        }
        if (pixelmon.isHovering()) {
            pixelmon.f_19858_ += (pixelmon.getHoverRotationPitch() - pixelmon.f_19858_) * this.pitchRate / 8.0f;
        }
        LivingEntity passenger = pixelmon.m_6688_();
        float pitch = pixelmon.f_19858_;
        float f1 = Mth.m_14031_((float)(-1.0f * pixelmon.f_19857_ * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(-1.0f * pixelmon.f_19857_ * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
        float f4 = Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        Vector3f movementVector = new Vector3f(f4 * f1, f3, f4 * f2);
        Vector3f strafeVector = new Vector3f(0.0f, 1.0f, 0.0f);
        strafeVector = VectorHelper.crossProduct(strafeVector, movementVector);
        Vector3f strafeUpVector = new Vector3f(strafeVector.x(), strafeVector.y(), strafeVector.z());
        strafeUpVector = VectorHelper.crossProduct(strafeUpVector, movementVector);
        float speed = forward > pixelmon.lastSpeed ? pixelmon.lastSpeed * (1.0f - this.accelerationRate) + this.accelerationRate * forward : (m.getMountedFlyingParameters() != null ? (!pixelmon.isHovering() ? pixelmon.lastSpeed * (1.0f - this.decelerationRate) + this.decelerationRate * forward : pixelmon.lastSpeed * (1.0f - this.hoverDecelerationRate) + this.hoverDecelerationRate * forward) : 1.0f);
        if (strafe != pixelmon.lastStrafe) {
            strafe = pixelmon.lastStrafe * this.strafeAccelerationRate + (1.0f - this.strafeAccelerationRate) * strafe;
        }
        if (pixelmon.getStrafeUpDown() != pixelmon.lastStrafeUp) {
            pixelmon.setStrafeUpDown(pixelmon.lastStrafeUp * this.strafeAccelerationRate + (1.0f - this.strafeAccelerationRate) * pixelmon.getStrafeUpDown());
        }
        if (pixelmon.f_19853_.f_46443_ && pixelmon.isFlying() && pixelmon.m_6109_()) {
            this.calculateRoll(pixelmon, strafe);
        }
        pixelmonMovementFlying.scale(strafeVector, -1.0f * strafe);
        if (strafeUpVector.y() > 0.0f) {
            pixelmonMovementFlying.scale(strafeUpVector, pixelmon.getStrafeUpDown());
        } else {
            pixelmonMovementFlying.scale(strafeUpVector, -1.0f * pixelmon.getStrafeUpDown());
        }
        pixelmonMovementFlying.scale(movementVector, speed);
        pixelmon.lastSpeed = speed;
        pixelmon.lastStrafe = strafe;
        double takeOffPower = 0.0;
        if (pixelmon.takeOffTicks > 0) {
            takeOffPower = 1.0;
            if (pixelmon.takeOffTicks <= 10) {
                takeOffPower = (double)pixelmon.takeOffTicks / 10.0;
            }
        }
        pixelmon.m_20334_(movementVector.x() + strafeVector.x() + strafeUpVector.x(), (double)(movementVector.y() + strafeVector.y() + strafeUpVector.y()) + takeOffPower / 3.0, movementVector.z() + strafeVector.z() + strafeUpVector.z());
        if (passenger != null && !pixelmon.isHovering()) {
            EntityHelper.addMotion((Entity)pixelmon, EnumRotation.y, (double)pixelmon.getThermalPower() / 4.0 - (double)pixelmon.getFallRate());
        }
        pixelmon.m_6478_(MoverType.SELF, pixelmon.m_20184_());
        pixelmon.f_20900_ *= 0.94f;
        pixelmon.setStrafeUpDown(pixelmon.getStrafeUpDown() * 0.94f);
    }

    @Override
    public void handleKeybindMovement(List<EnumMovement> movements, AbstractMovesEntity pixelmon) {
        for (EnumMovement movement : movements) {
            if (movement != EnumMovement.Descend) continue;
            pixelmon.m_20256_(pixelmon.m_20184_().m_82520_(0.0, -(pixelmon.getForm().getDimensions().getHeight() / 2.0), 0.0));
        }
    }
}

