/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.ModelAttachment;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModelLoader;
import com.pixelmonmod.pixelmon.client.render.shader.PixelmonCodecs;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public final class ModelData {
    public static final Codec<ModelData> MODEL_DATA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceWithFallback.TEXTURE_CODEC.fieldOf("model").forGetter(o -> o.model), (App)ResourceWithFallback.TEXTURE_CODEC.fieldOf("texture").forGetter(o -> o.texture), (App)ResourceWithFallback.TEXTURE_CODEC.optionalFieldOf("emissive", (Object)ResourceWithFallback.NONE).forGetter(o -> o.emissive), (App)ResourceWithFallback.TEXTURE_CODEC.optionalFieldOf("normal_map", (Object)ResourceWithFallback.NONE).forGetter(o -> o.emissive), (App)PixelmonCodecs.OPTIONAL_DIMENSIONS_CODEC.optionalFieldOf("scale", (Object)new Vector3f(1.0f, 1.0f, 1.0f)).forGetter(o -> o.scale), (App)ExtraCodecs.f_252432_.optionalFieldOf("rotate_angle", (Object)new Vector3f(-1.5707964f, 0.0f, 0.0f)).forGetter(o -> o.rotateAngle), (App)Codec.FLOAT.optionalFieldOf("movement_threshold", (Object)Float.valueOf(0.3f)).forGetter(o -> Float.valueOf(o.movementThreshold)), (App)Codec.FLOAT.optionalFieldOf("animation_increment", (Object)Float.valueOf(1.0f)).forGetter(o -> Float.valueOf(o.animationIncrement)), (App)ExtraCodecs.f_252432_.optionalFieldOf("offsets", (Object)new Vector3f(0.0f, 0.0f, 0.0f)).forGetter(o -> o.offsets), (App)Codec.FLOAT.optionalFieldOf("texture_transparency", (Object)Float.valueOf(1.0f)).forGetter(o -> Float.valueOf(o.animationIncrement)), (App)ModelAttachment.CODEC.listOf().optionalFieldOf("attachments", List.of()).forGetter(o -> o.attachments)).apply((Applicative)instance, ModelData::new));
    private final ResourceWithFallback model;
    private final ResourceWithFallback texture;
    private final ResourceWithFallback emissive;
    private final ResourceWithFallback normalMap;
    private final Vector3f scale;
    private final Vector3f rotateAngle;
    private final float movementThreshold;
    private final float animationIncrement;
    private final Vector3f offsets;
    private final float textureTransparency;
    private final List<ModelAttachment> attachments;
    private transient boolean cached = false;
    private transient ValveStudioModel cachedModel;

    public ModelData(ResourceWithFallback model, ResourceWithFallback texture, ResourceWithFallback emissive, ResourceWithFallback normalMap, Vector3f scale, Vector3f rotateAngle, float movementThreshold, float animationIncrement, Vector3f offsets, float textureTransparency, List<ModelAttachment> attachments) {
        this.model = model;
        this.texture = texture;
        this.emissive = emissive;
        this.normalMap = normalMap;
        this.scale = scale;
        this.rotateAngle = rotateAngle;
        this.movementThreshold = movementThreshold;
        this.animationIncrement = animationIncrement;
        this.offsets = offsets;
        this.textureTransparency = textureTransparency;
        this.attachments = attachments;
    }

    public boolean usingFallback() {
        return this.model.usingFallback() || this.texture.usingFallback() || !this.emissive.isNone() && this.emissive.usingFallback() || !this.normalMap.isNone() && this.normalMap.usingFallback();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ValveStudioModel getModel() {
        if (this.cached) {
            return this.cachedModel;
        }
        ResourceLocation modelLocation = this.model().get();
        if (modelLocation.m_135815_().equals("textures/none")) {
            this.cached = true;
            this.cachedModel = null;
            return null;
        }
        this.cached = true;
        try {
            this.cachedModel = ValveStudioModelLoader.INSTANCE.loadModel(this, modelLocation);
            return this.cachedModel;
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Model loading error", (Throwable)new RuntimeException("Error while loading model at " + modelLocation, e));
            this.cached = true;
            this.cachedModel = null;
            return null;
        }
    }

    public ResourceWithFallback model() {
        return this.model;
    }

    public ResourceWithFallback texture() {
        return this.texture;
    }

    public ResourceWithFallback emissive() {
        return this.emissive;
    }

    public ResourceWithFallback normalMap() {
        return this.normalMap;
    }

    public Vector3f scale() {
        return this.scale;
    }

    public Vector3f rotateAngle() {
        return this.rotateAngle;
    }

    public float movementThreshold() {
        return this.movementThreshold;
    }

    public float animationIncrement() {
        return this.animationIncrement;
    }

    public Vector3f offsets() {
        return this.offsets;
    }

    public float textureTransparency() {
        return this.textureTransparency;
    }

    public List<ModelAttachment> attachments() {
        return this.attachments;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ModelData that = (ModelData)obj;
        return Objects.equals(this.model, that.model) && Objects.equals(this.texture, that.texture) && Objects.equals(this.emissive, that.emissive) && Objects.equals(this.normalMap, that.normalMap) && Objects.equals(this.scale, that.scale) && Objects.equals(this.rotateAngle, that.rotateAngle) && Float.floatToIntBits(this.movementThreshold) == Float.floatToIntBits(that.movementThreshold) && Float.floatToIntBits(this.animationIncrement) == Float.floatToIntBits(that.animationIncrement) && Objects.equals(this.offsets, that.offsets) && Float.floatToIntBits(this.textureTransparency) == Float.floatToIntBits(that.textureTransparency) && Objects.equals(this.attachments, that.attachments);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.texture, this.emissive, this.normalMap, this.scale, this.rotateAngle, Float.valueOf(this.movementThreshold), Float.valueOf(this.animationIncrement), this.offsets, Float.valueOf(this.textureTransparency), this.attachments);
    }

    public String toString() {
        return "ModelData[model=" + this.model + ", texture=" + this.texture + ", emissive=" + this.emissive + ", normalMap=" + this.normalMap + ", scale=" + this.scale + ", rotateAngle=" + this.rotateAngle + ", movementThreshold=" + this.movementThreshold + ", animationIncrement=" + this.animationIncrement + ", offsets=" + this.offsets + ", textureTransparency=" + this.textureTransparency + ", attachments=" + this.attachments + "]";
    }
}

