/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.palette;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.pixelmonmod.pixelmon.api.pokemon.species.DataCopier;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelLocator;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.biome.AmbientParticleSettings;

public class PalettePropertiesTypeAdapter
implements JsonSerializer<PaletteProperties>,
JsonDeserializer<PaletteProperties> {
    public PaletteProperties deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        DataResult dataResult = PaletteProperties.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)object);
        if (dataResult.error().isPresent()) {
            throw new JsonParseException(((DataResult.PartialResult)dataResult.error().get()).message());
        }
        PaletteProperties defaultPalette = DataCopier.getPalette().map(PaletteProperties::clone).orElse(null);
        PaletteProperties decodedPalette = (PaletteProperties)((Pair)PaletteProperties.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)object).get().left().get()).getFirst();
        if (defaultPalette == null) {
            DataCopier.setPalette(decodedPalette);
            return decodedPalette;
        }
        String name = decodedPalette.getName();
        String translationKey = decodedPalette.getTranslationKey();
        ModelLocator[] modelLocators = decodedPalette.getModelLocators();
        ResourceWithFallback sprite = decodedPalette.sprite;
        AmbientParticleSettings particle = decodedPalette.getParticle();
        List<Holder<SoundEvent>> sounds = decodedPalette.sounds;
        if (translationKey == null || translationKey.isEmpty()) {
            translationKey = defaultPalette.getTranslationKey();
        }
        if (sprite == null) {
            sprite = defaultPalette.sprite;
        }
        if (modelLocators == null || modelLocators.length == 0) {
            modelLocators = defaultPalette.getModelLocators();
        }
        if (particle == null) {
            particle = defaultPalette.getParticle();
        }
        if (sounds == null || sounds.size() == 0) {
            sounds = defaultPalette.sounds;
        }
        PaletteProperties palette = new PaletteProperties(name, translationKey, Arrays.asList(modelLocators), sprite, sounds, Optional.ofNullable(particle));
        DataCopier.setPalette(palette);
        return palette;
    }

    public JsonElement serialize(PaletteProperties src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonObject();
    }
}

