/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.palette;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelData;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelLocator;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PaletteProperties
implements Cloneable,
ITranslatable {
    public static final Codec<PaletteProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(o -> o.name), (App)Codec.STRING.optionalFieldOf("translation_key", (Object)"").forGetter(o -> o.translationKey), (App)ModelLocator.CODEC.listOf().fieldOf("models").forGetter(o -> Lists.newArrayList((Object[])o.modelLocators)), (App)ResourceWithFallback.TEXTURE_CODEC.fieldOf("sprite").forGetter(o -> o.sprite), (App)SoundEvent.f_263130_.listOf().optionalFieldOf("sounds", List.of()).forGetter(o -> Lists.newArrayList(o.sounds)), (App)AmbientParticleSettings.f_47412_.optionalFieldOf("particle").forGetter(o -> Optional.ofNullable(o.particle))).apply((Applicative)instance, PaletteProperties::new));
    protected final String name;
    protected final String translationKey;
    protected final ModelLocator[] modelLocators;
    protected final ResourceWithFallback sprite;
    protected final List<Holder<SoundEvent>> sounds;
    protected final AmbientParticleSettings particle;

    public PaletteProperties(String name, String translationKey, List<ModelLocator> modelLocators, ResourceWithFallback sprite, List<Holder<SoundEvent>> sounds, Optional<AmbientParticleSettings> particleSettings) {
        this.name = name;
        this.translationKey = translationKey;
        this.modelLocators = modelLocators.toArray(new ModelLocator[0]);
        this.sprite = sprite;
        this.sounds = sounds;
        this.particle = particleSettings.orElse(null);
    }

    protected PaletteProperties clone() {
        return new PaletteProperties(this.name, this.translationKey, Lists.newArrayList((Object[])this.modelLocators), this.sprite, this.sounds, Optional.ofNullable(this.particle));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getTranslationKey() {
        if (!this.translationKey.isEmpty()) {
            return this.translationKey;
        }
        return "pixelmon.palette." + this.name;
    }

    public void preloadModels() {
        for (ModelLocator modelLocator : this.modelLocators) {
            for (ModelData model : modelLocator.getModels()) {
                model.getModel();
            }
        }
    }

    public ModelLocator[] getModelLocators() {
        return this.modelLocators;
    }

    public ModelData[] getModel(AbstractClientEntity entity) {
        if (this.modelLocators == null || this.modelLocators.length == 0) {
            return null;
        }
        int modelSlot = entity.getModelSlot();
        if (modelSlot < 0 || modelSlot >= this.modelLocators.length) {
            return this.modelLocators[0].getModels();
        }
        return this.modelLocators[modelSlot].getModels();
    }

    public ResourceLocation getSprite() {
        return this.sprite.get();
    }

    public AmbientParticleSettings getParticle() {
        return this.particle;
    }

    public SoundEvent getSound() {
        Holder<SoundEvent> sound = RandomHelper.getRandomElementFromList(this.sounds);
        if (sound == null) {
            return null;
        }
        return (SoundEvent)sound.get();
    }

    public boolean is(String palette) {
        return this.name.equalsIgnoreCase(palette);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean usingFallback() {
        for (ModelLocator modelLocator : this.modelLocators) {
            if (!modelLocator.usingFallback()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaletteProperties that = (PaletteProperties)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.translationKey, that.translationKey) && Arrays.equals(this.modelLocators, that.modelLocators) && Objects.equals(this.sprite, that.sprite) && Objects.equals(this.sounds, that.sounds) && Objects.equals(this.particle, that.particle);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.translationKey, this.sprite, this.sounds, this.particle);
        result = 31 * result + Arrays.hashCode(this.modelLocators);
        return result;
    }
}

