/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.evs;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.function.BiFunction;

public record EVYields(int hp, int attack, int defense, int specialAttack, int specialDefense, int speed) {
    private static EVYields ZERO = new EVYields(0, 0, 0, 0, 0, 0);

    public EVYields(int[] yields) {
        this(yields[0], yields[1], yields[2], yields[3], yields[4], yields[5]);
    }

    public EVYields setHP(int hp) {
        return this.setYield(BattleStatsType.HP, hp);
    }

    public EVYields setAttack(int attack) {
        return this.setYield(BattleStatsType.ATTACK, attack);
    }

    public EVYields setDefense(int defense) {
        return this.setYield(BattleStatsType.DEFENSE, defense);
    }

    public EVYields setSpecialAttack(int specialAttack) {
        return this.setYield(BattleStatsType.SPECIAL_ATTACK, specialAttack);
    }

    public EVYields setSpecialDefense(int specialDefense) {
        return this.setYield(BattleStatsType.SPECIAL_DEFENSE, specialDefense);
    }

    public EVYields setSpeed(int speed) {
        return this.setYield(BattleStatsType.SPEED, speed);
    }

    public EVYields addToHP(int hp) {
        return this.addToYield(BattleStatsType.HP, hp);
    }

    public EVYields addToAttack(int attack) {
        return this.addToYield(BattleStatsType.ATTACK, attack);
    }

    public EVYields addToDefense(int defense) {
        return this.addToYield(BattleStatsType.DEFENSE, defense);
    }

    public EVYields addToSpecialAttack(int specialAttack) {
        return this.addToYield(BattleStatsType.SPECIAL_ATTACK, specialAttack);
    }

    public EVYields addToSpecialDefense(int specialDefense) {
        return this.addToYield(BattleStatsType.SPECIAL_DEFENSE, specialDefense);
    }

    public EVYields addToSpeed(int speed) {
        return this.addToYield(BattleStatsType.SPEED, speed);
    }

    public EVYields set(BiFunction<BattleStatsType, Integer, Integer> handler) {
        return new EVYields(handler.apply(BattleStatsType.HP, this.hp()), handler.apply(BattleStatsType.ATTACK, this.attack()), handler.apply(BattleStatsType.DEFENSE, this.defense()), handler.apply(BattleStatsType.SPECIAL_ATTACK, this.specialAttack()), handler.apply(BattleStatsType.SPECIAL_DEFENSE, this.specialDefense()), handler.apply(BattleStatsType.SPEED, this.speed()));
    }

    public int getYield(BattleStatsType stat) {
        return switch (stat) {
            case BattleStatsType.HP -> this.hp();
            case BattleStatsType.ATTACK -> this.attack();
            case BattleStatsType.DEFENSE -> this.defense();
            case BattleStatsType.SPECIAL_ATTACK -> this.specialAttack();
            case BattleStatsType.SPECIAL_DEFENSE -> this.specialDefense();
            case BattleStatsType.SPEED -> this.speed();
            default -> 0;
        };
    }

    public EVYields setYield(BattleStatsType type, int amount) {
        int hp = type == BattleStatsType.HP ? amount : this.hp();
        int attack = type == BattleStatsType.ATTACK ? amount : this.attack();
        int defense = type == BattleStatsType.DEFENSE ? amount : this.defense();
        int specialAttack = type == BattleStatsType.SPECIAL_ATTACK ? amount : this.specialAttack();
        int specialDefense = type == BattleStatsType.SPECIAL_DEFENSE ? amount : this.specialDefense();
        int speed = type == BattleStatsType.SPEED ? amount : this.speed();
        return new EVYields(hp, attack, defense, specialAttack, specialDefense, speed);
    }

    public EVYields addToYield(BattleStatsType stat, int amount) {
        int hp = this.hp() + (stat == BattleStatsType.HP ? amount : 0);
        int attack = this.attack() + (stat == BattleStatsType.ATTACK ? amount : 0);
        int defense = this.defense() + (stat == BattleStatsType.DEFENSE ? amount : 0);
        int specialAttack = this.specialAttack() + (stat == BattleStatsType.SPECIAL_ATTACK ? amount : 0);
        int specialDefense = this.specialDefense() + (stat == BattleStatsType.SPECIAL_DEFENSE ? amount : 0);
        int speed = this.speed() + (stat == BattleStatsType.SPEED ? amount : 0);
        return new EVYields(hp, attack, defense, specialAttack, specialDefense, speed);
    }

    public EVYields multiply(double multiplier) {
        return new EVYields((int)((double)this.hp * multiplier), (int)((double)this.attack * multiplier), (int)((double)this.defense * multiplier), (int)((double)this.specialAttack * multiplier), (int)((double)this.specialDefense * multiplier), (int)((double)this.speed * multiplier));
    }

    public EVYields doubleYields() {
        return this.multiply(2.0);
    }

    public int[] toArray() {
        return new int[]{this.hp, this.attack, this.defense, this.specialAttack, this.specialDefense, this.speed};
    }

    public EVYields copy() {
        return new EVYields(this.hp, this.attack, this.defense, this.specialAttack, this.specialDefense, this.speed);
    }

    public static EVYields random() {
        return new EVYields(RandomHelper.getRandomNumberBetween(0, 3), RandomHelper.getRandomNumberBetween(0, 3), RandomHelper.getRandomNumberBetween(0, 3), RandomHelper.getRandomNumberBetween(0, 3), RandomHelper.getRandomNumberBetween(0, 3), RandomHelper.getRandomNumberBetween(0, 3));
    }

    public static EVYields zero() {
        return ZERO;
    }
}

