/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.dimensions;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;

public class Dimensions {
    private final double height;
    private final double width;
    private final double length;
    private final float eyeHeight;
    private final float hoverHeight;

    public Dimensions(double height, double width, double length, float eyeHeight, float hoverHeight) {
        this.height = height;
        this.width = width;
        this.length = length;
        this.eyeHeight = eyeHeight;
        this.hoverHeight = hoverHeight;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getLength() {
        return this.length;
    }

    public float getEyeHeight() {
        return this.eyeHeight;
    }

    public float getHoverHeight() {
        return this.hoverHeight;
    }

    public AABB createBoundingBox() {
        double diameter = this.width / 2.0;
        return new AABB(diameter, 0.0, diameter, diameter, this.height, diameter);
    }

    public AABB createBoundingBox(Entity entity) {
        double diameter = this.width / 2.0;
        return new AABB(entity.m_20185_() - diameter, entity.m_20186_(), entity.m_20189_() - diameter, entity.m_20185_() + diameter, entity.m_20186_() + this.height, entity.m_20189_() + diameter);
    }

    public AABB createBoundingBox(Entity entity, double scale) {
        double diameter = this.width * scale / 2.0;
        return new AABB(entity.m_20185_() - diameter, entity.m_20186_(), entity.m_20189_() - diameter, entity.m_20185_() + diameter, entity.m_20186_() + this.height * scale, entity.m_20189_() + diameter);
    }
}

