/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ribbon;

import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.MutableRibbonData;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.type.RibbonType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class Ribbon {
    protected final String type;
    protected final long receivedDate;
    protected final Component receiver;
    protected MutableRibbonData ribbonData;

    public Ribbon(String type, long receivedDate, Component receiver) {
        this.type = type;
        this.receivedDate = receivedDate;
        this.receiver = receiver;
    }

    public Ribbon(String type, long receivedDate, Component receiver, MutableRibbonData ribbonData) {
        this.type = type;
        this.receivedDate = receivedDate;
        this.receiver = receiver;
        this.ribbonData = ribbonData;
    }

    public RegistryValue<RibbonType> getType() {
        return RibbonRegistry.getRibbon(this.type);
    }

    public long getReceivedDate() {
        return this.receivedDate;
    }

    public Component getReceiver() {
        return this.receiver;
    }

    public MutableRibbonData getRibbonData() {
        return this.ribbonData;
    }

    public void refreshData(Pokemon pokemon) {
        this.ribbonData = MutableRibbonData.fromType(this.getType().getValueUnsafe(), pokemon, this);
        pokemon.markDirty(EnumUpdateType.Ribbons);
    }

    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("type", (Tag)StringTag.m_129297_((String)this.type));
        nbt.m_128365_("received", (Tag)LongTag.m_128882_((long)this.receivedDate));
        nbt.m_128365_("receiver", (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)this.receiver)));
        return nbt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Ribbon)) {
            return false;
        }
        Ribbon ribbon = (Ribbon)o;
        return this.getReceivedDate() == ribbon.getReceivedDate() && Objects.equals(this.type, ribbon.type) && Objects.equals(this.getReceiver(), ribbon.getReceiver());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getReceivedDate(), this.getReceiver(), this.getRibbonData());
    }

    public static Ribbon fromNbt(CompoundTag nbt) {
        return Ribbon.builder().type(RibbonRegistry.getRibbon(nbt.m_128461_("type")).getValueUnsafe()).receivedDate(nbt.m_128454_("received")).receiver((Component)Component.Serializer.m_130701_((String)nbt.m_128461_("receiver"))).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Ribbon ribbon) {
        return new Builder().type(ribbon.type).receivedDate(ribbon.receivedDate).receiver(ribbon.receiver);
    }

    public static class Builder {
        protected String type;
        protected long receivedDate;
        protected Component receiver;
        protected MutableRibbonData ribbonData;

        protected Builder() {
        }

        public Builder type(RibbonType type) {
            this.type = type.id();
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder receivedDate(long receivedDate) {
            this.receivedDate = receivedDate;
            return this;
        }

        public Builder receiver(ServerPlayer player) {
            if (player == null) {
                this.receiver = Component.m_237119_();
                return this;
            }
            this.receiver = player.m_7755_();
            return this;
        }

        public Builder receiver(Component receiver) {
            this.receiver = receiver;
            return this;
        }

        public Builder ribbonData(MutableRibbonData ribbonData) {
            this.ribbonData = ribbonData;
            return this;
        }

        public Ribbon build() {
            if (this.ribbonData != null) {
                return new Ribbon(this.type, this.receivedDate, this.receiver, this.ribbonData);
            }
            return new Ribbon(this.type, this.receivedDate, this.receiver);
        }
    }
}

