/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ribbon;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.Ribbon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.type.RibbonType;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class MutableRibbonData {
    protected Component prefix;
    protected Component suffix;
    protected Component title;
    protected Component description;
    protected ResourceWithFallback icon;
    protected PaletteProperties overridePalette;

    public MutableRibbonData() {
    }

    protected MutableRibbonData(Component prefix, Component suffix, Component title, Component description, ResourceWithFallback icon, PaletteProperties overridePalette) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.overridePalette = overridePalette;
    }

    public static MutableRibbonData fromType(RibbonType ribbonType, Pokemon pokemon, Ribbon ribbon) {
        return new MutableRibbonData().setPrefix(ribbonType.getNamePrefix(pokemon, ribbon)).setSuffix(ribbonType.getNameSuffix(pokemon, ribbon)).setTitle((Component)ribbonType.getTranslatedName()).setDescription(ribbonType.getDescription()).setIcon(ribbonType.getIcon(pokemon, ribbon)).setOverridePalette(ribbonType.getPaletteOverride(pokemon, ribbon));
    }

    public Component getPrefix() {
        return this.prefix;
    }

    public MutableRibbonData setPrefix(Component prefix) {
        this.prefix = prefix;
        return this;
    }

    public Component getSuffix() {
        return this.suffix;
    }

    public MutableRibbonData setSuffix(Component suffix) {
        this.suffix = suffix;
        return this;
    }

    public Component getTitle() {
        return this.title;
    }

    public MutableRibbonData setTitle(Component title) {
        this.title = title;
        return this;
    }

    public Component getDescription() {
        return this.description;
    }

    public MutableRibbonData setDescription(Component description) {
        this.description = description;
        return this;
    }

    public ResourceWithFallback getIcon() {
        return this.icon;
    }

    public MutableRibbonData setIcon(ResourceWithFallback icon) {
        this.icon = icon;
        return this;
    }

    public PaletteProperties getOverridePalette() {
        return this.overridePalette;
    }

    public MutableRibbonData setOverridePalette(PaletteProperties overridePalette) {
        this.overridePalette = overridePalette;
        return this;
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.prefix != null);
        if (this.prefix != null) {
            buffer.m_130083_(this.prefix);
        }
        buffer.writeBoolean(this.suffix != null);
        if (this.suffix != null) {
            buffer.m_130083_(this.suffix);
        }
        buffer.m_130083_(this.title);
        buffer.m_130083_(this.description);
        buffer.m_130070_(RibbonRegistry.GSON.toJson((Object)this.icon));
        buffer.writeBoolean(this.overridePalette != null);
        if (this.overridePalette != null) {
            buffer.m_130070_(RibbonRegistry.GSON.toJson((Object)this.overridePalette));
        }
    }

    public static MutableRibbonData fromBuffer(FriendlyByteBuf buffer) {
        MutableRibbonData ribbonData = new MutableRibbonData();
        if (buffer.readBoolean()) {
            ribbonData.setPrefix(buffer.m_130238_());
        }
        if (buffer.readBoolean()) {
            ribbonData.setSuffix(buffer.m_130238_());
        }
        ribbonData.setTitle(buffer.m_130238_()).setDescription(buffer.m_130238_()).setIcon((ResourceWithFallback)RibbonRegistry.GSON.fromJson(buffer.m_130277_(), ResourceWithFallback.class));
        if (buffer.readBoolean()) {
            ribbonData.setOverridePalette((PaletteProperties)RibbonRegistry.GSON.fromJson(buffer.m_130277_(), PaletteProperties.class));
        }
        return ribbonData;
    }
}

