/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.logic;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.logic.BallLogic;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import net.minecraft.world.entity.player.Player;

public class LevelBall
implements BallLogic {
    @Override
    public double getCatchBonus(PokeBall type, PokeBallEntity entity, Player thrower, Pokemon pokemon, PokeBallMode mode) {
        double ballBonus = type.getCatchBonus();
        if (mode == PokeBallMode.BATTLE) {
            BattleController bc = BattleRegistry.getBattle(thrower);
            if (bc == null) {
                return ballBonus;
            }
            int ownerPokemonLevel = 0;
            for (BattleParticipant p : bc.participants) {
                if (p.getEntity() != thrower) continue;
                for (PixelmonWrapper pw : p.controlledPokemon) {
                    ownerPokemonLevel = Math.max(ownerPokemonLevel, pw.getPokemonLevelNum());
                }
            }
            int targetPokemonLevel = pokemon.getPokemonLevel();
            if (ownerPokemonLevel > 4 * targetPokemonLevel) {
                ballBonus = 8.0;
            } else if (ownerPokemonLevel > 2 * targetPokemonLevel) {
                ballBonus = 4.0;
            } else if (ownerPokemonLevel > targetPokemonLevel) {
                ballBonus = 2.0;
            }
        }
        return ballBonus;
    }
}

